/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.core.config.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.mscommon.freeze.core.config.service.FreezeMappingService;
import kd.mpscmm.mscommon.freeze.core.config.vo.BizEntity;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeMappingSetting;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeSetting;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class FreezeSettingService {
    private static final Log log = LogFactory.getLog(FreezeSettingService.class);
    private static final String FREEZE_SETTING_FIELDS = new StringJoiner(",").add("freezeobj").add("providerentity").add("billopnumber").add("billopname").add("filterjson_tag").add("filterformula_tag").toString();

    public static List<FreezeSetting> load(String entityNumber, String opKey, Long groupId) {
        QFilter qFilter = new QFilter("freezeobj", "=", (Object)entityNumber).and("billopnumber", "=", (Object)opKey).and("group", "=", (Object)groupId).and("enable", "=", (Object)Boolean.TRUE);
        return FreezeSettingService.load(qFilter);
    }

    private static List<FreezeSetting> load(QFilter qFilter) {
        Map settingMap = BusinessDataServiceHelper.loadFromCache((String)"msmod_freezesetting", (String)FREEZE_SETTING_FIELDS, (QFilter[])qFilter.toArray());
        List<FreezeSetting> freezeSettingList = FreezeSettingService.parseFreezeSettings(settingMap.values());
        if (CollectionUtils.isEmpty(freezeSettingList)) {
            log.info("\u51bb\u7ed3\u914d\u7f6e\u4e3a\u7a7a");
            return freezeSettingList;
        }
        String freezeEntityNumber = freezeSettingList.get(0).getFreezeEntity().getNumber();
        List<FreezeMappingSetting> mappings = FreezeMappingService.load(freezeEntityNumber);
        for (FreezeSetting freezeSetting : freezeSettingList) {
            freezeSetting.setFreezeMappingList(mappings);
        }
        return freezeSettingList;
    }

    private static List<FreezeSetting> parseFreezeSettings(Collection<DynamicObject> freezeSettings) {
        if (ObjectUtils.isEmpty(freezeSettings)) {
            return Collections.emptyList();
        }
        return freezeSettings.stream().map(item -> {
            FreezeSetting freezeSetting = new FreezeSetting();
            freezeSetting.setFreezeEntity(new BizEntity(item.getDynamicObject("freezeobj")));
            freezeSetting.setProviderEntity(new BizEntity(item.getDynamicObject("providerentity")));
            freezeSetting.setOpKey(item.getString("billopnumber"));
            freezeSetting.setOpName(item.getString("billopname"));
            freezeSetting.setFilterExpression(item.getString("filterformula_tag"));
            freezeSetting.setFilterJson(item.getString("filterjson_tag"));
            return freezeSetting;
        }).collect(Collectors.toList());
    }

    public static List<FreezeSetting> load(String freezeEntityNumber, Long groupId, String providerEntityNumber) {
        QFilter qFilter = new QFilter("freezeobj", "=", (Object)freezeEntityNumber).and("group", "=", (Object)groupId).and("providerentity", "=", (Object)providerEntityNumber).and("enable", "=", (Object)Boolean.TRUE);
        return FreezeSettingService.load(qFilter);
    }
}

