/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.core.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscommon.freeze.common.consts.FreezeTypeConst;
import kd.mpscmm.mscommon.freeze.core.config.service.FreezeMappingService;
import kd.mpscmm.mscommon.freeze.core.config.service.FreezeSettingService;
import kd.mpscmm.mscommon.freeze.core.config.vo.BizEntity;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeMappingField;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeMappingSetting;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeSetting;
import kd.mpscmm.mscommon.freeze.core.filter.BillFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class FreezeEngine {
    private static final Log log = LogFactory.getLog(FreezeEngine.class);

    public static void freeze(List<Long> ids, String entityNumber, String operationKey) {
        List<FreezeSetting> freezeSettingList = FreezeSettingService.load(entityNumber, operationKey, FreezeTypeConst.FREEZE);
        for (FreezeSetting freezeSetting : freezeSettingList) {
            Object[] freezeEntities;
            QFilter idFilter = new QFilter("id", "in", ids);
            idFilter.and(BillFilter.generateQFilter(entityNumber, freezeSetting.getFilterJson()));
            List filterIds = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])idFilter.toArray(), null, (int)10000);
            if (ObjectUtils.isEmpty((Object)filterIds) || ArrayUtils.isEmpty((Object[])(freezeEntities = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber))))) continue;
            FreezeEngine.generateFreezeLog((DynamicObject[])freezeEntities, null, freezeSetting);
        }
    }

    private static Object[] generateFreezeLog(DynamicObject[] freezeEntities, Map<Long, List<Long>> billIdMap, FreezeSetting freezeSetting) {
        if (CollectionUtils.isEmpty(freezeSetting.getFreezeMappingList())) {
            return new Object[0];
        }
        ArrayList freezeLogList = new ArrayList();
        for (FreezeMappingSetting freezeMappingSetting : freezeSetting.getFreezeMappingList()) {
            for (DynamicObject freezeEntity : freezeEntities) {
                CollectionUtils.addAll(freezeLogList, FreezeEngine.generateFreezeLog(freezeEntity, billIdMap, freezeSetting, freezeMappingSetting));
            }
        }
        Date now = new Date();
        for (DynamicObject freezeLog : freezeLogList) {
            freezeLog.set("creator", (Object)RequestContext.get().getCurrUserId());
            freezeLog.set("createtime", (Object)now);
        }
        return SaveServiceHelper.save((DynamicObject[])freezeLogList.toArray(new DynamicObject[freezeLogList.size()]));
    }

    private static List<DynamicObject> generateFreezeLog(DynamicObject dynamicObject, Map<Long, List<Long>> billIdMap, FreezeSetting freezeSetting, FreezeMappingSetting freezeMappingSetting) {
        DynamicObjectCollection collection = null;
        if (StringUtils.isNotBlank((CharSequence)freezeMappingSetting.getRecordEntryNumber())) {
            collection = dynamicObject.getDynamicObjectCollection(freezeMappingSetting.getRecordEntryNumber());
        } else {
            collection = new DynamicObjectCollection();
            collection.add((Object)dynamicObject);
        }
        if (ObjectUtils.isNotEmpty(billIdMap) && StringUtils.isNotBlank((CharSequence)freezeMappingSetting.getRecordEntryNumber())) {
            Long billId = dynamicObject.getLong("id");
            List<Long> entryIds = billIdMap.get(billId);
            HashSet<Long> entryIdSet = new HashSet<Long>(4);
            if (CollectionUtils.isNotEmpty(entryIds)) {
                entryIdSet.addAll(entryIds);
            }
            DynamicObjectCollection newCollection = new DynamicObjectCollection();
            for (DynamicObject entry : collection) {
                if (!entryIdSet.contains(entry.getPkValue())) continue;
                newCollection.add((Object)entry);
            }
            collection = newCollection;
        }
        ArrayList<DynamicObject> freezeLogs = new ArrayList<DynamicObject>();
        for (DynamicObject object : collection) {
            DynamicObject freezeLog = BusinessDataServiceHelper.newDynamicObject((String)"msmod_freezelog");
            for (FreezeMappingField freezeFieldMapping : freezeMappingSetting.getFreezeMappingFields()) {
                String srcFieldNumber = freezeFieldMapping.getSrcFieldNumber();
                if (StringUtils.equals((CharSequence)"freezeentrynumber", (CharSequence)freezeFieldMapping.getTargetFieldNumber())) {
                    freezeLog.set(freezeFieldMapping.getTargetFieldNumber(), (Object)srcFieldNumber);
                    freezeLog.set("freezeentryid", object.get("id"));
                    freezeLog.set("freezeentryseq", object.get("seq"));
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)freezeMappingSetting.getRecordEntryNumber())) {
                    freezeLog.set(freezeFieldMapping.getTargetFieldNumber(), object.get(srcFieldNumber));
                    continue;
                }
                if (StringUtils.startsWith((CharSequence)srcFieldNumber, (CharSequence)freezeMappingSetting.getRecordEntryNumber())) {
                    String fieldName = srcFieldNumber.substring(freezeMappingSetting.getRecordEntryNumber().length() + 1);
                    if (StringUtils.equals((CharSequence)freezeFieldMapping.getTargetFieldNumber(), (CharSequence)"material")) {
                        DynamicObject materiel = object.getDynamicObject(fieldName);
                        freezeLog.set(freezeFieldMapping.getTargetFieldNumber(), materiel.get("masterid"));
                        continue;
                    }
                    freezeLog.set(freezeFieldMapping.getTargetFieldNumber(), object.get(fieldName));
                    continue;
                }
                freezeLog.set(freezeFieldMapping.getTargetFieldNumber(), ((DynamicObject)object.getParent()).get(srcFieldNumber));
            }
            freezeLog.set("freezeentity", (Object)freezeSetting.getFreezeEntity().getNumber());
            freezeLog.set("providerentity", (Object)freezeSetting.getProviderEntity().getNumber());
            freezeLog.set("freezebillid", dynamicObject.get("id"));
            freezeLogs.add(freezeLog);
        }
        return freezeLogs;
    }

    public static Map<String, Object> freeze(String entityNumber, Map<Long, List<Long>> billIdMap, String providerEntityNumber) {
        Set<Long> ids = billIdMap.keySet();
        if (CollectionUtils.isEmpty(ids)) {
            return FreezeEngine.buildResultMap(billIdMap, false, ResManager.loadKDString((String)"\u51bb\u7ed3\u5931\u8d25\uff0c\u51bb\u7ed3\u5355\u636e\u5217\u8868\u4e3a\u7a7a\u3002", (String)"FreezeEngine_1", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]));
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
        int count = 0;
        FreezeSetting freezeSetting = new FreezeSetting();
        freezeSetting.setFreezeEntity(new BizEntity(null, entityNumber, entityNumber));
        freezeSetting.setProviderEntity(new BizEntity(null, providerEntityNumber, providerEntityNumber));
        List<FreezeMappingSetting> mappingSettings = FreezeMappingService.load(entityNumber);
        freezeSetting.setFreezeMappingList(mappingSettings);
        Object[] logs = FreezeEngine.generateFreezeLog(bills, billIdMap, freezeSetting);
        if ((count += logs.length) > 0) {
            return FreezeEngine.buildResultMap(billIdMap, true, ResManager.loadKDString((String)"\u51bb\u7ed3\u6210\u529f", (String)"FreezeEngine_0", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]));
        }
        return FreezeEngine.buildResultMap(billIdMap, false, ResManager.loadKDString((String)"\u51bb\u7ed3\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u76f8\u5173\u51bb\u7ed3\u914d\u7f6e\u3002", (String)"FreezeEngine_2", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]));
    }

    private static Map<String, Object> buildResultMap(Map<Long, List<Long>> billIdMap, boolean success, String message) {
        HashMap dataMap = new HashMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("success", success);
        returnMap.put("data", dataMap);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", success);
        resultMap.put("message", message);
        resultMap.put("code", success ? "success" : "fail");
        if (ObjectUtils.isNotEmpty(billIdMap)) {
            for (Map.Entry<Long, List<Long>> entry : billIdMap.entrySet()) {
                Long billId = entry.getKey();
                List<Long> entryIds = entry.getValue();
                for (Long entryId : entryIds) {
                    String key = billId + "_" + entryId;
                    dataMap.put(key, resultMap);
                }
            }
        }
        return returnMap;
    }
}

