/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.core.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mpscmm.mscommon.freeze.common.consts.FreezeTypeConst;
import kd.mpscmm.mscommon.freeze.core.config.service.FreezeMappingService;
import kd.mpscmm.mscommon.freeze.core.config.service.FreezeSettingService;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeMappingSetting;
import kd.mpscmm.mscommon.freeze.core.config.vo.FreezeSetting;
import kd.mpscmm.mscommon.freeze.core.filter.BillFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class UnFreezeEngine {
    private static final Log log = LogFactory.getLog(UnFreezeEngine.class);

    public static void unfreeze(List<Long> ids, String entityNumber, String operationKey) {
        List<FreezeSetting> freezeSettingList = FreezeSettingService.load(entityNumber, operationKey, FreezeTypeConst.UN_FREEZE);
        for (FreezeSetting freezeSetting : freezeSettingList) {
            Object[] freezeEntities;
            QFilter idFilter = new QFilter("id", "in", ids);
            idFilter.and(BillFilter.generateQFilter(entityNumber, freezeSetting.getFilterJson()));
            List filterIds = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])idFilter.toArray(), null, (int)10000);
            if (ObjectUtils.isEmpty((Object)filterIds) || ArrayUtils.isEmpty((Object[])(freezeEntities = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber))))) continue;
            UnFreezeEngine.delFreezeLog((DynamicObject[])freezeEntities, freezeSetting);
        }
    }

    private static QFilter generateBatchDeleteQFilter(QFilter qFilter, FreezeMappingSetting mapping, Map<Long, List<Long>> billIdMap) {
        qFilter.and("freezebillid", "in", billIdMap.keySet());
        String entryNumber = mapping.getRecordEntryNumber();
        if (StringUtils.isNotBlank((CharSequence)entryNumber)) {
            HashSet entryIdSet = new HashSet();
            billIdMap.forEach((billId, entryIds) -> entryIdSet.addAll(entryIds));
            qFilter.and("freezeentrynumber", "=", (Object)entryNumber);
            qFilter.and("freezeentryid", "in", entryIdSet);
        }
        return qFilter;
    }

    private static void delFreezeLog(DynamicObject[] freezeEntities, FreezeSetting freezeSetting) {
        QFilter qFilter = UnFreezeEngine.generateDelQFilter(freezeEntities, freezeSetting);
        DeleteServiceHelper.delete((String)"msmod_freezelog", (QFilter[])qFilter.toArray());
    }

    private static QFilter generateDelQFilter(DynamicObject[] freezeEntities, FreezeSetting freezeSetting) {
        QFilter qFilter = new QFilter("freezeentity", "=", (Object)freezeSetting.getFreezeEntity().getNumber());
        qFilter.and("providerentity", "=", (Object)freezeSetting.getProviderEntity().getNumber());
        qFilter.and("freezebillid", "in", (Object)Stream.of(freezeEntities).map(item -> item.getLong("id")).toArray());
        return qFilter;
    }

    public static Map<String, Object> unfreeze(String freezeEntityNumber, Map<Long, List<Long>> billIdMap, String providerEntityNumber) {
        if (ObjectUtils.isEmpty(billIdMap)) {
            return UnFreezeEngine.buildResultMap(billIdMap, false, ResManager.loadKDString((String)"\u89e3\u51bb\u5931\u8d25\uff0c\u51bb\u7ed3\u5355\u636e\u5217\u8868\u4e3a\u7a7a\u3002", (String)"UnFreezeEngine_1", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("freezeentity", "=", (Object)freezeEntityNumber);
        qFilter.and("providerentity", "=", (Object)providerEntityNumber);
        int deleteCnt = 0;
        List<FreezeMappingSetting> mappingSettings = FreezeMappingService.load(freezeEntityNumber);
        if (ObjectUtils.isNotEmpty(mappingSettings)) {
            for (FreezeMappingSetting mapping : mappingSettings) {
                QFilter newFilter = UnFreezeEngine.generateBatchDeleteQFilter(qFilter.copy(), mapping, billIdMap);
                deleteCnt += DeleteServiceHelper.delete((String)"msmod_freezelog", (QFilter[])newFilter.toArray());
            }
        }
        if (deleteCnt > 0) {
            return UnFreezeEngine.buildResultMap(billIdMap, true, ResManager.loadKDString((String)"\u89e3\u51bb\u6210\u529f", (String)"UnFreezeEngine_0", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]));
        }
        return UnFreezeEngine.buildResultMap(billIdMap, false, ResManager.loadKDString((String)"\u89e3\u51bb\u5931\u8d25\uff0c\u6ca1\u6709\u627e\u5230\u76f8\u5173\u89e3\u51bb\u914d\u7f6e\u3002", (String)"UnFreezeEngine_2", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]));
    }

    private static Map<String, Object> buildResultMap(Map<Long, List<Long>> billIdMap, boolean success, String message) {
        HashMap dataMap = new HashMap();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("success", success);
        returnMap.put("data", dataMap);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", success);
        resultMap.put("message", message);
        resultMap.put("code", success ? "success" : "fail");
        if (ObjectUtils.isNotEmpty(billIdMap)) {
            for (Map.Entry<Long, List<Long>> entry : billIdMap.entrySet()) {
                Long billId = entry.getKey();
                List<Long> entryIds = entry.getValue();
                for (Long entryId : entryIds) {
                    String key = billId + "_" + entryId;
                    dataMap.put(key, resultMap);
                }
            }
        }
        return returnMap;
    }
}

