/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.core.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ValidationDateCheckEngine {
    public static final String ORG_ID = "orgId";
    public static final String MATERIEL_ID = "materielId";
    public static final String ENTITY_MATERIALINVINFO = "bd_materialinventoryinfo";
    public static final String ENABLESHELFLIFEMGR = "enableshelflifemgr";
    public static final String CALDIRECTION = "caldirection";
    public static final String CALBOTH = "3";
    public static final String MASTERID = "masterid";

    public static Map<String, Object> check(List<Map<String, Long>> params) {
        HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
        Map group = params.stream().collect(Collectors.groupingBy(map -> (Long)map.get(ORG_ID), Collectors.mapping(map -> (Long)map.get(MATERIEL_ID), Collectors.toList())));
        boolean success = true;
        for (Map.Entry orgGroup : group.entrySet()) {
            Long orgId = orgGroup.getKey();
            List materielIds = orgGroup.getValue();
            QFilter materialInfoQfilter = BaseDataServiceHelper.getBaseDataFilter((String)ENTITY_MATERIALINVINFO, (Long)orgId);
            materialInfoQfilter.and(MASTERID, "in", materielIds);
            materialInfoQfilter.and("status", "=", (Object)Character.valueOf('C'));
            materialInfoQfilter.and("enable", "=", (Object)Boolean.TRUE);
            DataSet ds = QueryServiceHelper.queryDataSet((String)ValidationDateCheckEngine.class.getName(), (String)ENTITY_MATERIALINVINFO, (String)"id,masterid,enableshelflifemgr,caldirection", (QFilter[])materialInfoQfilter.toArray(), null);
            Throwable throwable = null;
            try {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    String key = orgId + "_" + row.getLong(MASTERID);
                    Map<String, Object> map2 = ValidationDateCheckEngine.checkShelfLife(orgId, row);
                    dataMap.put(key, map2);
                    if (!success) continue;
                    success = success && MapUtils.getBoolean(map2, (Object)"success") != false;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("success", success);
        returnMap.put("data", dataMap);
        return returnMap;
    }

    private static Map<String, Object> checkShelfLife(Long orgId, Row invMateriel) {
        String orgName = String.valueOf(orgId);
        String materialname = invMateriel.getString(MASTERID);
        boolean enableshelflifemgr = invMateriel.getBoolean(ENABLESHELFLIFEMGR);
        if (!enableshelflifemgr) {
            return ValidationDateCheckEngine.buildResultMap("DISABLE_SHELF_LIFE_MANAGER", ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u7269\u6599\u201c%2$s\u201d\u672a\u542f\u7528\u4fdd\u8d28\u671f\u7ba1\u7406\u3002", (String)"ValidationDateCheckEngine_0", (String)"mpscmm-mscommon-freeze", (Object[])new Object[]{orgName, materialname}));
        }
        String caldirection = invMateriel.getString(CALDIRECTION);
        if (StringUtils.equals((CharSequence)caldirection, (CharSequence)CALBOTH)) {
            return ValidationDateCheckEngine.buildResultMap("DISABLE_CHANGE_SHELF_LIFE", ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\uff0c\u7269\u6599\u201c%2$s\u201d\uff0c\u4fdd\u8d28\u671f\u8ba1\u7b97\u65b9\u5411\u4e3a\u201c\u76f8\u4e92\u8ba1\u7b97\u201d\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u201c\u5230\u671f\u65e5\u671f\u201d\u3002", (String)"ValidationDateCheckEngine_1", (String)"mpscmm-mscommon-freeze", (Object[])new Object[]{orgName, materialname}));
        }
        return ValidationDateCheckEngine.buildResultMap("success", ResManager.loadKDString((String)"\u6821\u9a8c\u6210\u529f", (String)"ValidationDateCheckEngine_2", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]));
    }

    private static Map<String, Object> buildResultMap(String code, String message) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("success", StringUtils.equals((CharSequence)code, (CharSequence)"success"));
        resultMap.put("code", code);
        resultMap.put("message", message);
        return resultMap;
    }
}

