/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscommon.freeze.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.mpscmm.mscommon.freeze.common.helper.FormShowHelper;

public class FreezeSettingEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"billopnumber"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (propertyName) {
            case "freezeobj": {
                this.freezeObjChange(newValue, oldValue);
                break;
            }
            case "billopnumber": {
                this.operationChange(newValue);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowHelper.setOperationItems(this.getModel(), this.getView(), "freezeobj", "billopnumber");
        this.updateCommonFilter();
        FilterGrid filterGrid = (FilterGrid)this.getControl("commonfilter");
        String commonFilterJson = this.getModel().getDataEntity().getString("filterjson_tag");
        FilterCondition condition = StringUtils.isBlank((CharSequence)commonFilterJson) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)commonFilterJson, FilterCondition.class);
        filterGrid.SetValue(condition);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        MessageBoxResult result = event.getResult();
        String customValue = event.getCustomVaule();
        if ("freezeobjCB".equals(callBackId)) {
            this.monitorConfirmCB(result, customValue);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": {
                this.beforeSave();
                break;
            }
        }
    }

    private void beforeSave() {
        IDataModel model = this.getModel();
        FilterGrid grid = (FilterGrid)this.getControl("commonfilter");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        DynamicObject freezeObj = this.getModel().getDataEntity().getDynamicObject("freezeobj");
        if (freezeObj == null) {
            return;
        }
        String freezeObjNum = freezeObj.getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)freezeObjNum);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        model.setValue("filterjson_tag", (Object)jsonStr);
        model.setValue("filterformula_tag", (Object)scripts[0]);
    }

    private void freezeObjChange(Object newValue, Object oldValue) {
        if (oldValue != null) {
            DynamicObject oldMonitor = (DynamicObject)oldValue;
            HashMap<String, Object> confirmInfo = new HashMap<String, Object>(16);
            confirmInfo.put("freezeobj", oldMonitor.getPkValue());
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u51bb\u7ed3/\u89e3\u51bb\u5355\u636e\u5c06\u6e05\u9664\u9875\u9762\u51bb\u7ed3/\u89e3\u51bb\u914d\u7f6e\u4fe1\u606f\uff0c\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"FreezeSettingEditPlugin_0", (String)"mpscmm-mscommon-freeze", (Object[])new Object[0]);
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("freezeobjCB", (IFormPlugin)this);
            this.getView().showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener, null, SerializationUtils.toJsonString(confirmInfo));
        } else {
            this.updateCommonFilter();
            FormShowHelper.setOperationItems(this.getModel(), this.getView(), "freezeobj", "billopnumber");
            this.getModel().setValue("billopnumber", null);
        }
    }

    private void operationChange(Object newValue) {
        if (newValue != null) {
            DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("freezeobj");
            if (monitorObj == null) {
                return;
            }
            String monitorObjNum = monitorObj.getString("number");
            List operations = EntityMetadataCache.getDataEntityOperate((String)monitorObjNum);
            for (Map operation : operations) {
                String opKey = (String)operation.get("key");
                if (!opKey.equals(newValue)) continue;
                Map opName = (Map)operation.get("name");
                this.getModel().setValue("billopname", opName.get("zh_CN"));
            }
        } else {
            this.getModel().setValue("billopname", null);
        }
    }

    private void monitorConfirmCB(MessageBoxResult result, String customValue) {
        if (StringUtils.isBlank((CharSequence)customValue)) {
            return;
        }
        Map confirmInfo = (Map)SerializationUtils.fromJsonString((String)customValue, Map.class);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            FormShowHelper.setOperationItems(this.getModel(), this.getView(), "freezeobj", "billopnumber");
            this.getModel().setValue("billopnumber", null);
            this.updateCommonFilter();
            this.getModel().setValue("filterformula_tag", null);
            this.getModel().setValue("filterjson_tag", null);
        } else {
            Object freezeObj = confirmInfo.get("freezeobj");
            this.getModel().beginInit();
            this.getModel().setValue("freezeobj", freezeObj);
            this.getView().updateView("freezeobj");
            this.getModel().endInit();
        }
    }

    private void updateCommonFilter() {
        DynamicObject freezeObj = this.getModel().getDataEntity().getDynamicObject("freezeobj");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfilter");
        if (freezeObj == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            filterGrid.setEntityNumber(null);
        } else {
            String freezeObjNum = freezeObj.getString("number");
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)freezeObjNum);
            List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType, true);
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(filterColumns);
            filterGrid.setEntityNumber(entityType.getName());
        }
        this.getView().updateView("commonfilter");
    }
}

