/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.mservice.esign;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.HandSignResult;
import kd.mpscmm.mscon.business.esign.service.impl.ElectronicSignServiceImpl;
import kd.mpscmm.mscon.common.utils.AESUtil;

public class SignNotifyWebApiPlugin
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(SignNotifyWebApiPlugin.class);

    public ApiResult doCustomService(WebApiContext ctx) {
        Map params = ctx.getData();
        logger.info("\u7535\u5b50\u7b7e\u7ae0\uff1abody:" + JSON.toJSONString((Object)params));
        if (!CollectionUtils.isEmpty((Map)params)) {
            String sign;
            String kdappid = (String)params.get("kdAppId");
            QFilter kdappidFilter = new QFilter("kdappid", "=", (Object)kdappid).and(new QFilter("resultcode", "=", (Object)"1"));
            DynamicObject subject = BusinessDataServiceHelper.loadSingle((String)"contractsubject", (String)"id,fiorg,uuid,companyid,resultcode,resultdesc", (QFilter[])new QFilter[]{kdappidFilter});
            if (subject == null) {
                logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1a\u83b7\u53d6kdappid\u5931\u8d25\uff1akdappid=" + kdappid);
                return this.getErrorApiResult();
            }
            String uuid = subject.getString("uuid");
            String signStr = AESUtil.decryptAES((String)uuid, (String)(sign = params.get("sign").toString()));
            if (StringUtils.isEmpty((String)signStr)) {
                logger.error("\u89e3\u5bc6\u5931\u8d25\uff1a" + JSON.toJSONString((Object)signStr));
                return this.getErrorApiResult();
            }
            JSONObject jsonObject = (JSONObject)JSON.parse((String)signStr);
            String data = jsonObject.getString("data");
            HandSignResult handSignResult = (HandSignResult)JSONObject.parseObject((String)data, HandSignResult.class);
            String userId = handSignResult.getUserId();
            String companyId = subject.getString("companyid");
            DynamicObject signer = null;
            if (StringUtils.isNotEmpty((String)userId) && StringUtils.isNotEmpty((String)companyId) && userId.equals(companyId)) {
                signer = subject.getDynamicObject("fiorg");
            } else {
                QFilter filter = new QFilter("companyid", "=", (Object)userId).and(new QFilter("resultcode", "=", (Object)"1"));
                DynamicObject companyauth = BusinessDataServiceHelper.loadSingleFromCache((String)"companyauth", (String)"id,bizpartner.name,resultcode,resultdesc", (QFilter[])new QFilter[]{filter});
                if (companyauth != null) {
                    signer = companyauth.getDynamicObject("bizpartner");
                }
            }
            if (signer == null) {
                logger.error("\u672a\u627e\u5230\u76f8\u5173\u7684\u7b7e\u7ae0\u7528\u6237");
                return this.getErrorApiResult();
            }
            Map queryMap = ctx.getQueryString();
            logger.info("\u7535\u5b50\u7b7e\u7ae0\uff1aquery-String:" + JSON.toJSONString((Object)queryMap) + ",\u7f16\u53f7\uff1a" + handSignResult.getContractNo() + "\u7ed3\u679c\uff1a" + handSignResult.getResultCode());
            if (!CollectionUtils.isEmpty((Map)queryMap)) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("signer", signer);
                boolean success = "1".equalsIgnoreCase(handSignResult.getResultCode());
                param.put("isSuccess", success);
                param.put("contractNo", handSignResult.getContractNo());
                param.put("createTime", handSignResult.getCreateTime());
                param.put("formId", queryMap.get("sign_entity"));
                if (success) {
                    OperationResult fileResult = this.getFileUrl(kdappid, handSignResult.getContractNo(), (String)queryMap.get("sign_entity"), subject.getDynamicObject("fiorg"), signer);
                    if (fileResult != null && fileResult.isSuccess() && StringUtils.isNotEmpty((String)fileResult.getMessage())) {
                        param.put("fileUrl", fileResult.getMessage());
                    } else {
                        logger.error("\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25");
                        return this.getErrorApiResult();
                    }
                }
                String cloud = (String)queryMap.get("sign_cloud");
                String app = (String)queryMap.get("sign_app");
                String service = (String)queryMap.get("sign_service");
                String method = (String)queryMap.get("sign_method");
                logger.info("\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u6210\u529f\uff0c\u5f00\u59cb\u8c03\u7528\u5fae\u670d\u52a1\uff0c\u4e91\uff1a" + cloud + ",\u5e94\u7528\uff1a" + app + ",\u670d\u52a1\u540d\u79f0\uff1a" + service + ",\u65b9\u6cd5\uff1a" + method);
                if (StringUtils.isNotEmpty((String)cloud) && StringUtils.isNotEmpty((String)app) && StringUtils.isNotEmpty((String)service) && StringUtils.isNotEmpty((String)method)) {
                    try {
                        DispatchServiceHelper.invokeBizService((String)cloud.toLowerCase(), (String)app, (String)service, (String)method, (Object[])new Object[]{param});
                    }
                    catch (Exception e) {
                        logger.error("\u8c03\u7528\u4e1a\u52a1\u5fae\u670d\u52a1\u5931\u8d25\uff1a" + e.getMessage());
                        return this.getErrorApiResult();
                    }
                }
            }
        } else {
            logger.error("\u53c2\u6570\u4e3a\u7a7a");
            return this.getErrorApiResult();
        }
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u7535\u5b50\u7b7e\u7ae0\u56de\u8c03\u6210\u529f", (String)"SignNotifyWebApiPlugin_2", (String)"mpscmm-mscon-webapi", (Object[])new Object[0]));
    }

    private ApiResult getErrorApiResult() {
        ApiResult fail = ApiResult.fail((String)ResManager.loadKDString((String)"\u7535\u5b50\u7b7e\u7ae0\u56de\u8c03\u5931\u8d25", (String)"SignNotifyWebApiPlugin_1", (String)"mpscmm-mscon-webapi", (Object[])new Object[0]));
        fail.setHttpStatus(Integer.valueOf(500));
        return fail;
    }

    private OperationResult getFileUrl(String kdappid, String contractNo, String formId, DynamicObject subject, DynamicObject signer) {
        ElectronicSignServiceImpl signService = new ElectronicSignServiceImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("kdappId", kdappid);
        map.put("subject", (String)subject);
        map.put("signer", (String)signer);
        map.put("billNo", contractNo);
        map.put("formId", formId);
        return signService.getFileUrl(map);
    }

    public String getVersion() {
        return "1.1";
    }
}

