/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.mservice.esign;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscon.business.esign.service.impl.ElectronicSignServiceImpl;

public class ElectronicSignService4Bos {
    private static Log logger = LogFactory.getLog(ElectronicSignService4Bos.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OperationResult beforeInvoke(Map<String, Object> map) {
        OperationResult result = new OperationResult();
        String signop = (String)map.get("signop");
        String subjectField = (String)map.get("subject");
        String signer = (String)map.get("signer");
        DynamicObject bill = (DynamicObject)map.get("bill");
        if (bill != null) {
            String billNoField = this.getBillNoField(bill.getDataEntityType().getName());
            DynamicObject billFromDb = this.getDynamicObjectFromDb(bill, subjectField, signer, billNoField);
            if (billFromDb != null) {
                DynamicObject subjectOrg = billFromDb.getDynamicObject(subjectField);
                if (subjectOrg == null) {
                    result.setSuccess(false);
                    result.setMessage(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u7b7e\u7ae0\u4e3b\u4f53\u201d\u76f8\u5173\u4fe1\u606f\u3002", (String)"ElectronicSignService4Bos_0", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
                    return result;
                }
                String subjectFieldType = subjectOrg.getDataEntityType().getName();
                if (!"bos_org".equals(subjectFieldType)) {
                    result.setSuccess(false);
                    result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u4e2d\u201c\u7b7e\u7ae0\u4e3b\u4f53\u201d\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicSignService4Bos_2", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
                    return result;
                }
                if ("B".equals(signop)) {
                    DynamicObject signerObj = billFromDb.getDynamicObject(signer);
                    if (signerObj == null) {
                        result.setSuccess(false);
                        result.setMessage(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u7b7e\u7ae0\u65b9\u201d\u76f8\u5173\u4fe1\u606f\u3002", (String)"ElectronicSignService4Bos_1", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
                        return result;
                    }
                    String signerFieldType = signerObj.getDataEntityType().getName();
                    if (!"bos_org".equals(subjectFieldType) && !"bd_bizpartner".equals(signerFieldType)) {
                        result.setSuccess(false);
                        result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u4e2d\u201c\u7b7e\u7ae0\u65b9\u201d\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u4e0d\u5408\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicSignService4Bos_3", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
                        return result;
                    }
                }
                if (!StringUtils.isEmpty((String)billNoField)) return result;
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728\u201c\u5355\u636e\u7f16\u7801\u201d\u7c7b\u578b\u5b57\u6bb5\u3002", (String)"ElectronicSignService4Bos_4", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
                return result;
            }
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"ElectronicSignService4Bos_5", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
            return result;
        }
        result.setSuccess(false);
        result.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"ElectronicSignService4Bos_5", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
        return result;
    }

    public OperationResult doInvoke(HashMap<String, Object> map) {
        String attachPanel;
        ElectronicSignServiceImpl signService = new ElectronicSignServiceImpl();
        String signop = (String)map.get("signop");
        String subjectField = (String)map.get("subject");
        String partnerField = (String)map.get("signer");
        DynamicObject bill = (DynamicObject)map.get("bill");
        String billNoField = this.getBillNoField(bill.getDataEntityType().getName());
        Map variable = (Map)map.get("variable");
        if (variable != null) {
            attachPanel = variable.getOrDefault("attachmentPanel", "signattachment");
            billNoField = variable.getOrDefault("billNoField", billNoField);
        } else {
            attachPanel = "signattachment";
        }
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        DynamicObject billFromDb = this.getDynamicObjectFromDb(bill, subjectField, partnerField, billNoField);
        if (billFromDb != null) {
            DynamicObject subjectOrg = billFromDb.getDynamicObject(subjectField);
            HashMap<String, Object> param = new HashMap<String, Object>();
            String formId = billFromDb.getDataEntityType().getName();
            param.put("subject", subjectOrg);
            param.put("formId", formId);
            param.put("billNo", billFromDb.getString(billNoField));
            if ("A".equals(signop)) {
                DynamicObject[] files = this.getAttachmentFiles(formId, billFromDb.getPkValue(), attachPanel);
                if (files.length == 0) {
                    result.setSuccess(false);
                    result.setMessage(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u5f85\u7b7e\u7ae0\u6587\u4ef6\u3002", (String)"ElectronicSignService4Bos_6", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
                } else if (files.length == 1) {
                    param.put("signer", subjectOrg);
                    param.put("fileUrl", files[0].getString("ffileid"));
                    param.put("fileName", files[0].getString("fattachmentname"));
                    logger.info("\u5408\u540c\u4e0a\u4f20\u53c2\u6570\uff1aformId:" + formId + ",billNo:" + billFromDb.getString(billNoField));
                    result = signService.create(param);
                    if (result.isSuccess()) {
                        param.put("notifyService", map.get("notifyservice"));
                        result = signService.upload(param);
                    }
                } else {
                    result.setSuccess(false);
                    result.setMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u6587\u4ef6\u7b7e\u7ae0\u3002", (String)"ElectronicSignService4Bos_7", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
                }
            } else if ("B".equals(signop)) {
                String displaytype = (String)map.get("displaytype");
                DynamicObject bizPartner = billFromDb.getDynamicObject(partnerField);
                param.put("signer", bizPartner);
                result = signService.getSignUrl(param);
                if (result.isSuccess()) {
                    String handSignUrl = result.getMessage();
                    if ("A".equals(displaytype)) {
                        result.setMessage(handSignUrl);
                    } else if ("B".equals(displaytype)) {
                        param.put("signer", bizPartner);
                        param.put("url", handSignUrl);
                        result = signService.sendSignUrl(param);
                    }
                }
            } else if ("C".equals(signop)) {
                result = signService.revoke(param);
            }
        } else {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"ElectronicSignService4Bos_5", (String)"mpscmm-mscon-mservice", (Object[])new Object[0]));
            return result;
        }
        return result;
    }

    DynamicObject[] getAttachmentFiles(String formId, Object id, String panel) {
        DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"fattachmentname,ffileid", (QFilter[])new QFilter[]{new QFilter("finterid", "=", (Object)String.valueOf(id)), new QFilter("fbilltype", "=", (Object)formId), new QFilter("fattachmentpanel", "=", (Object)panel)});
        return attachments;
    }

    private String getBillNoField(String formId) {
        BillEntityType billEntityType = (BillEntityType)MetadataServiceHelper.getDataEntityType((String)formId);
        return billEntityType.getBillNo();
    }

    private DynamicObject getDynamicObjectFromDb(DynamicObject bill, String subjectField, String signer, String billNo) {
        if (bill == null) {
            return null;
        }
        StringJoiner selectProperties = new StringJoiner(",");
        if (StringUtils.isNotEmpty((String)billNo)) {
            selectProperties.add(billNo);
        }
        if (StringUtils.isNotEmpty((String)subjectField)) {
            selectProperties.add(subjectField);
        }
        if (StringUtils.isNotEmpty((String)signer)) {
            selectProperties.add(signer);
        }
        if (StringUtils.isEmpty((String)selectProperties.toString())) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDataEntityType().getName(), (String)selectProperties.toString());
    }
}

