/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.basedata;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.cache.BusinessAppCache;
import kd.bos.entity.cache.IBusinessAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ParamDevConfigPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ParamDevConfigPlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "save": {
                this.save();
                break;
            }
            case "refresh": {
                this.load();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"ParamConfigPlugin_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
            }
        }
    }

    public void afterCreateNewData(EventObject evt) {
        this.load();
    }

    private void load() {
        IDataModel model = this.getModel();
        String sql = "select fappparam_tag,fcusparam_tag from t_mscon_devconfiginfo where fid = 0";
        Map map = (Map)DB.query((DBRoute)new DBRoute("scm"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet resultSet) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(2);
                while (resultSet.next()) {
                    map.put("appparam", resultSet.getString("fappparam_tag"));
                    map.put("cusparam", resultSet.getString("fcusparam_tag"));
                }
                return map;
            }
        });
        if (map != null && !map.isEmpty()) {
            String cusparam;
            String appparam = (String)map.get("appparam");
            if (appparam != null && !appparam.isEmpty()) {
                Map appparamMap = (Map)SerializationUtils.fromJsonString((String)appparam, Map.class);
                DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(model.getDataEntity().getDynamicObjectType());
                binder.setOnlyDbProperty(false);
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                jser.setSerializeComplexProperty(false);
                jser.deserializeFromMap(appparamMap, (Object)model.getDataEntity());
            }
            if ((cusparam = (String)map.get("cusparam")) != null && !cusparam.isEmpty()) {
                List customParameterList;
                List customParameterList1 = customParameterList = SerializationUtils.fromJsonStringToList((String)cusparam, Map.class);
                model.deleteEntryData("entryentity");
                customParameterList1.forEach(map1 -> {
                    int rowId = model.createNewEntryRow("entryentity");
                    model.setValue("parmname", map1.get("parmname"), rowId);
                    model.setValue("parmvalue", map1.get("parmvalue"), rowId);
                    model.setValue("description", map1.get("description"), rowId);
                });
            }
            this.getView().updateView();
        }
    }

    private void save() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Map<String, Object> jsonStringMap = this.getJsonStringMap(dataEntity);
        String appparam = SerializationUtils.toJsonString(jsonStringMap);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List entryList = entryEntity.stream().map(row -> {
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("parmname", row.getString("parmname"));
            map.put("parmvalue", row.getString("parmvalue"));
            map.put("description", row.getString("description"));
            return map;
        }).collect(Collectors.toList());
        String cusparam = SerializationUtils.toJsonString(entryList);
        String sql = "select fappparam_tag,fcusparam_tag from t_mscon_devconfiginfo where fid = 0";
        Map map = (Map)DB.query((DBRoute)new DBRoute("scm"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet resultSet) throws Exception {
                HashMap<String, String> map = new HashMap<String, String>(2);
                while (resultSet.next()) {
                    map.put("appparam", resultSet.getString("fappparam_tag"));
                    map.put("cusparam", resultSet.getString("fcusparam_tag"));
                }
                return map;
            }
        });
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(2);
        if (map != null && !map.isEmpty()) {
            sql = "UPDATE t_mscon_devconfiginfo SET fappparam_tag=? , fcusparam_tag=? WHERE FID = 0 ";
            params.add(new SqlParameter(":fappparam_tag", 12, (Object)appparam));
            params.add(new SqlParameter(":fcusparam_tag", 12, (Object)cusparam));
            this.saveOrUpdateParam(params, sql, true);
        } else {
            sql = "INSERT INTO t_mscon_devconfiginfo (FID, fappparam_tag,fcusparam_tag) VALUES (0, ?, ?)";
            params.add(new SqlParameter(":fappparam_tag", 12, (Object)appparam));
            params.add(new SqlParameter(":fcusparam_tag", 12, (Object)cusparam));
            this.saveOrUpdateParam(params, sql, false);
        }
        IBusinessAppCache cache = BusinessAppCache.get((String)"mscon");
        Map map1 = (Map)cache.get("mscon_param", Map.class);
        if (map1 != null && !map1.isEmpty()) {
            cache.remove("mscon_param");
        }
    }

    private Map<String, Object> getJsonStringMap(DynamicObject dataEntity) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
        binder.setOnlyDbProperty(false);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setSerializeComplexProperty(false);
        String jsonString = jser.serializeToString((Object)dataEntity, null);
        Map jsonStringMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            IDataEntityProperty property = (IDataEntityProperty)iterator.next();
            if (property instanceof BooleanProp && ((BooleanProp)property).getDefValue() != null && jsonStringMap.get(property.getName()) == null) {
                if (((Boolean)((BooleanProp)property).getDefValue()).booleanValue()) {
                    jsonStringMap.put(property.getName(), Boolean.TRUE);
                } else {
                    jsonStringMap.put(property.getName(), Boolean.FALSE);
                }
            }
            if (!(property instanceof ComboProp) && !(property instanceof TextProp) || !(property instanceof FieldProp) || ((FieldProp)property).getDefValue() == null || jsonStringMap.get(property.getName()) != null) continue;
            jsonStringMap.put(property.getName(), null);
        }
        return jsonStringMap;
    }

    private void saveOrUpdateParam(List<SqlParameter> params, String sql, boolean isUpdate) {
        try (TXHandle tx = TX.requiresNew();){
            if (isUpdate) {
                DB.update((DBRoute)new DBRoute("scm"), (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            } else {
                DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
            }
        }
    }
}

