/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.document.config;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscon.business.document.helper.DocumentEditHelper;
import kd.mpscmm.mscon.business.document.pojo.Document;
import kd.mpscmm.mscon.business.document.pojo.DocumentConfiguration;
import kd.mpscmm.mscon.business.document.pojo.OperateConfiguration;

public class DocumentConfigurationManager {
    private static final Log log = LogFactory.getLog(DocumentConfigurationManager.class);
    private DocumentConfiguration configuration;

    public DocumentConfiguration get(IFormView curView) {
        IFormView parentView = this.getParentView(curView);
        if (this.configuration == null) {
            IPageCache pageCache = curView.getPageCache();
            String paramsStr = pageCache.get("params");
            log.info("currentView params:" + paramsStr);
            if (StringUtils.isEmpty((String)paramsStr) && parentView != null) {
                log.info("parent View is not null");
                paramsStr = parentView.getPageCache().get("params");
                pageCache.put("params", paramsStr);
            }
            log.info("parentView params:" + paramsStr);
            if (StringUtils.isNotEmpty((String)paramsStr)) {
                Map params = (Map)SerializationUtils.fromJsonString((String)paramsStr, Map.class);
                this.configuration = this.parse(params);
            }
        }
        if (this.configuration != null) {
            DynamicObject bill;
            if (parentView != null && (bill = parentView.getModel().getDataEntity(true)) != null) {
                this.configuration.setDateEntity(bill);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u6863\u914d\u7f6e\u5931\u8d25\u3002", (String)"DocumentConfigurationManager_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        return this.configuration;
    }

    public void setCurrentDocument(Document document, IFormView curView) {
        IPageCache pageCache = curView.getPageCache();
        String paramsStr = pageCache.get("params");
        if (StringUtils.isNotEmpty((String)paramsStr)) {
            Map params = (Map)SerializationUtils.fromJsonString((String)paramsStr, Map.class);
            if (document != null) {
                Map<String, Object> map = DocumentEditHelper.documentToMap(document);
                params.put("openDocument", map);
            } else {
                params.put("openDocument", null);
            }
            pageCache.put("params", SerializationUtils.toJsonString((Object)params));
            this.configuration = this.parse(params);
        }
    }

    private DocumentConfiguration parse(Map<String, Object> params) {
        DynamicObject bill;
        String entityId = (String)params.get("entityId");
        Object pk = params.get("pkId");
        if (StringUtils.isNotEmpty((String)entityId) && pk != null && (bill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityId)) != null && StringUtils.isNotEmpty((String)entityId)) {
            DocumentConfiguration documentConfig = new DocumentConfiguration();
            documentConfig.setOperateConfig(this.mapToOperateSetting(params));
            documentConfig.setOperateKey((String)params.get("operatekey"));
            documentConfig.setEntityId(entityId);
            documentConfig.setPkId(pk);
            documentConfig.setDateEntity(bill);
            documentConfig.setEntityType(EntityMetadataCache.getDataEntityType((String)entityId));
            HashMap openDocument = (HashMap)params.get("openDocument");
            if (openDocument != null) {
                documentConfig.setOpenDocument(DocumentEditHelper.mapToDocument(openDocument));
            }
            return documentConfig;
        }
        return null;
    }

    private OperateConfiguration mapToOperateSetting(Map<String, Object> params) {
        OperateConfiguration operateSetting = new OperateConfiguration();
        String editForm = (String)params.get("editform");
        operateSetting.setEditForm(editForm);
        String operate = (String)params.get("operatekey");
        operateSetting.setOperate(operate);
        String pluginStr = (String)params.get("fserviceplugin");
        operateSetting.setPlugins(pluginStr);
        Map customParamStr = (Map)params.get("customParam");
        operateSetting.setCustomerParams(customParamStr);
        return operateSetting;
    }

    private IFormView getParentView(IFormView curView) {
        IFormView view = null;
        FormShowParameter showParameter = curView.getFormShowParameter();
        String pageId = (String)showParameter.getCustomParam("pageId");
        log.info("parent pageId:" + pageId);
        if (!StringUtils.isEmpty((String)pageId)) {
            try {
                String pageIdDecodeStr = URLDecoder.decode(URLDecoder.decode(pageId, "utf-8"), "utf-8");
                log.info("parent view pageId :" + pageIdDecodeStr);
                if (StringUtils.isNotEmpty((String)pageIdDecodeStr)) {
                    view = curView.getViewNoPlugin(pageIdDecodeStr);
                }
                if (view == null) {
                    log.error("parent view is null");
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return view;
    }

    public String getDefaultBizFolder() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        MainEntityType type = this.configuration.getEntityType();
        DynamicObject dataEntity = this.configuration.getDataEntity();
        String entityId = this.configuration.getEntityId();
        String appId = type.getAppId();
        Object pkId = dataEntity.getPkValue();
        if (StringUtils.isEmpty((String)appId)) {
            appId = "mscon";
        }
        if (StringUtils.isEmpty((String)entityId)) {
            entityId = "document";
        }
        if (pkId == null) {
            pkId = "0";
        }
        return FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (String)appId, (String)entityId, (Object)DocumentConfigurationManager.replaceSpeChar(String.valueOf(pkId)), (String)(uuid + "/"));
    }

    private static String replaceSpeChar(String str) {
        for (int i = 0; i < AttachmentServiceHelper.SPECIAL_CHARACTERS.length; ++i) {
            if (!str.contains(AttachmentServiceHelper.SPECIAL_CHARACTERS[i])) continue;
            str = str.replace(AttachmentServiceHelper.SPECIAL_CHARACTERS[i], "");
        }
        return str;
    }
}

