/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.document.helper;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscon.business.document.pojo.Document;
import kd.mpscmm.mscon.common.utils.FileHelper;

public class DocumentEditHelper {
    private static Log logger = LogFactory.getLog(DocumentEditHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document generateDocumentFromCache(String tempUrl, String fileName, String docType, String folder, boolean createNewFileWhenExists) {
        String documentName = fileName + "." + docType;
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try (InputStream inputStream = cache.getInputStream(tempUrl);){
            int docSize = inputStream.available();
            String url = FileHelper.upload(inputStream, documentName, DocumentEditHelper.getDefaultBizPath(folder, documentName), createNewFileWhenExists);
            if (docSize == 0) {
                try {
                    url = FileServiceFactory.getAttachmentFileService().getFileServiceExt().getRealPath(url);
                    docSize = AttachmentServiceHelper.getFileSizeByPath((String)url);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5931\u8d25", (Throwable)e);
                }
            }
            Document document = new Document();
            document.setUid(DocumentEditHelper.generateUid());
            document.setType(docType);
            document.setFileName(documentName);
            document.setUrl(url);
            document.setSize(docSize);
            Document document2 = document;
            return document2;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DocumentEditHelper_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
    }

    private static String getDefaultBizPath(String folder, String name) {
        return folder + "/" + name;
    }

    private static String generateUid() {
        return "rc-upload-" + System.currentTimeMillis() + "-" + new SecureRandom().nextInt(100);
    }

    public static Map<String, Object> documentToMap(Document document) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", document.getId());
        map.put("name", document.getFileName());
        map.put("size", document.getSize());
        map.put("type", document.getType());
        map.put("url", document.getUrl());
        map.put("uid", document.getUid());
        map.put("position", document.getPosition());
        map.put("attachEntity", document.getAttachEntity());
        Boolean template = document.isTemplate();
        map.put("isTemplate", template != null ? template.toString() : null);
        return map;
    }

    public static Document mapToDocument(Map<String, Object> documentMap) {
        Document document = new Document();
        document.setId(documentMap.get("id"));
        document.setAttachEntity((String)documentMap.get("attachEntity"));
        document.setSize((Integer)documentMap.get("size"));
        String url = (String)documentMap.get("url");
        if (StringUtils.isNotEmpty((String)url)) {
            try {
                String decodeUrl = URLDecoder.decode(url, "utf-8");
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                url = fileService.getFileServiceExt().getRealPath(decodeUrl);
            }
            catch (UnsupportedEncodingException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        document.setUrl(url);
        document.setUid((String)documentMap.get("uid"));
        document.setType((String)documentMap.get("type"));
        document.setFileName((String)documentMap.get("name"));
        document.setPosition((String)documentMap.get("position"));
        Object isTemplate = documentMap.get("isTemplate");
        if (isTemplate instanceof String) {
            document.isTemplate(Boolean.valueOf((String)isTemplate));
        } else {
            document.isTemplate((Boolean)isTemplate);
        }
        return document;
    }
}

