/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.document.service.reader;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.mscon.business.document.pojo.Document;
import kd.mpscmm.mscon.business.document.service.reader.IDocumentReader;

public class BaseDataPropDocumentReader
implements IDocumentReader {
    @Override
    public List<Document> read(String entity, Object pkId, String position) {
        ArrayList<Document> fileList = new ArrayList<Document>();
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entity);
        if (bill != null) {
            String entityId = bill.getDataEntityType().getName();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
            Map allFields = entityType.getAllFields();
            for (Map.Entry entry : allFields.entrySet()) {
                IDataEntityProperty value = (IDataEntityProperty)entry.getValue();
                if (!(value instanceof AttachmentProp) || position != null && !value.getName().equalsIgnoreCase(position)) continue;
                fileList.addAll(this.getFieldAttachments(bill, (String)entry.getKey()));
            }
        }
        return fileList;
    }

    private List<Document> getFieldAttachments(DynamicObject bill, String field) {
        String entityId = bill.getDataEntityType().getName();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        IDataEntityProperty property = entityType.findProperty(field);
        ArrayList<Document> fileList = new ArrayList<Document>();
        HashSet<Object> fileId = new HashSet<Object>();
        if (property instanceof AttachmentProp) {
            DynamicObject[] attachments;
            IDataEntityType parent = property.getParent();
            if (parent instanceof MainEntityType) {
                attachments = bill.getDynamicObjectCollection(field);
                if (attachments != null && attachments.size() > 0) {
                    for (DynamicObject attachment : attachments) {
                        Object fbasedataid = attachment.getDynamicObject("fbasedataid").getPkValue();
                        fileId.add(fbasedataid);
                    }
                }
            } else if (parent instanceof EntryType) {
                DynamicObjectCollection attachmentEntry = bill.getDynamicObjectCollection(parent.getName());
                for (DynamicObject entry : attachmentEntry) {
                    DynamicObjectCollection attactments = entry.getDynamicObjectCollection(field);
                    if (attactments == null || attactments.size() <= 0) continue;
                    for (DynamicObject attachment : attactments) {
                        DynamicObject dynamicObject = attachment.getDynamicObject("fbasedataid");
                        if (dynamicObject == null) continue;
                        Object fbasedataid = dynamicObject.getPkValue();
                        fileId.add(fbasedataid);
                    }
                }
            }
            if (fileId.size() > 0) {
                for (DynamicObject attachment : attachments = BusinessDataServiceHelper.load((String)"bd_attachment", (String)"name,url,size,uid,type", (QFilter[])new QFilter("id", "in", fileId).toArray())) {
                    Document document = new Document();
                    document.setId(attachment.getPkValue());
                    document.setFileName(((OrmLocaleValue)attachment.get("name")).getLocaleValue());
                    document.setSize(((Long)attachment.get("size")).intValue());
                    document.setUrl(attachment.getString("url"));
                    document.setUid(attachment.getString("uid"));
                    document.setPosition(field);
                    document.setType(attachment.getString("type"));
                    document.setAttachEntity("bd_attachment");
                    fileList.add(document);
                }
            }
        }
        return fileList;
    }
}

