/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.document.service.reader;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.mscon.business.document.pojo.Document;
import kd.mpscmm.mscon.business.document.service.reader.IDocumentReader;

public class PanelDocumentReader
implements IDocumentReader {
    @Override
    public List<Document> read(String entity, Object pkId, String position) {
        ArrayList<Document> fileList = new ArrayList<Document>();
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entity);
        if (bill != null) {
            String entityId = bill.getDataEntityType().getName();
            String id = MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Entity);
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
            List items = formMeta.getItems();
            for (ControlAp item : items) {
                if (!(item instanceof AttachmentPanelAp) || position != null && !item.getKey().equalsIgnoreCase(position) || item.isInvisible()) continue;
                fileList.addAll(this.getPenalAttachments(bill, item.getKey()));
            }
        }
        return fileList;
    }

    private List<Document> getPenalAttachments(DynamicObject bill, String panelIn) {
        String entityId = bill.getDataEntityType().getName();
        ArrayList<Document> fileList = new ArrayList<Document>();
        QFilter qFilter = new QFilter("finterid", "=", (Object)bill.getPkValue().toString()).and(new QFilter("fattachmentpanel", "=", (Object)panelIn)).and(new QFilter("fbilltype", "=", (Object)entityId));
        DynamicObjectCollection bos_attachment = QueryServiceHelper.query((String)"bos_attachment", (String)"id,fattachmentname,fattachmentsize,ffileid,fnumber,fattachmentpanel,fextname", (QFilter[])qFilter.toArray());
        for (DynamicObject attachment : bos_attachment) {
            Document document = new Document();
            document.setId(attachment.get("id"));
            document.setFileName((String)attachment.get("fattachmentname"));
            document.setSize(Integer.parseInt(attachment.getString("fattachmentsize")));
            document.setUrl(attachment.getString("ffileid"));
            document.setUid(attachment.getString("fnumber"));
            document.setPosition(attachment.getString("fattachmentpanel"));
            document.setAttachEntity("bos_attachment");
            document.setType(attachment.getString("fextname"));
            fileList.add(document);
        }
        return fileList;
    }
}

