/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.document.service.variable;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.DynamicObjectHelper;
import kd.mpscmm.mscon.business.document.service.variable.IDocumentVariableService;
import kd.mpscmm.mscon.common.utils.MetaDataHelper;

public class DocumentVariableDefaultService
implements IDocumentVariableService {
    private Map<String, Map<String, String>> varMapping;

    @Override
    public Object format(String variable, DynamicObject bill) {
        if (StringUtils.isEmpty((String)variable) || !variable.startsWith("variable")) {
            return null;
        }
        String billFieldKey = variable.substring(variable.indexOf(95) + 1);
        if (StringUtils.isEmpty((String)billFieldKey)) {
            return null;
        }
        if (this.varMapping == null) {
            this.varMapping = this.getTemplateVariableMapping(bill);
        }
        if (this.varMapping != null && this.varMapping.containsKey(variable)) {
            Map<String, String> varInfo = this.varMapping.get(variable);
            if (varInfo != null) {
                if ("A".equals(varInfo.get("vartype"))) {
                    String fieldKey = varInfo.get("srcfield");
                    return DynamicObjectHelper.getValue4Head((DynamicObject)bill, (String)fieldKey, (Boolean)Boolean.TRUE);
                }
                if ("B".equals(varInfo.get("vartype"))) {
                    String entryVar = varInfo.get("varnum");
                    String entryKey = entryVar.substring(entryVar.indexOf(95) + 1);
                    String srcField = varInfo.get("srcfield");
                    List entryFields = (List)JSON.parseObject((String)srcField, List.class);
                    if (entryFields != null && entryFields.size() > 0) {
                        return this.getEntryTable(bill, entryKey, entryFields);
                    }
                }
            }
        } else if (!Objects.equals("billentry", billFieldKey)) {
            return DynamicObjectHelper.getValue4Head((DynamicObject)bill, (String)billFieldKey, (Boolean)Boolean.TRUE);
        }
        return null;
    }

    private Map<String, Map<String, String>> getTemplateVariableMapping(DynamicObject bill) {
        HashMap<String, Map<String, String>> varMapping = new HashMap<String, Map<String, String>>();
        if (bill != null) {
            DynamicObject[] templates;
            String entityId = bill.getDataEntityType().getName();
            for (DynamicObject template : templates = BusinessDataServiceHelper.load((String)"conm_template", (String)"subentryentity.varnum,subentryentity.srcfield,subentryentity.vartype", (QFilter[])new QFilter[]{new QFilter("contentity.number", "=", (Object)entityId)})) {
                DynamicObjectCollection attachmentEntry = template.getDynamicObjectCollection("attachmententry");
                for (DynamicObject entry : attachmentEntry) {
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject subEntry : subEntrys) {
                        String varNum = subEntry.getString("varnum");
                        String srcField = subEntry.getString("srcfield");
                        String varType = subEntry.getString("vartype");
                        HashMap<String, String> varInfo = new HashMap<String, String>();
                        varInfo.put("varnum", varNum);
                        varInfo.put("srcfield", srcField);
                        varInfo.put("vartype", varType);
                        if (!StringUtils.isNotEmpty((String)varNum)) continue;
                        varMapping.put(varNum, varInfo);
                    }
                }
            }
        }
        return varMapping;
    }

    private String[][] getEntryTable(DynamicObject bill, String entryKey, List<String> entryFields) {
        if (bill == null || StringUtils.isEmpty((String)entryKey) || entryFields == null || entryFields.size() == 0) {
            return null;
        }
        List value4Entry = DynamicObjectHelper.getValue4Entry((DynamicObject)bill, (String)entryKey, entryFields, (Boolean)Boolean.TRUE);
        String[] entryTableHead = MetaDataHelper.getEntryTableHead((BillEntityType)bill.getDynamicObjectType(), entryFields);
        if (entryTableHead != null) {
            String[][] data = new String[value4Entry == null ? 1 : value4Entry.size() + 1][entryFields.size()];
            data[0] = entryTableHead;
            if (value4Entry != null) {
                for (int i = 0; i < value4Entry.size(); ++i) {
                    data[i + 1] = (String[])value4Entry.get(i);
                }
            }
            return data;
        }
        return null;
    }
}

