/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.document.service.writer;

import java.util.Date;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscon.business.document.pojo.Document;
import kd.mpscmm.mscon.business.document.service.writer.IDocumentWriter;

public class BaseDataPropDocumentWriter
implements IDocumentWriter {
    private static Log log = LogFactory.getLog(BaseDataPropDocumentWriter.class);

    @Override
    public Document insert(String entity, Object pkId, Document document) {
        log.info("BaseDataPropDocumentWriter document insert\uff1a{ entity\uff1a" + entity + ",pkId:" + pkId + ",operator:" + RequestContext.get().getUserName() + ",document:" + SerializationUtils.toJsonString((Object)document) + " }");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)entity);
        String output = document.getPosition();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
        IDataEntityProperty property = entityType.findProperty(output);
        if (property instanceof AttachmentProp) {
            IDataEntityType parent = property.getParent();
            if (parent instanceof MainEntityType) {
                DynamicObjectCollection attachments = bill.getDynamicObjectCollection(output);
                DynamicObject attachment = this.getBdAttachment(document);
                DynamicObject[] attachs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
                document.setId(attachs[0].getPkValue());
                DynamicObject aNew = attachments.addNew();
                aNew.set("fbasedataid", (Object)attachment);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            } else if (parent instanceof EntryType) {
                DynamicObjectCollection attachmentEntry = bill.getDynamicObjectCollection(parent.getName());
                DynamicObject newEntry = attachmentEntry.addNew();
                newEntry.set("seq", (Object)(attachmentEntry.size() + 1));
                DynamicObjectCollection attachmentField = newEntry.getDynamicObjectCollection(output);
                DynamicObject aNew = attachmentField.addNew();
                DynamicObject attachment = this.getBdAttachment(document);
                aNew.set("fbasedataid", (Object)attachment);
                newEntry.set(output, (Object)attachmentField);
                DynamicObject[] attachs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachment});
                document.setId(attachs[0].getPkValue());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            }
        }
        return document;
    }

    @Override
    public Document update(String entity, Object pkId, Document document) {
        DynamicObject attachment;
        log.info("BaseDataPropDocumentWriter document update\uff1a{ entity\uff1a" + entity + ",pkId:" + pkId + ",operator:" + RequestContext.get().getUserName() + ",document:" + SerializationUtils.toJsonString((Object)document) + " }");
        Object documentId = document.getId();
        if (documentId != null) {
            QFilter id = new QFilter("id", "=", document.getId());
            attachment = BusinessDataServiceHelper.loadSingle((String)"bd_attachment", (String)"size,uid,url,modifytime", (QFilter[])new QFilter[]{id});
            if (attachment == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u6e90\u6587\u4ef6\u3002", (String)"BaseDataPropDocumentWriter_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u6e90\u6587\u4ef6\u3002", (String)"BaseDataPropDocumentWriter_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        attachment.set("size", (Object)document.getSize());
        attachment.set("uid", (Object)document.getUid());
        attachment.set("url", (Object)document.getUrl());
        attachment.set("modifytime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{attachment});
        return document;
    }

    private DynamicObject getBdAttachment(Document document) {
        DynamicObject attachment = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
        long bd_attachment1 = DB.genLongId((String)"bd_attachment");
        attachment.set("id", (Object)bd_attachment1);
        attachment.set("name", (Object)document.getFileName());
        attachment.set("uid", (Object)document.getUid());
        attachment.set("url", (Object)document.getUrl());
        attachment.set("type", (Object)document.getType());
        attachment.set("creator", (Object)RequestContext.get().getUserId());
        attachment.set("createtime", (Object)new Date());
        attachment.set("tempfile", (Object)"1");
        attachment.set("number", (Object)UUID.randomUUID().toString());
        attachment.set("status", (Object)"B");
        attachment.set("size", (Object)document.getSize());
        return attachment;
    }
}

