/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.document.service.writer;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.mscon.business.document.pojo.Document;
import kd.mpscmm.mscon.business.document.service.writer.IDocumentWriter;

public class PanelDocumentWriter
implements IDocumentWriter {
    private static Log log = LogFactory.getLog(PanelDocumentWriter.class);

    @Override
    public Document insert(String entity, Object pkId, Document document) {
        log.info("PanelDocumentWriter document insert\uff1a{ entity\uff1a" + entity + ",pkId:" + pkId + ",operator:" + RequestContext.get().getUserName() + ",document:" + SerializationUtils.toJsonString((Object)document) + " }");
        Document bindFile = this.bindFile(document, entity, pkId, document.getPosition());
        return bindFile;
    }

    @Override
    public Document update(String entity, Object pkId, Document document) {
        DynamicObject attachment;
        log.info("PanelDocumentWriter document update\uff1a{ entity\uff1a" + entity + ",pkId:" + pkId + ",operator:" + RequestContext.get().getUserName() + ",document:" + SerializationUtils.toJsonString((Object)document) + " }");
        Object documentId = document.getId();
        if (documentId != null) {
            QFilter id = new QFilter("id", "=", documentId);
            attachment = BusinessDataServiceHelper.loadSingle((String)"bos_attachment", (String)"fattachmentsize,fnumber,ffileid,fcreatemen,fcreatetime", (QFilter[])new QFilter[]{id});
            if (attachment == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u6e90\u6587\u4ef6\u3002", (String)"PanelDocumentWriter_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u6e90\u6587\u4ef6\u3002", (String)"PanelDocumentWriter_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        attachment.set("fattachmentsize", (Object)document.getSize());
        attachment.set("fnumber", (Object)document.getUid());
        attachment.set("ffileid", (Object)document.getUrl());
        attachment.set("fcreatetime", (Object)new Date());
        attachment.set("fcreatemen", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{attachment});
        return document;
    }

    private Document bindFile(Document document, String formId, Object billId, String attachmentPanel) {
        ArrayList data = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", document.getFileName());
        map.put("url", document.getUrl());
        map.put("size", document.getSize());
        map.put("uid", document.getUid());
        data.add(map);
        AttachmentServiceHelper.upload((String)formId, (Object)billId, (String)attachmentPanel, data);
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("FNUMBER", "=", (Object)document.getUid()), new QFilter("FInterID", "=", (Object)billId.toString()), new QFilter("FBillType", "=", (Object)formId)};
        DynamicObject attachment = orm.queryOne("bos_attachment", "id,fextname", filters);
        document.setId(attachment.get("id"));
        document.setPosition(attachmentPanel);
        document.setAttachEntity("bos_attachment");
        return document;
    }
}

