/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.esign.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscon.business.esign.common.pojo.SignContext;
import kd.mpscmm.mscon.business.esign.common.pojo.SignResponse;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.HandSignData;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.MessageData;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.NotifyMService;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.UploadData;
import kd.mpscmm.mscon.business.esign.service.IElectronicService;
import kd.mpscmm.mscon.business.esign.utils.SignClient;

public class ElectronicSignServiceImpl
implements IElectronicService {
    private static Log logger = LogFactory.getLog(ElectronicSignServiceImpl.class);

    @Override
    public OperationResult create(Map<String, Object> argMap) {
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        result.setMessage(ResManager.loadKDString((String)"\u6b64\u529f\u80fd\u5b58\u5728\u8c03\u6574\uff0c\u4f7f\u7528\u524d\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ElectronicSignServiceImpl_6", (String)"mpscmm-mscon", (Object[])new Object[0]));
        return result;
    }

    @Override
    public OperationResult upload(Map<String, Object> map) {
        SignContext signContext = this.getContext(map);
        OperationResult result = this.validWithUser(signContext);
        if (result.isSuccess()) {
            String notifyService = (String)map.get("notifyService");
            String notifyUrl = this.dealNotifyUrl(notifyService, signContext);
            UploadData uploadData = new UploadData(signContext.getContractNo(), Collections.singletonList(signContext.getUserid()), Boolean.TRUE, Boolean.TRUE, notifyUrl);
            SignResponse uploadResult = SignClient.uploadContract(signContext.getKdappid(), signContext.getUuid(), signContext.getNonce(), uploadData);
            if (0 == uploadResult.getCode()) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setMessage(uploadResult.getMsg());
            }
        }
        return result;
    }

    @Override
    public OperationResult getSignUrl(Map<String, Object> map) {
        SignContext signContext = this.getContext(map);
        OperationResult result = this.validWithUser(signContext);
        if (result.isSuccess()) {
            HandSignData handSignData = new HandSignData(signContext.getContractNo(), Collections.singletonList(signContext.getUserid()));
            SignResponse handSignUrl = SignClient.getHandSignUrl(signContext.getKdappid(), signContext.getUuid(), signContext.getNonce(), handSignData);
            logger.info("\u83b7\u53d6\u624b\u7b7e\u5730\u5740\u54cd\u5e94\uff1a" + JSON.toJSONString((Object)handSignUrl));
            if (handSignUrl != null && 0 == handSignUrl.getCode()) {
                Map data = (Map)handSignUrl.getData();
                result.setSuccess(true);
                result.setMessage((String)data.get("handSignUrl"));
            } else if (handSignUrl == null) {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"ElectronicSignServiceImpl_5", (String)"mpscmm-mscon", (Object[])new Object[0]));
            } else {
                result.setSuccess(false);
                result.setMessage(handSignUrl.getMsg());
            }
        }
        return result;
    }

    @Override
    public OperationResult sendSignUrl(Map<String, Object> map) {
        SignContext signContext = this.getContext(map);
        OperationResult result = this.validWithUser(signContext);
        if (result.isSuccess()) {
            String url = (String)map.get("url");
            if (StringUtils.isNotEmpty((String)url)) {
                MessageData messageData = new MessageData(url, signContext.getUserid(), signContext.getConfig().getLinkMsg());
                SignResponse handSignUrl = SignClient.sendSignUrlToUser(signContext.getKdappid(), signContext.getUuid(), signContext.getNonce(), messageData);
                if (0 == handSignUrl.getCode()) {
                    result.setSuccess(true);
                    result.setMessage(ResManager.loadKDString((String)"\u53d1\u9001\u7b7e\u7ae0\u94fe\u63a5\u77ed\u4fe1\u6210\u529f\u3002", (String)"ElectronicSignServiceImpl_1", (String)"mpscmm-mscon", (Object[])new Object[0]));
                } else {
                    result.setSuccess(false);
                    result.setMessage(handSignUrl.getMsg());
                }
            } else {
                result.setSuccess(false);
                result.setMessage(ResManager.loadKDString((String)"\u7b7e\u7ae0\u94fe\u63a5\u4e3a\u7a7a", (String)"ElectronicSignServiceImpl_2", (String)"mpscmm-mscon", (Object[])new Object[0]));
            }
        }
        return result;
    }

    @Override
    public OperationResult revoke(Map<String, Object> map) {
        SignContext signContext = this.getContext(map);
        OperationResult result = this.validWithNoUser(signContext);
        if (result.isSuccess()) {
            SignResponse revokeSign = SignClient.revokeSign(signContext.getKdappid(), signContext.getUuid(), signContext.getNonce(), signContext.getContractNo());
            if (0 == revokeSign.getCode()) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setMessage(revokeSign.getMsg());
            }
        }
        return result;
    }

    @Override
    public OperationResult getFileUrl(Map<String, Object> map) {
        SignContext signContext = this.getContext(map);
        OperationResult result = this.validWithNoUser(signContext);
        if (result.isSuccess()) {
            SignResponse downResult = SignClient.getDownloadSignUrl(signContext.getKdappid(), signContext.getUuid(), signContext.getNonce(), signContext.getContractNo());
            if (0 == downResult.getCode()) {
                JSONObject sealInfo;
                JSONObject data0;
                JSONArray data = (JSONArray)downResult.getData();
                if (data != null && data.size() > 0 && (data0 = (JSONObject)data.get(0)) != null && data0.size() > 0 && (sealInfo = data0.getJSONObject("sealInfo")) != null) {
                    String downloadUrl = sealInfo.getString("downloadUrl");
                    result.setMessage(downloadUrl);
                    result.setSuccess(true);
                }
            } else {
                result.setSuccess(false);
                result.setMessage(downResult.getMsg());
            }
        }
        return result;
    }

    private SignContext getContext(Map<String, Object> argMap) {
        String billNo;
        String formId;
        SignContext signContext = new SignContext();
        signContext.setNonce(UUID.randomUUID().toString().replace("-", ""));
        signContext.setSignType("AES");
        DynamicObject subjectOrg = (DynamicObject)argMap.get("subject");
        DynamicObject subject = null;
        if (subjectOrg != null) {
            subject = BusinessDataServiceHelper.loadSingle((String)"contractsubject", (String)"fiorg,companyid,kdappid,uuid", (QFilter[])new QFilter[]{new QFilter("resultcode", "=", (Object)"1"), new QFilter("fiorg.id", "=", subjectOrg.getPkValue()), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")});
        }
        DynamicObject bizPartner = (DynamicObject)argMap.get("signer");
        DynamicObject signer = null;
        if (bizPartner != null && subjectOrg != null) {
            signer = subjectOrg.getLong("id") == bizPartner.getLong("id") ? subject : BusinessDataServiceHelper.loadSingle((String)"companyauth", (String)"bizpartner,companyid", (QFilter[])new QFilter[]{new QFilter("resultcode", "=", (Object)"1"), new QFilter("bizpartner.id", "=", bizPartner.getPkValue()), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")});
        }
        if (subject != null) {
            String kdappId = subject.getString("kdappid");
            String uuId = subject.getString("uuid");
            signContext.setKdappid(kdappId);
            signContext.setUuid(uuId);
        }
        if (signer != null) {
            String userId = signer.getString("companyid");
            signContext.setUserid(userId);
        }
        if (StringUtils.isNotEmpty((String)(formId = (String)argMap.get("formId")))) {
            signContext.setFormId(formId);
        }
        if (StringUtils.isNotEmpty((String)(billNo = (String)argMap.get("billNo")))) {
            signContext.setContractNo(billNo);
        }
        logger.info("\u5b9e\u4f53\uff1a" + formId + ",billNo:" + billNo);
        return signContext;
    }

    private String dealNotifyUrl(String notifyService, SignContext signContext) {
        NotifyMService serviceInfo = (NotifyMService)JSONObject.parseObject((String)notifyService, NotifyMService.class);
        String notifyUrl = signContext.getConfig().getNotifyUrl();
        String formId = signContext.getFormId();
        logger.info("\u5f53\u524d\u5b9e\u4f53\u7c7b\u578b\uff1a" + formId + ",\u7f16\u53f7\uff1a" + signContext.getContractNo());
        if (StringUtils.isNotEmpty((String)formId)) {
            notifyUrl = notifyUrl + "&sign_entity=" + formId;
        }
        String cloud = serviceInfo.getCloud();
        String app = serviceInfo.getApp();
        String service = serviceInfo.getService();
        String method = serviceInfo.getMethod();
        if (StringUtils.isNotEmpty((String)cloud) && StringUtils.isNotEmpty((String)app) && StringUtils.isNotEmpty((String)service) && StringUtils.isNotEmpty((String)method)) {
            notifyUrl = notifyUrl + "&sign_cloud=" + cloud + "&sign_app=" + app + "&sign_service=" + service + "&sign_method=" + method + "&";
        }
        return notifyUrl;
    }

    private OperationResult validWithUser(SignContext signContext) {
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        if (!signContext.hasAuth()) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u7b7e\u7ae0\u89d2\u8272\u4e0d\u53ef\u7528\u3002", (String)"ElectronicSignServiceImpl_3", (String)"mpscmm-mscon", (Object[])new Object[0]));
        } else if (!signContext.validParams()) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u7b7e\u7ae0\u53c2\u6570\u7f3a\u5931", (String)"ElectronicSignServiceImpl_4", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        return result;
    }

    private OperationResult validWithNoUser(SignContext signContext) {
        OperationResult result = new OperationResult();
        result.setSuccess(true);
        if (!StringUtils.isNotEmpty((String)signContext.getKdappid()) || !StringUtils.isNotEmpty((String)signContext.getUuid())) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u7b7e\u7ae0\u89d2\u8272\u4e0d\u53ef\u7528\u3002", (String)"ElectronicSignServiceImpl_3", (String)"mpscmm-mscon", (Object[])new Object[0]));
        } else if (!signContext.validParams()) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u7b7e\u7ae0\u53c2\u6570\u7f3a\u5931", (String)"ElectronicSignServiceImpl_4", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        return result;
    }
}

