/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.business.esign.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscon.business.esign.common.enums.SignNode;
import kd.mpscmm.mscon.business.esign.common.pojo.SignResponse;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.CreateData;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.HandSignData;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.MessageData;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.MustInput;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.SignData;
import kd.mpscmm.mscon.business.esign.common.pojo.dto.UploadData;
import kd.mpscmm.mscon.business.esign.config.DefaultSignConfig;
import kd.mpscmm.mscon.common.pojo.HttpClientResult;
import kd.mpscmm.mscon.common.utils.AESUtil;
import kd.mpscmm.mscon.common.utils.HttpClientUtil;

public class SignClient {
    private static Log logger = LogFactory.getLog(SignClient.class);

    public static SignResponse createContract(String kdAppId, String uuid, String nonce, CreateData data, String fileUrl, String fileName) {
        if (!SignClient.validMustInput(kdAppId, uuid, nonce, data).booleanValue() || StringUtils.isEmpty((String)fileUrl) || StringUtils.isEmpty((String)fileName)) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u5408\u540c\u521b\u5efa\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931\u3002", (String)"SignClient_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        if (!service.exists(fileUrl)) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u5408\u540c\u521b\u5efa\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"SignClient_1", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        String signStr = SignClient.encryptData(uuid, nonce, data);
        InputStream is = service.getInputStream(fileUrl);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sign", signStr);
        map.put("file", is);
        map.put("fileName", fileName);
        String url = SignClient.getFinalUrl(SignNode.CREATE, kdAppId, nonce);
        return SignClient.postFile(url, map);
    }

    public static SignResponse uploadContract(String kdAppId, String uuid, String nonce, UploadData data) {
        if (!SignClient.validMustInput(kdAppId, uuid, nonce, data).booleanValue()) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u5408\u540c\u4e0a\u4f20\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931\u3002", (String)"SignClient_2", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        String signStr = SignClient.encryptData(uuid, nonce, data);
        String url = SignClient.getFinalUrl(SignNode.UPLOAD, kdAppId, nonce);
        return SignClient.postJson(url, signStr);
    }

    public static SignResponse getHandSignUrl(String kdAppId, String uuid, String nonce, HandSignData data) {
        if (!SignClient.validMustInput(kdAppId, uuid, nonce, data).booleanValue()) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u83b7\u53d6\u7b7e\u7ae0\u5730\u5740\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931\u3002", (String)"SignClient_3", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        String signStr = SignClient.encryptData(uuid, nonce, data);
        String url = SignClient.getFinalUrl(SignNode.SIGN, kdAppId, nonce);
        return SignClient.postJson(url, signStr);
    }

    public static SignResponse sendSignUrlToUser(String kdAppId, String uuid, String nonce, MessageData data) {
        if (!SignClient.validMustInput(kdAppId, uuid, nonce, data).booleanValue()) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u53d1\u9001\u7b7e\u7ae0\u94fe\u63a5\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931\u3002", (String)"SignClient_4", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        String signStr = SignClient.encryptData(uuid, nonce, data);
        String url = SignClient.getFinalUrl(SignNode.MSG, kdAppId, nonce);
        return SignClient.postJson(url, signStr);
    }

    public static SignResponse getDownloadSignUrl(String kdAppId, String uuid, String nonce, String contractNo) {
        if (!SignClient.validMustInput(kdAppId, uuid, nonce, contractNo)) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931\u3002", (String)"SignClient_5", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        HashMap<String, String> downloadSignData = new HashMap<String, String>();
        downloadSignData.put("contractNo", contractNo);
        String signStr = SignClient.encryptData(uuid, nonce, downloadSignData);
        String url = SignClient.getFinalUrl(SignNode.FILE, kdAppId, nonce) + "&sign=" + signStr;
        return SignClient.get(url);
    }

    public static SignResponse revokeSign(String kdAppId, String uuid, String nonce, String contractNo) {
        if (!SignClient.validMustInput(kdAppId, uuid, nonce, contractNo)) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u5408\u540c\u64a4\u9500\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931\u3002", (String)"SignClient_6", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        HashMap<String, String> revokeSignData = new HashMap<String, String>();
        revokeSignData.put("contractNo", contractNo);
        String signStr = SignClient.encryptData(uuid, nonce, revokeSignData);
        String url = SignClient.getFinalUrl(SignNode.REVOKE, kdAppId, nonce);
        return SignClient.postJson(url, signStr);
    }

    private static Boolean validMustInput(String kdAppId, String uuid, String nonce, MustInput data) {
        return SignClient.validMustInput(kdAppId, uuid, nonce) || data != null && data.validMustInput() != false;
    }

    private static boolean validMustInput(String ... args) {
        for (String arg : args) {
            if (!StringUtils.isEmpty((String)arg)) continue;
            return false;
        }
        return true;
    }

    private static String encryptData(String uuid, String nonce, Object data) {
        SignData signData = new SignData(nonce, "1.0", data);
        logger.info("\u52a0\u5bc6\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)signData));
        return AESUtil.encryptAES(uuid, JSONObject.toJSONString((Object)signData));
    }

    private static String getFinalUrl(SignNode type, String kdAppId, String nonce) {
        String url = new DefaultSignConfig().getUrl(type.getName());
        if (StringUtils.isEmpty((String)url)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6Url\u5931\u8d25\u3002", (String)"SignClient_8", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        StringBuilder sb = new StringBuilder(url);
        sb.append("?kdAppId=").append(kdAppId).append("&nonce=").append(nonce).append("&signType=AES");
        return sb.toString();
    }

    private static SignResponse get(String url) {
        if (!SignClient.validMustInput(url)) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u53c2\u6570\u5f02\u5e38\u3002", (String)"SignClient_7", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        HttpClientResult clientResult = HttpClientUtil.doGet(url);
        return SignClient.convertResponse(clientResult);
    }

    private static SignResponse postJson(String url, String signStr) {
        if (!SignClient.validMustInput(url, signStr)) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u53c2\u6570\u5f02\u5e38\u3002", (String)"SignClient_7", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sign", signStr);
        String data = JSON.toJSONString(map);
        HttpClientResult clientResult = HttpClientUtil.doPostJson(url, null, data);
        return SignClient.convertResponse(clientResult);
    }

    private static SignResponse postFile(String url, Map<String, Object> args) {
        if (!SignClient.validMustInput(url) || args == null) {
            return new SignResponse(500, ResManager.loadKDString((String)"\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u53c2\u6570\u5f02\u5e38\u3002", (String)"SignClient_7", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        HttpClientResult clientResult = HttpClientUtil.doPostFile(url, null, args);
        return SignClient.convertResponse(clientResult);
    }

    private static SignResponse convertResponse(HttpClientResult clientResult) {
        String content = clientResult.getContent();
        int code = clientResult.getCode();
        logger.info("\u54cd\u5e94\uff1a" + content);
        if (200 == code) {
            return (SignResponse)JSONObject.parseObject((String)content, SignResponse.class);
        }
        return new SignResponse(code, content);
    }
}

