/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.common.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.util.StringUtils;

public class FileHelper {
    public static String upload(InputStream in, String fileName, String path, boolean createNewFileWhenExists) {
        FileItem fileItem = new FileItem(fileName, path, in);
        fileItem.setCreateNewFileWhenExists(createNewFileWhenExists);
        FileService service = FileServiceFactory.getAttachmentFileService();
        return service.upload(fileItem);
    }

    public static void delete(String url) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        fileService.delete(url);
    }

    public static InputStream wordToPdf(String path, String filename) {
        InputStream in = null;
        if (!StringUtils.isEmpty((String)filename) && !StringUtils.isEmpty((String)path)) {
            String subfix = filename.substring(filename.lastIndexOf(46) + 1);
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream doc = service.getInputStream(path);
            if (!"doc".equalsIgnoreCase(subfix) && !"docx".equalsIgnoreCase(subfix)) {
                in = doc;
            } else {
                try {
                    Map preview = service.preview(filename, path, RequestContext.get().getUserAgent());
                    String status = (String)preview.get(PreviewParams.STATUS.getEnumName());
                    if (!PreviewParams.ERROR.getEnumName().equals(status) && !PreviewParams.XLSX_SUCCESS.getEnumName().equals(status) && (PreviewParams.PDF_SUCCESS.getEnumName().equals(status) || PreviewParams.NOT_NEED_CHANGE.getEnumName().equals(status))) {
                        in = (InputStream)preview.get(PreviewParams.RESULT.getEnumName());
                    }
                }
                catch (Exception var8) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u670d\u52a1\u662f\u5426\u53ef\u7528\u3002", (String)"FileHelper_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
                }
            }
        }
        if (in == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u670d\u52a1\u662f\u5426\u53ef\u7528\u3002", (String)"FileHelper_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
        return in;
    }

    public static String wordToPdfFormCache(String path, String filename) {
        String url;
        block20: {
            block21: {
                url = null;
                if (StringUtils.isEmpty((String)filename) || StringUtils.isEmpty((String)path)) break block20;
                String subfix = filename.substring(filename.lastIndexOf(46) + 1);
                if (!"doc".equalsIgnoreCase(subfix) && !"docx".equalsIgnoreCase(subfix)) break block21;
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                String middleUrl = null;
                FileService service = FileServiceFactory.getAttachmentFileService();
                try (InputStream in = cache.getInputStream(path);){
                    middleUrl = FileHelper.upload(in, filename, FileHelper.getTempUrl(filename), false);
                    Map preview = service.preview(filename, middleUrl, RequestContext.get().getUserAgent());
                    String status = (String)preview.get(PreviewParams.STATUS.getEnumName());
                    if (!PreviewParams.ERROR.getEnumName().equals(status) && !PreviewParams.XLSX_SUCCESS.getEnumName().equals(status) && (PreviewParams.PDF_SUCCESS.getEnumName().equals(status) || PreviewParams.NOT_NEED_CHANGE.getEnumName().equals(status))) {
                        String name = filename.substring(0, filename.lastIndexOf(46));
                        url = cache.saveAsFullUrl(name, (InputStream)preview.get(PreviewParams.RESULT.getEnumName()), 120000);
                    }
                }
                catch (Exception var8) {
                    try {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u670d\u52a1\u662f\u5426\u53ef\u7528\u3002", (String)"FileHelper_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
                    }
                    catch (Throwable throwable) {
                        if (StringUtils.isNotEmpty(middleUrl)) {
                            service.delete(middleUrl);
                        }
                        throw throwable;
                    }
                }
                if (StringUtils.isNotEmpty((String)middleUrl)) {
                    service.delete(middleUrl);
                }
                break block20;
            }
            url = path;
        }
        return url;
    }

    private static String getTempUrl(String fileName) {
        RequestContext requestContext = RequestContext.get();
        String tenantCode = requestContext.getTenantCode();
        String accountId = requestContext.getAccountId();
        return "/" + tenantCode + "/" + accountId + "/mpscmm/mscon/temp/" + new Date().getTime() + "/" + fileName;
    }

    private static ByteArrayOutputStream readInputStream(InputStream inputStream) throws IOException {
        int len;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = inputStream.read(buffer)) > -1) {
            outputStream.write(buffer, 0, len);
        }
        outputStream.flush();
        return outputStream;
    }
}

