/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;

public class MetaDataHelper {
    public static Map<String, IDataEntityProperty> getAllFields(String entity) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        Map allFields = mainEntityType.getAllFields();
        return allFields;
    }

    public static Map<String, EntityType> getEntryEntity(String entity) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        Map allEntities = mainEntityType.getAllEntities();
        HashMap<String, EntityType> map = new HashMap<String, EntityType>();
        for (Map.Entry entry : allEntities.entrySet()) {
            String key = (String)entry.getKey();
            EntityType value = (EntityType)entry.getValue();
            if (!(value instanceof EntryType) || value instanceof SubEntryType || value instanceof LinkEntryType) continue;
            map.put(key, value);
        }
        return map;
    }

    public static IDataEntityProperty getFieldProperty(String entity, String field) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entity);
        DynamicProperty property = mainEntityType.getProperty(field);
        return property;
    }

    public static Map<String, IDataEntityProperty> getVisableFields(String entity) {
        HashMap<String, IDataEntityProperty> visableFields = new HashMap<String, IDataEntityProperty>();
        String id = MetadataDao.getIdByNumber((String)entity, (MetaCategory)MetaCategory.Entity);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        Map<String, IDataEntityProperty> allFields = MetaDataHelper.getAllFields(entity);
        for (ControlAp field : formMeta.getItems()) {
            String key;
            IDataEntityProperty property;
            if (!(field instanceof EntryFieldAp) && !(field instanceof FieldAp) || field.isHidden() || StringUtils.isBlank((String)field.getVisible()) || (property = allFields.get(key = field.getKey())) == null) continue;
            visableFields.put(key, property);
        }
        return visableFields;
    }

    public static Map<String, IDataEntityProperty> getEntryVisableFields(String entity, String entry) {
        HashMap<String, IDataEntityProperty> visableFields = new HashMap<String, IDataEntityProperty>();
        String id = MetadataDao.getIdByNumber((String)entity, (MetaCategory)MetaCategory.Entity);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        Map<String, IDataEntityProperty> allFields = MetaDataHelper.getAllFields(entity);
        for (ControlAp field : formMeta.getItems()) {
            IDataEntityProperty property;
            EntryFieldAp entryFieldAp;
            String parentId;
            ControlAp parentAp;
            if (!(field instanceof EntryFieldAp) || field.isHidden() || StringUtils.isBlank((String)field.getVisible()) || !((parentAp = formMeta.getItem(parentId = (entryFieldAp = (EntryFieldAp)field).getParentId())) instanceof EntryAp)) continue;
            String key = field.getKey();
            if (!entry.equals(parentAp.getKey()) || (property = allFields.get(key)) == null) continue;
            visableFields.put(key, property);
        }
        return visableFields;
    }

    public static Map<String, IDataEntityProperty> getAttachmentProps(String entityId) {
        HashMap<String, IDataEntityProperty> positionMap = new HashMap<String, IDataEntityProperty>();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        Map allFields = entityType.getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            if (!(property instanceof AttachmentProp)) continue;
            positionMap.put(property.getName(), property);
        }
        return positionMap;
    }

    public static Map<String, IDataEntityProperty> getTemplateVersionProps(String entityId) {
        HashMap<String, IDataEntityProperty> positionMap = new HashMap<String, IDataEntityProperty>();
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        Map allFields = entityType.getAllFields();
        for (Map.Entry entry : allFields.entrySet()) {
            String baseEntityId;
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            if (!(property instanceof BasedataProp) || !"conm_tempfileentry".equals(baseEntityId = ((BasedataProp)property).getBaseEntityId())) continue;
            positionMap.put(property.getName(), property);
        }
        return positionMap;
    }

    public static Map<String, AttachmentPanelAp> getAttachmentPanels(String entityId) {
        HashMap<String, AttachmentPanelAp> positionMap = new HashMap<String, AttachmentPanelAp>();
        String id = MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Entity);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List items = formMeta.getItems();
        for (ControlAp item : items) {
            if (!(item instanceof AttachmentPanelAp)) continue;
            String key = item.getKey();
            positionMap.put(key, (AttachmentPanelAp)item);
        }
        return positionMap;
    }

    public static List<String> getPositionList(String entityId) {
        ArrayList<String> positionList = new ArrayList<String>();
        Map<String, IDataEntityProperty> attachmentProps = MetaDataHelper.getAttachmentProps(entityId);
        positionList.addAll(attachmentProps.keySet());
        Map<String, AttachmentPanelAp> attachmentPanels = MetaDataHelper.getAttachmentPanels(entityId);
        positionList.addAll(attachmentPanels.keySet());
        return positionList;
    }

    public static String[] getEntryTableHead(BillEntityType entityType, List<String> entryFields) {
        if (entityType == null || entryFields == null || entryFields.size() == 0) {
            return null;
        }
        String[] headRow = new String[entryFields.size()];
        for (int i = 0; i < entryFields.size(); ++i) {
            String entryField = entryFields.get(i);
            headRow[i] = "seq".equals(entryField) ? ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"MetaDataHelper_0", (String)"mpscmm-mscon", (Object[])new Object[0]) : MetaDataHelper.buildFullCaption((MainEntityType)entityType, entryField);
        }
        return headRow;
    }

    public static String buildFullCaption(MainEntityType mainEntityType, String fullPropKey) {
        String caption = "";
        TreeNode nodes = MetaDataHelper.getEntityTreeNode(mainEntityType);
        if (StringUtils.isNotEmpty((String)fullPropKey)) {
            IDataEntityProperty property;
            String rootField = fullPropKey;
            if (rootField.contains(".")) {
                String[] split = rootField.split("\\.");
                rootField = split[0];
            }
            if ((property = mainEntityType.findProperty(rootField)) != null) {
                IDataEntityType parent = property.getParent();
                caption = parent instanceof MainEntityType ? (property instanceof EntryProp ? MetaDataHelper.getFullText(nodes, parent.getName(), fullPropKey) : MetaDataHelper.getFullText(nodes, "billhead", fullPropKey)) : MetaDataHelper.getFullText(nodes, parent.getName(), fullPropKey);
            }
        }
        return caption;
    }

    private static String getFullText(TreeNode treeNode, String topNode, String curId) {
        TreeNode curNode;
        String text = "";
        if (StringUtils.isNotEmpty((String)curId) && (curNode = treeNode.getTreeNode(curId)) != null) {
            text = curNode.getText();
            if (!curId.equals(topNode)) {
                String parentText;
                String parentId = curNode.getParentid();
                if (!topNode.equals(parentId) && StringUtils.isNotEmpty((String)(parentText = MetaDataHelper.getFullText(treeNode, topNode, parentId)))) {
                    text = parentText + "." + text;
                }
            } else {
                return text;
            }
        }
        return text;
    }

    private static TreeNode getEntityTreeNode(MainEntityType sourceMainType) {
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType);
        parameter.setOnlyPhysicsField(true);
        HashSet<Class> forbiden = new HashSet<Class>();
        forbiden.add(AttachmentProp.class);
        forbiden.add(PictureProp.class);
        parameter.setIncludePKField(false);
        parameter.setForbidClassType(forbiden);
        parameter.setForbidRefPropFieldTypes(forbiden);
        return EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
    }
}

