/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.formplugin.document;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeMark;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mpscmm.mscon.business.document.config.DocumentConfigurationManager;
import kd.mpscmm.mscon.business.document.pojo.DocumentConfiguration;
import kd.mpscmm.mscon.business.document.service.DocumentPluginExecutor;
import kd.mpscmm.mscon.business.document.service.variable.DocumentVariableDefaultService;
import kd.sdk.mpscmm.mscon.extpoint.documentedit.IDocumentPlugin;
import kd.sdk.mpscmm.mscon.extpoint.documentedit.events.BeforeReplaceVariableEvent;

public class DocumentEditFormPlugin
extends AbstractFormPlugin
implements WebOfficeDataListener {
    private static final String WEBOFFICEAP = "webofficeap";
    private DocumentConfigurationManager configManager = new DocumentConfigurationManager();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.addDataListener((WebOfficeDataListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        switch (key = evt.getItemKey().toLowerCase()) {
            case "btn_replace": {
                webOffice.getAllBookmarks("replaceMark");
                break;
            }
        }
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent e) {
        if (Objects.equals("replaceMark", e.getId())) {
            if (e.getBookmarks().size() > 0) {
                this.replaceMark(e.getBookmarks());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u53d8\u91cf\u66ff\u6362\u3002", (String)"DocumentEditFormPlugin_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
        }
    }

    private void replaceMark(List<String> bookmarks) {
        if (null == bookmarks || bookmarks.isEmpty()) {
            return;
        }
        DocumentConfiguration officeConfig = this.configManager.get(this.getView());
        DynamicObject model = officeConfig.getDataEntity();
        ArrayList<WebOfficeMark> marks = new ArrayList<WebOfficeMark>(16);
        BeforeReplaceVariableEvent beforeReplaceMarkEvent = new BeforeReplaceVariableEvent(model);
        beforeReplaceMarkEvent.setCustomParam(officeConfig.getOperateConfig().getCustomerParams());
        DocumentVariableDefaultService variableDefaultService = new DocumentVariableDefaultService();
        for (String mark : bookmarks) {
            beforeReplaceMarkEvent.setMark(mark);
            beforeReplaceMarkEvent.setValue(null);
            List<IDocumentPlugin> plugins = officeConfig.getOperateConfig().getPlugins();
            DocumentPluginExecutor pluginExecutor = DocumentPluginExecutor.newInstance(plugins);
            pluginExecutor.beforeReplaceVariable(beforeReplaceMarkEvent);
            Object data = beforeReplaceMarkEvent.getValue();
            if (data == null) {
                data = variableDefaultService.format(mark, model);
            }
            if (data == null) continue;
            if (data instanceof String[][]) {
                WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
                webOffice.addTable(mark, (String[][])data);
                continue;
            }
            if (data instanceof String) {
                marks.add(new WebOfficeMark(mark, data.toString()));
                continue;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d8\u91cf\u503c\u7c7b\u578b\u5fc5\u987b\u4e3aString[][]\u6216\u8005String\u3002", (String)"DocumentEditFormPlugin_3", (String)"mpscmm-mscon", (Object[])new Object[0]));
            return;
        }
        if (!marks.isEmpty()) {
            WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
            webOffice.modifyMarks(marks);
        }
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent webOfficeBookmarkCheckEvent) {
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent webOfficeDocChangeEvent) {
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent webOfficeBookmarkValueEvent) {
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent webOfficeCheckboxEvent) {
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent webOfficeIsFieldReviseEvent) {
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent webOfficeOpenStatusEvent) {
    }
}

