/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.formplugin.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.business.helper.BizGenerateParamHelper;
import kd.mpscmm.mscon.business.document.consts.PositionType;
import kd.mpscmm.mscon.common.utils.MetaDataHelper;
import kd.mpscmm.mscon.common.utils.ParamSettingsInfoHelper;

public class DocumentSavePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getControl("btnok");
        Button btncancel = (Button)this.getControl("btncancel");
        btnok.addClickListener((ClickListener)this);
        btncancel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String fileName = (String)showParameter.getCustomParam("fileName");
        if (StringUtils.isNotEmpty((CharSequence)fileName)) {
            this.getModel().setValue("filename", (Object)(fileName.lastIndexOf(46) != -1 ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName));
        }
        ComboEdit typeAp = (ComboEdit)this.getControl("type");
        ArrayList<ComboItem> typeList = new ArrayList<ComboItem>();
        List docTypeList = (List)showParameter.getCustomParam("docTypeList");
        ArrayList<String> docTypes = new ArrayList<String>(Arrays.asList("doc", "docx", "wps"));
        Map<String, Object> otherParams = ParamSettingsInfoHelper.getParams();
        Boolean supportPdf = (Boolean)otherParams.get("supportpdf");
        if (supportPdf == null) {
            supportPdf = BizGenerateParamHelper.exists((String)"conm_purcontract", (QFilter)new QFilter("billstatus", "=", (Object)"C"), null) || BizGenerateParamHelper.exists((String)"conm_salcontract", (QFilter)new QFilter("billstatus", "=", (Object)"C"), null) ? Boolean.TRUE : Boolean.FALSE;
            ParamSettingsInfoHelper.setParams("supportpdf", supportPdf);
        }
        if (supportPdf.booleanValue()) {
            docTypes.add("pdf");
        }
        for (String docType : docTypeList) {
            if (!docTypes.contains(docType)) continue;
            typeList.add(new ComboItem(new LocaleString(docType), docType));
        }
        typeAp.setComboItems(typeList);
        String fileType = (String)showParameter.getCustomParam("fileType");
        if (docTypes.contains(fileType)) {
            this.getModel().setValue("type", (Object)fileType);
        }
        ComboEdit positionAP = (ComboEdit)this.getControl("position");
        ArrayList<ComboItem> list = new ArrayList<ComboItem>();
        List positionList = (List)showParameter.getCustomParam("positionList");
        String entityId = (String)showParameter.getCustomParam("entityId");
        Map<String, IDataEntityProperty> attachmentProps = MetaDataHelper.getAttachmentProps(entityId);
        Map<String, AttachmentPanelAp> attachmentPanels = MetaDataHelper.getAttachmentPanels(entityId);
        if (positionList != null && !positionList.isEmpty()) {
            for (String position : positionList) {
                AttachmentPanelAp attachmentPanelAp;
                IDataEntityProperty property = attachmentProps.get(position);
                if (property != null) {
                    list.add(new ComboItem(property.getDisplayName(), position));
                }
                if ((attachmentPanelAp = attachmentPanels.get(position)) != null) {
                    list.add(new ComboItem(attachmentPanelAp.getName(), position));
                }
                if (!PositionType.LOCAL.getValue().equals(position)) continue;
                LocaleString localDownload = new LocaleString();
                localDownload.setLocaleValue(ResManager.loadKDString((String)"\u672c\u5730\u4e0b\u8f7d", (String)"DocumentSavePlugin_3", (String)"mpscmm-mscon", (Object[])new Object[0]));
                list.add(new ComboItem(localDownload, position));
            }
        }
        positionAP.setComboItems(list);
        String position = (String)showParameter.getCustomParam("position");
        if (StringUtils.isNotEmpty((CharSequence)position) && positionList.contains(position)) {
            this.getModel().setValue("position", (Object)position);
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (btn.getKey().equalsIgnoreCase("btnok")) {
            String filename = (String)this.getModel().getValue("filename");
            if (StringUtils.isBlank((CharSequence)filename)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DocumentSavePlugin_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("type")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DocumentSavePlugin_1", (String)"mpscmm-mscon", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.isBlank((CharSequence)((String)this.getModel().getValue("position")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DocumentSavePlugin_2", (String)"mpscmm-mscon", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(this.getData());
            this.getView().close();
        } else if (btn.getKey().equalsIgnoreCase("btncancel")) {
            this.getView().close();
        }
    }

    private Map<String, Object> getData() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            Object valueFast = property.getValueFast((Object)dataEntity);
            map.put(property.getName(), valueFast);
        }
        return map;
    }
}

