/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.formplugin.document;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.util.StringUtils;
import kd.mpscmm.mscon.common.utils.MetaDataHelper;

public class DocumentSelectPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getControl("btnok");
        Button btncancel = (Button)this.getControl("btncancel");
        btnok.addClickListener((ClickListener)this);
        btncancel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map params = showParameter.getCustomParams();
        List list = (List)params.get("list");
        if (list != null && list.size() > 0) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String entityId = (String)params.get("entityId");
            Map<String, AttachmentPanelAp> attachmentPanels = MetaDataHelper.getAttachmentPanels(entityId);
            Map<String, IDataEntityProperty> attachmentProps = MetaDataHelper.getAttachmentProps(entityId);
            Map<String, IDataEntityProperty> templateVersionProps = MetaDataHelper.getTemplateVersionProps(entityId);
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            for (Map map : list) {
                AttachmentPanelAp panelAp;
                IDataEntityProperty templateVersionProp;
                DynamicObject row = entryEntity.addNew();
                row.set("id", map.get("id"));
                row.set("name", map.get("name"));
                BigDecimal size = new BigDecimal((Integer)map.get("size")).divide(BigDecimal.valueOf(1024L)).setScale(2, RoundingMode.HALF_UP);
                row.set("size", (Object)(size + "KB"));
                row.set("url", map.get("url"));
                row.set("uid", map.get("uid"));
                String position = (String)map.get("position");
                row.set("position", (Object)position);
                row.set("attachentity", map.get("attachEntity"));
                row.set("istemplate", map.get("isTemplate"));
                String path = "";
                IDataEntityProperty property = attachmentProps.get(position);
                if (property != null) {
                    path = property.getDisplayName().getLocaleValue();
                }
                if (StringUtils.isEmpty((String)path) && (templateVersionProp = templateVersionProps.get(position)) != null) {
                    path = templateVersionProp.getDisplayName().getLocaleValue();
                }
                if (StringUtils.isEmpty((String)path) && (panelAp = attachmentPanels.get(position)) != null) {
                    path = panelAp.getName().getLocaleValue();
                }
                if (!StringUtils.isNotEmpty((String)path)) continue;
                row.set("path", (Object)path);
            }
            this.getView().updateView("entryentity");
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (btn.getKey().equalsIgnoreCase("btnok")) {
            HashMap data = this.getData();
            if (data != null) {
                this.getView().returnDataToParent((Object)this.getData());
                this.getView().close();
            }
        } else if (btn.getKey().equalsIgnoreCase("btncancel")) {
            this.getView().close();
        } else if (btn.getKey().equalsIgnoreCase("btnnew")) {
            this.getView().returnDataToParent(new HashMap());
            this.getView().close();
        }
    }

    private HashMap getData() {
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = grid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"DocumentSelectPlugin_0", (String)"mpscmm-mscon", (Object[])new Object[0]));
            return null;
        }
        if (selectRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\u3002", (String)"DocumentSelectPlugin_1", (String)"mpscmm-mscon", (Object[])new Object[0]));
            return null;
        }
        DynamicObject entity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = entity.getDynamicObjectCollection("entryentity");
        DynamicObject row = (DynamicObject)entryEntity.get(selectRows[0]);
        HashMap<String, Object> document = new HashMap<String, Object>();
        String fileName = row.getString("name");
        String type = fileName.substring(fileName.lastIndexOf(46) + 1);
        document.put("type", type);
        document.put("name", fileName);
        document.put("uid", row.getString("uid"));
        document.put("url", row.getString("url"));
        document.put("id", row.getLong("id"));
        document.put("position", row.getString("position"));
        document.put("attachEntity", row.getString("attachentity"));
        document.put("size", new BigDecimal(row.getString("size").replace("KB", "")).intValue() * 1024);
        document.put("isTemplate", row.getString("istemplate"));
        return document;
    }
}

