/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.mscon.formplugin.document;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.WebOffice;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.control.events.webOffice.WebOfficeDataListener;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkCheckEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeBookmarkValueEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeCheckboxEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeDocChangeEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeIsFieldReviseEvent;
import kd.bos.form.control.events.webOffice.event.WebOfficeOpenStatusEvent;
import kd.bos.form.control.model.WebOfficeFileType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.mpscmm.mscon.business.document.config.DocumentConfigurationManager;
import kd.mpscmm.mscon.business.document.consts.PositionType;
import kd.mpscmm.mscon.business.document.helper.DocumentEditHelper;
import kd.mpscmm.mscon.business.document.pojo.Document;
import kd.mpscmm.mscon.business.document.pojo.DocumentConfiguration;
import kd.mpscmm.mscon.business.document.pojo.OperateConfiguration;
import kd.mpscmm.mscon.business.document.service.DocumentPluginExecutor;
import kd.mpscmm.mscon.business.document.service.writer.DocumentWriterFactory;
import kd.mpscmm.mscon.business.document.service.writer.IDocumentWriter;
import kd.mpscmm.mscon.common.utils.FileHelper;
import kd.mpscmm.mscon.common.utils.MetaDataHelper;
import kd.mpscmm.mscon.common.utils.UrlServiceHelper;
import kd.sdk.mpscmm.mscon.extpoint.documentedit.IDocumentPlugin;
import kd.sdk.mpscmm.mscon.extpoint.documentedit.events.AfterSaveAsDocumentEvent;
import kd.sdk.mpscmm.mscon.extpoint.documentedit.events.BeforeOpenSaveAsFormEvent;
import kd.sdk.mpscmm.mscon.extpoint.documentedit.events.BeforeSaveAsDocumentEvent;

public class DocumentTplFormPlugin
extends AbstractFormPlugin
implements UploadListener,
WebOfficeDataListener {
    private static final Log log = LogFactory.getLog(DocumentTplFormPlugin.class);
    private static final String WEBOFFICEAP = "webofficeap";
    private DocumentConfigurationManager configManager = new DocumentConfigurationManager();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("toolbarap");
        toolbar.addItemClickListener((ItemClickListener)this);
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.addUploadListener((UploadListener)this);
        webOffice.addDataListener((WebOfficeDataListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DocumentConfiguration configuration = this.configManager.get(this.getView());
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.setMenubar(false);
        Document document = configuration.getOpenDocument();
        log.info("DocumentTplFormPlugin document open\uff1a{ entity\uff1a" + configuration.getEntityId() + ",pkId:" + configuration.getPkId() + ",operator:" + RequestContext.get().getUserName() + ",document:" + SerializationUtils.toJsonString((Object)document) + " }");
        if (document != null) {
            webOffice.open(UrlServiceHelper.getFullPath(document.getUrl()));
            webOffice.setCaption(document.getFileName());
        } else {
            webOffice.openNew(WebOfficeFileType.word);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        DocumentConfiguration officeConfig = this.configManager.get(this.getView());
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        switch (key = evt.getItemKey().toLowerCase()) {
            case "bar_saveas": {
                this.showSaveAsForm(officeConfig);
                break;
            }
            case "bar_save": {
                Document openDocument = officeConfig.getOpenDocument();
                if (!(openDocument == null || openDocument.isTemplate() != null && openDocument.isTemplate().booleanValue() || openDocument.getId() == null)) {
                    webOffice.save(openDocument.getFileName(), key);
                    break;
                }
                this.showSaveAsForm(officeConfig);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        if ("generateAttachment".equals(actionId)) {
            DocumentConfiguration officeConfig = this.configManager.get(this.getView());
            Map<String, Object> customerParams = officeConfig.getOperateConfig().getCustomerParams();
            if (returnData != null) {
                customerParams.putAll(returnData);
            }
            if (returnData != null) {
                String filename = (String)returnData.get("filename");
                String type = (String)returnData.get("type");
                this.getView().getPageCache().put("saveFormCallBackInfo", kd.bos.login.actions.SerializationUtils.toJsonString((Object)returnData));
                if (type.equalsIgnoreCase("pdf")) {
                    Document openDocument = officeConfig.getOpenDocument();
                    type = openDocument != null ? openDocument.getType() : "doc";
                }
                WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
                webOffice.save(filename + "." + type, "bar_saveas");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpload(UploadEvent evt) {
        DocumentConfiguration officeConfig = this.configManager.get(this.getView());
        if (!WEBOFFICEAP.equals(evt.getCallbackKey())) {
            return;
        }
        Object[] urls = evt.getUrls();
        Map urlData = (Map)urls[0];
        String opType = (String)urlData.get("id");
        String tempUrl = (String)urlData.get("url");
        String tempName = (String)urlData.get("name");
        String entityId = officeConfig.getEntityId();
        Object pkValue = officeConfig.getDataEntity().getPkValue();
        Map<String, Object> customerParams = officeConfig.getOperateConfig().getCustomerParams();
        List<IDocumentPlugin> plugins = officeConfig.getOperateConfig().getPlugins();
        DocumentPluginExecutor pluginExecutor = DocumentPluginExecutor.newInstance(plugins);
        try {
            if (Objects.equals("bar_save", opType)) {
                Document openDocument = officeConfig.getOpenDocument();
                if (openDocument != null) {
                    String position = openDocument.getPosition();
                    if (!(openDocument.isTemplate() != null && openDocument.isTemplate().booleanValue() || openDocument.getId() == null || PositionType.LOCAL.getValue().equals(position))) {
                        String fileName = (String)urlData.get("name");
                        String name = fileName.substring(0, fileName.lastIndexOf(46));
                        String type = fileName.substring(fileName.lastIndexOf(46) + 1);
                        Document srcDocument = officeConfig.getOpenDocument();
                        String url = srcDocument.getUrl();
                        String folder = url.substring(0, url.lastIndexOf(47));
                        Document trgDocument = DocumentEditHelper.generateDocumentFromCache(tempUrl, DocumentTplFormPlugin.fileNameSecurity(name), type, folder, false);
                        trgDocument.setAttachEntity(srcDocument.getAttachEntity());
                        trgDocument.setId(srcDocument.getId());
                        trgDocument.setPosition(srcDocument.getPosition());
                        trgDocument.isTemplate(srcDocument.isTemplate());
                        IDocumentWriter writer = this.getWriter(officeConfig.getEntityId(), srcDocument.getPosition());
                        writer.write(entityId, pkValue, trgDocument);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DocumentTplFormPlugin_1", (String)"mpscmm-mscon", (Object[])new Object[0]));
                    }
                }
            } else if (Objects.equals("bar_saveas", opType)) {
                IPageCache pageCache = this.getView().getPageCache();
                String saveFormCallBackInfo = pageCache.get("saveFormCallBackInfo");
                HashMap returnData = (HashMap)kd.bos.login.actions.SerializationUtils.fromJsonString((String)saveFormCallBackInfo, HashMap.class);
                String fileType = (String)returnData.get("type");
                String fileName = DocumentTplFormPlugin.fileNameSecurity((String)returnData.get("filename"));
                String position = (String)returnData.get("position");
                BeforeSaveAsDocumentEvent beforeSaveAsDocumentEvent = new BeforeSaveAsDocumentEvent();
                customerParams.putAll(returnData);
                beforeSaveAsDocumentEvent.setCustomParam(customerParams);
                beforeSaveAsDocumentEvent.setDataEntity(officeConfig.getDataEntity());
                HashMap<String, String> documentMap = new HashMap<String, String>();
                if ("pdf".equalsIgnoreCase(fileType)) {
                    tempUrl = FileHelper.wordToPdfFormCache(tempUrl, tempName);
                }
                documentMap.put("tempUrl", tempUrl);
                documentMap.put("name", fileName);
                documentMap.put("type", fileType);
                documentMap.put("position", position);
                beforeSaveAsDocumentEvent.setDocument(documentMap);
                pluginExecutor.beforeSaveAsDocument(beforeSaveAsDocumentEvent);
                if (!beforeSaveAsDocumentEvent.isCancel()) {
                    String bizFolder = this.configManager.getDefaultBizFolder();
                    Document document = DocumentEditHelper.generateDocumentFromCache(tempUrl, fileName, fileType, bizFolder, true);
                    document.setPosition(position);
                    document.isTemplate(Boolean.FALSE);
                    IDocumentWriter writer = this.getWriter(officeConfig.getEntityId(), position);
                    if (writer != null && (document = writer.write(entityId, pkValue, document)) != null) {
                        AfterSaveAsDocumentEvent afterSaveAsDocumentEvent = new AfterSaveAsDocumentEvent();
                        afterSaveAsDocumentEvent.setDataEntity(officeConfig.getDataEntity());
                        afterSaveAsDocumentEvent.setCustomParam(customerParams);
                        afterSaveAsDocumentEvent.setDocument(DocumentEditHelper.documentToMap(document));
                        pluginExecutor.afterSaveAsDocument(afterSaveAsDocumentEvent);
                        if (PositionType.LOCAL.getValue().equals(position)) {
                            String downLoadUrl = document.getUrl();
                            this.getView().download(downLoadUrl);
                        } else {
                            if (!"pdf".equalsIgnoreCase(fileType)) {
                                this.configManager.setCurrentDocument(document, this.getView());
                                this.setCaption(fileName + "." + fileType);
                            }
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53e6\u5b58\u4e3a\u6210\u529f\u3002", (String)"DocumentTplFormPlugin_2", (String)"mpscmm-mscon", (Object[])new Object[0]));
                        }
                    }
                }
            }
        }
        finally {
            TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            tempFileCache.remove(tempUrl);
        }
    }

    private IDocumentWriter getWriter(String entityId, String position) {
        Map<String, IDataEntityProperty> attachmentProps;
        PositionType outType = null;
        Map<String, AttachmentPanelAp> attachmentPanels = MetaDataHelper.getAttachmentPanels(entityId);
        if (attachmentPanels.containsKey(position)) {
            outType = PositionType.PANEL;
        }
        if ((attachmentProps = MetaDataHelper.getAttachmentProps(entityId)).containsKey(position)) {
            outType = PositionType.FIELD;
        }
        if (PositionType.LOCAL.getValue().equalsIgnoreCase(position)) {
            outType = PositionType.LOCAL;
        }
        IDocumentWriter documentWriter = DocumentWriterFactory.getWriter(outType);
        return documentWriter;
    }

    private void showSaveAsForm(DocumentConfiguration configuration) {
        DynamicObject model = configuration.getDataEntity();
        OperateConfiguration setting = configuration.getOperateConfig();
        Document openDocument = configuration.getOpenDocument();
        String entityId = configuration.getEntityId();
        BeforeOpenSaveAsFormEvent beforeOpenSaveAsFormEvent = new BeforeOpenSaveAsFormEvent(model);
        beforeOpenSaveAsFormEvent.setSaveAsFormId("mscon_documentsave");
        beforeOpenSaveAsFormEvent.setCustomParam(setting.getCustomerParams());
        List<String> positionList = MetaDataHelper.getPositionList(entityId);
        positionList.add(PositionType.LOCAL.getValue());
        beforeOpenSaveAsFormEvent.setPositionList(positionList);
        beforeOpenSaveAsFormEvent.setDocTypeList(Arrays.asList("doc", "docx", "wps", "pdf"));
        if (openDocument != null) {
            beforeOpenSaveAsFormEvent.setFileName(openDocument.getFileName());
            beforeOpenSaveAsFormEvent.setDocType(openDocument.getType());
            beforeOpenSaveAsFormEvent.setPosition(openDocument.getPosition());
        }
        List<IDocumentPlugin> plugins = setting.getPlugins();
        DocumentPluginExecutor pluginExecutor = DocumentPluginExecutor.newInstance(plugins);
        pluginExecutor.beforeOpenSaveAsForm(beforeOpenSaveAsFormEvent);
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(beforeOpenSaveAsFormEvent.getSaveAsFormId());
        OpenStyle openStyle = new OpenStyle();
        openStyle.setShowType(ShowType.Modal);
        parameter.setOpenStyle(openStyle);
        String fileName = beforeOpenSaveAsFormEvent.getFileName();
        parameter.setCustomParam("fileName", (Object)fileName);
        String docType = beforeOpenSaveAsFormEvent.getDocType();
        parameter.setCustomParam("fileType", (Object)docType);
        parameter.setCustomParam("position", (Object)beforeOpenSaveAsFormEvent.getPosition());
        parameter.setCustomParam("positionList", (Object)beforeOpenSaveAsFormEvent.getPositionList());
        parameter.setCustomParam("docTypeList", (Object)beforeOpenSaveAsFormEvent.getDocTypeList());
        parameter.setCustomParam("entityId", (Object)entityId);
        parameter.getCustomParams().putAll(beforeOpenSaveAsFormEvent.getCustomParam());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "generateAttachment"));
        this.getView().showForm(parameter);
    }

    private static String fileNameSecurity(String fileName) {
        for (int i = 0; i < AttachmentServiceHelper.SPECIAL_SYMBOLS.length; ++i) {
            if (!fileName.contains(AttachmentServiceHelper.SPECIAL_SYMBOLS[i])) continue;
            fileName = fileName.replace(AttachmentServiceHelper.SPECIAL_SYMBOLS[i], "_");
        }
        return fileName;
    }

    private void setCaption(String caption) {
        WebOffice webOffice = (WebOffice)this.getControl(WEBOFFICEAP);
        webOffice.setCaption(caption);
    }

    public void onGetAllBookmarks(WebOfficeBookmarkEvent e) {
    }

    public void onGetBookmarkCheckResult(WebOfficeBookmarkCheckEvent arg0) {
    }

    public void onGetTextByBookmark(WebOfficeBookmarkValueEvent arg0) {
    }

    public void onGetAllCheckBoxes(WebOfficeCheckboxEvent arg0) {
    }

    public void onIsFieldRevise(WebOfficeIsFieldReviseEvent arg0) {
    }

    public void onSendOpenStatus(WebOfficeOpenStatusEvent arg0) {
    }

    public void onGetDocChangeCheckResult(WebOfficeDocChangeEvent arg0) {
    }
}

