/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import org.apache.commons.collections4.CollectionUtils;

public class BotpRelationHelper {
    public static Map<Long, Map<String, Object>> findBotpRelation(MatcherConfig mathConditionConfig, List<IntegrationObject> integrationObjectList) {
        if (!mathConditionConfig.isBotpMatch()) {
            return Collections.emptyMap();
        }
        String entityKey = integrationObjectList.get(0).getBillNumber();
        HashSet<Long> billIds = new HashSet<Long>(integrationObjectList.size());
        String entryKey = integrationObjectList.get(0).getEntryNumber();
        HashSet<Long> entryIds = new HashSet<Long>(integrationObjectList.size());
        for (IntegrationObject integrationObject : integrationObjectList) {
            billIds.add((Long)integrationObject.getBillPkValue());
            entryIds.add((Long)integrationObject.getEntryPkValue());
        }
        String srcEntityKey = mathConditionConfig.getRelationBizObjectConfig().getBillNumber();
        return BotpRelationHelper.findBotpRelation(entityKey, entryKey, billIds, entryIds, srcEntityKey);
    }

    private static Map<Long, Map<String, Object>> findBotpRelation(String entityKey, String entryKey, Set<Long> billIds, Set<Long> entryIds, String srcEntityKey) {
        Object bfRow2;
        List bfRowList = BFTrackerServiceHelper.loadSourceRowIds((String)entityKey, (String)entryKey, (Long[])billIds.toArray(new Long[0]), (Long[])entryIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
        if (CollectionUtils.isEmpty((Collection)bfRowList)) {
            return Collections.emptyMap();
        }
        HashSet<Long> srcEntryIdSet = new HashSet<Long>(bfRowList.size());
        HashMap<Long, Long> idMapping = new HashMap<Long, Long>(bfRowList.size());
        for (Object bfRow2 : bfRowList) {
            idMapping.put(bfRow2.getId().getEntryId(), bfRow2.getSId().getEntryId());
            BFRowId sId = bfRow2.getSId();
            TableDefine entryTableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)sId.getTableId());
            if (!entryTableDefine.getEntityNumber().equals(srcEntityKey)) continue;
            srcEntryIdSet.add(sId.getEntryId());
        }
        if (CollectionUtils.isEmpty(srcEntryIdSet)) {
            return Collections.emptyMap();
        }
        HashMap startEndMap = new HashMap(entryIds.size());
        bfRow2 = entryIds.iterator();
        while (bfRow2.hasNext()) {
            Long entryId;
            Long endId = entryId = (Long)bfRow2.next();
            while (idMapping.containsKey(endId)) {
                startEndMap.put(entryId, idMapping.get(endId));
                endId = (Long)idMapping.get(endId);
            }
        }
        String pkField = StringUtils.equals((CharSequence)entityKey, (CharSequence)entryKey) ? "id" : entryKey + ".id";
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>(bfRowList.size());
        for (Map.Entry entry : startEndMap.entrySet()) {
            HashMap fieldMap = new HashMap(2);
            fieldMap.put(pkField, entry.getValue());
            resultMap.put((Long)entry.getKey(), fieldMap);
        }
        return resultMap;
    }
}

