/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;

public class EntityParseHelper {
    public static TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = EntityParseHelper.buildFldTreeNodes(parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(fldNodes.size());
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(BillTreeBuildParameter parameter) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        MainEntityType mainType = parameter.getMainType();
        HashSet<Object> selectedEntity = new HashSet(16);
        selectedEntity.addAll(parameter.getSelectedEntity());
        if (selectedEntity.isEmpty()) {
            selectedEntity = new HashSet(mainType.getAllEntities().keySet());
        }
        for (Map.Entry entry : mainType.getAllEntities().entrySet()) {
            EntityType entityType;
            if (!selectedEntity.contains(entry.getKey()) || (entityType = (EntityType)entry.getValue()) instanceof LinkEntryType) continue;
            String entityNodeId = entityType.getName();
            String entityNodeName = "";
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityParseHelper_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]);
                entityNodeId = "billhead";
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(mainType.getName(), entityNodeId, entityNodeName);
            entityNode.setIsOpened(true);
            ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
            if (parameter.isIncludePKField()) {
                EntityParseHelper.buildPKFldTreeNode(entityType, entityNode, entityFldNodes, parameter);
            }
            for (IDataEntityProperty property : entityType.getFields().values()) {
                BasedataProp bdProp;
                MainEntityType bdType;
                List<TreeNode> refNodes;
                boolean matched = false;
                if (parameter.isOnlyPhysicsField() && StringUtils.isBlank((CharSequence)property.getAlias()) || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName())) continue;
                TreeNode fldNode = EntityParseHelper.buildFldTreeNode(property, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
                if (fldNode != null) {
                    entityFldNodes.add(fldNode);
                    matched = true;
                }
                if (!(property instanceof BasedataProp)) continue;
                if (fldNode == null) {
                    fldNode = EntityParseHelper.buildFldTreeNode(property, null, null, entityNode, "", parameter.isDynamicText());
                }
                if ((refNodes = EntityParseHelper.BuildBDFldRefPropNodes(bdType = (MainEntityType)(bdProp = (BasedataProp)property).getComplexType(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), fldNode, property.getName(), parameter.isDynamicText())).isEmpty()) continue;
                entityFldNodes.addAll(refNodes);
                if (matched) continue;
                entityFldNodes.add(fldNode);
            }
            if (entityFldNodes.isEmpty()) continue;
            nodes.add(entityNode);
            nodes.addAll(entityFldNodes);
        }
        return nodes;
    }

    private static List<TreeNode> BuildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        for (IDataEntityProperty property : bdType.getFields().values()) {
            String prefix2;
            BasedataProp bdProp2;
            MainEntityType bdType2;
            List<TreeNode> refNodes2;
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = EntityParseHelper.buildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            boolean matched = false;
            if (fldNode != null) {
                refNodes.add(fldNode);
                matched = true;
            }
            if (!(property instanceof BasedataProp)) continue;
            if (fldNode == null) {
                fldNode = EntityParseHelper.buildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
            }
            if ((refNodes2 = EntityParseHelper.BuildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)property).getComplexType(), matchedProperty, matchedClassType, fldNode, prefix2 = prefix + "." + property.getName(), isDynamicText)).isEmpty()) continue;
            refNodes.addAll(refNodes2);
            if (matched) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = EntityParseHelper.isMatchType(fldProperty, matchedProperty, matchedClassType);
        if (isMatch && fldProperty != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? fldProperty.getName() : prefix + "." + fldProperty.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = fldProperty.getDisplayName() == null ? fldProperty.getName() : fldProperty.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static void buildPKFldTreeNode(EntityType entityType, TreeNode entityNode, List<TreeNode> entityFldNodes, BillTreeBuildParameter parameter) {
        if (entityType instanceof MainEntityType) {
            TreeNode idNode = EntityParseHelper.buildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, "", parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"EntityParseHelper_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(idNode);
            }
        } else {
            TreeNode seqNode;
            DynamicProperty seqProp;
            TreeNode idNode = EntityParseHelper.buildFldTreeNode((IDataEntityProperty)entityType.getPrimaryKey(), parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText());
            if (idNode != null) {
                idNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5185\u7801", (String)"EntityParseHelper_1", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(idNode);
            }
            if ((seqProp = entityType.getProperty("seq")) != null && (seqNode = EntityParseHelper.buildFldTreeNode((IDataEntityProperty)seqProp, parameter.getMatchedProperty(), parameter.getMatchedClassType(), entityNode, entityType.getName(), parameter.isDynamicText())) != null) {
                seqNode.setText(String.format(ResManager.loadKDString((String)"%s.\u5e8f\u53f7", (String)"EntityParseHelper_2", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[0]), entityType.getDisplayName().toString()));
                entityFldNodes.add(seqNode);
            }
        }
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp && fldProperty instanceof BasedataProp) {
                BasedataProp bdProp1 = (BasedataProp)matchedProperty;
                BasedataProp bdProp2 = (BasedataProp)fldProperty;
                if (!StringUtils.equalsIgnoreCase((CharSequence)bdProp1.getBaseEntityId(), (CharSequence)bdProp2.getBaseEntityId())) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        return isMatch;
    }
}

