/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.consts.PropertyDataType;
import kd.mpscmm.msisv.isomorphism.common.consts.SelectParams;
import kd.mpscmm.msisv.isomorphism.common.helper.EntityParseHelper;
import kd.mpscmm.msisv.isomorphism.common.helper.MetaHelper;
import kd.mpscmm.msisv.isomorphism.common.util.strategy.IColsSelectStrategy;
import kd.mpscmm.msisv.isomorphism.form.base.BaseEditPlugin;

public class FormShowHelper {
    public static void showFilterForm(AbstractFormPlugin formPlugin, IDataModel dataModel, String entityNumber, String filterJsonKey, String closeCallBackActionId) {
        String filterJson = dataModel.getDataEntity().getString(filterJsonKey);
        String filedNodes = formPlugin.getPageCache().get("fieldnodes");
        String entityNumberCache = formPlugin.getPageCache().get("entitynumbercachekey");
        if (StringUtils.isEmpty((CharSequence)entityNumberCache) || !entityNumberCache.equals(entityNumber)) {
            formPlugin.getPageCache().put("entitynumbercachekey", entityNumber);
            filedNodes = "";
        }
        if (StringUtils.isBlank((CharSequence)filedNodes)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType);
            parameter.setOnlyPhysicsField(false);
            TreeNode treeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            filedNodes = SerializationUtils.toJsonString((Object)treeNode);
            formPlugin.getPageCache().put("fieldnodes", filedNodes);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msisv_filtercondition");
        showParameter.getCustomParams().put("formula", filterJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", filedNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void showEntryFilterForm(AbstractFormPlugin formPlugin, IDataModel dataModel, String entityNumber, int currentRowIndex, String filterJsonKey, String closeCallBackActionId) {
        String filterJson = (String)dataModel.getValue(filterJsonKey, currentRowIndex);
        String filedNodes = formPlugin.getPageCache().get("fieldnodes");
        String entityNumberCache = formPlugin.getPageCache().get("entitynumbercachekey");
        if (StringUtils.isEmpty((CharSequence)entityNumberCache) || !entityNumberCache.equals(entityNumber)) {
            formPlugin.getPageCache().put("entitynumbercachekey", entityNumber);
            filedNodes = "";
        }
        if (StringUtils.isBlank((CharSequence)filedNodes)) {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(entityType);
            parameter.setOnlyPhysicsField(false);
            TreeNode treeNode = EntityParseHelper.buildBillTreeNodes(parameter);
            filedNodes = SerializationUtils.toJsonString((Object)treeNode);
            formPlugin.getPageCache().put("fieldnodes", filedNodes);
        }
        formPlugin.getPageCache().put("rowIndex", String.valueOf(currentRowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msisv_filtercondition");
        showParameter.getCustomParams().put("formula", filterJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", filedNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void showColsTreeForm(AbstractFormPlugin formPlugin, String entityNumber, IColsSelectStrategy selectStrategy, List<String> filterFields, boolean includePkField, String closeCallBackActionId, PropertyDataType ... dataTypes) {
        SelectParams params = new SelectParams();
        MetaHelper meta = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = meta.buildTree2JSON(filterFields, includePkField, dataTypes);
        params.setJsonTree(jsonTree);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msisv_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void showEntryColsTreeForm(AbstractFormPlugin formPlugin, String entityNumber, int currentRowIndex, IColsSelectStrategy selectStrategy, List<String> filterFields, boolean includePkField, String closeCallBackActionId, PropertyDataType ... dataTypes) {
        SelectParams params = new SelectParams();
        MetaHelper meta = new MetaHelper(selectStrategy, entityNumber);
        String jsonTree = meta.buildTree2JSON(filterFields, includePkField, dataTypes);
        params.setJsonTree(jsonTree);
        if ("tarbillassignfieldCB".equals(closeCallBackActionId)) {
            params.setMulti(true);
        }
        formPlugin.getPageCache().put("rowIndex", String.valueOf(currentRowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msisv_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void showEntryRegisterForm(AbstractFormPlugin formPlugin, int currentRowIndex, String serviceActionJson, String closeCallBackActionId) {
        formPlugin.getPageCache().put("rowIndex", String.valueOf(currentRowIndex));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msisv_invokeservice");
        showParameter.getCustomParams().put("serviceparam", serviceActionJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, closeCallBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        IFormView view = formPlugin.getView();
        view.showForm(showParameter);
    }

    public static void closeCallSetFilter(IDataModel dataModel, IPageCache pageCache, String returnData, String filterDesc, String filterJson, String filterFormula) {
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        String entityNumCache = pageCache.get("entitynumbercachekey");
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumCache), crCondition.getFilterCondition());
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        String exprTran = crCondition.getExprTran() == null ? "" : crCondition.getExprTran();
        String destValueShow = exprTran.length() > 300 ? exprTran.substring(0, 297) + "..." : exprTran;
        dataModel.setValue(filterDesc, (Object)destValueShow);
        dataModel.setValue(filterJson, (Object)returnData);
        dataModel.setValue(filterFormula, (Object)scripts[0]);
    }

    public static void closeCallSetEntryCondition(IDataModel dataModel, IPageCache pageCache, String returnData, String filterDesc, String filterJson, String filterFormula) {
        CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
        String entityNumCache = pageCache.get("entitynumbercachekey");
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityNumCache), crCondition.getFilterCondition());
        filterBuilder.buildFilter(false);
        String[] scripts = filterBuilder.buildFilterScript();
        String exprTran = crCondition.getExprTran() == null ? "" : crCondition.getExprTran();
        String destValueShow = exprTran.length() > 300 ? exprTran.substring(0, 297) + "..." : exprTran;
        String rowIndex = pageCache.get("rowIndex");
        dataModel.setValue(filterDesc, (Object)destValueShow, Integer.parseInt(rowIndex));
        dataModel.setValue(filterJson, (Object)returnData, Integer.parseInt(rowIndex));
        dataModel.setValue(filterFormula, (Object)scripts[0], Integer.parseInt(rowIndex));
    }

    public static void closeCallSetField(IDataModel dataModel, String returnData, String field, String fieldKey) {
        JSONObject jsonObject;
        JSONArray jsonArr = (JSONArray)SerializationUtils.fromJsonString((String)returnData, JSONArray.class);
        if (jsonArr != null && !jsonArr.isEmpty() && (jsonObject = jsonArr.getJSONObject(0)) != null && !jsonObject.isEmpty()) {
            dataModel.setValue(field, jsonObject.get((Object)"text"));
            dataModel.setValue(fieldKey, jsonObject.get((Object)"id"));
        }
    }

    public static void closeCallSetEntryField(IDataModel dataModel, IPageCache pageCache, String returnData, String field, String fieldKey) {
        String currentRowIndex = pageCache.get("rowIndex");
        int rowIndex = Integer.parseInt(currentRowIndex);
        JSONArray jsonArr = (JSONArray)SerializationUtils.fromJsonString((String)returnData, JSONArray.class);
        if (jsonArr != null && !jsonArr.isEmpty()) {
            if ("tarbillassignfieldkey".equals(fieldKey)) {
                int size = jsonArr.size();
                if (size != 1) {
                    dataModel.appendEntryRow("assignentry", rowIndex, jsonArr.size() - 1);
                }
                for (int i = 0; i < jsonArr.size(); ++i) {
                    JSONObject jsonObject = jsonArr.getJSONObject(i);
                    dataModel.setValue(field, jsonObject.get((Object)"text"), rowIndex);
                    dataModel.setValue(fieldKey, jsonObject.get((Object)"id"), rowIndex);
                    ++rowIndex;
                }
            } else {
                JSONObject jsonObject = jsonArr.getJSONObject(0);
                dataModel.setValue(field, jsonObject.get((Object)"text"), Integer.parseInt(currentRowIndex));
                dataModel.setValue(fieldKey, jsonObject.get((Object)"id"), Integer.parseInt(currentRowIndex));
            }
        }
    }

    public static void setOperationItems(IDataModel dataModel, IFormView view, String entityKey, String operationKey) {
        DynamicObject entity = dataModel.getDataEntity().getDynamicObject(entityKey);
        ComboEdit opEdit = (ComboEdit)view.getControl(operationKey);
        if (entity == null) {
            opEdit.setComboItems(null);
            return;
        }
        String entityNum = entity.getString("number");
        List operations = EntityMetadataCache.getDataEntityOperate((String)entityNum);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        for (Map operation : operations) {
            String opType = (String)operation.get("type");
            String opKey = (String)operation.get("key");
            Map opName = (Map)operation.get("name");
            comboItems.add(new ComboItem(LocaleString.fromMap((Map)opName), opKey));
        }
        opEdit.setComboItems(comboItems);
    }

    public static void showFormulaForm(BaseEditPlugin baseEditPlugin, String entityKey, String formulaJson, String treeNodeJson) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", entityKey);
        showParameter.getCustomParams().put("treenodes", treeNodeJson);
        String funcsXML = FormShowHelper.getFunXml((AbstractFormPlugin)baseEditPlugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)baseEditPlugin, "relateobjmatchfieldCB"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseEditPlugin.getView().showForm(showParameter);
    }

    public static void showConditionFormulaForm(BaseEditPlugin baseEditPlugin, String entityKey, String json, String fieldNodes, String sourceCtrlKey, IDataEntityProperty targetProperty) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_valbycondition");
        showParameter.getCustomParams().put("crvalbyconditions", json);
        showParameter.getCustomParams().put("entitynumber", entityKey);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        if (targetProperty instanceof BasedataProp) {
            showParameter.getCustomParams().put("baseentityid", ((BasedataProp)targetProperty).getBaseEntityId());
        }
        String funXml = FormShowHelper.getFunXml((AbstractFormPlugin)baseEditPlugin);
        showParameter.getCustomParams().put("functiontypes", funXml);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)baseEditPlugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseEditPlugin.getView().showForm(showParameter);
    }

    private static String getFunXml(AbstractFormPlugin plugin) {
        String funXml = plugin.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funXml)) {
            FunctionTypes bizFuncTypes = FunctionTypes.getCommonFuncs();
            bizFuncTypes.getFunctionTypes().clear();
            funXml = FunctionTypes.serializeToXML((FunctionTypes)bizFuncTypes);
            plugin.getPageCache().put("functiontypes", funXml);
        }
        return funXml;
    }
}

