/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.helper;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.algorithm.business.cache.BillMappingCache;
import kd.mpscmm.msbd.algorithm.business.helper.AlgorithmHelper;
import kd.mpscmm.msbd.algorithm.model.bill.CalBillModelConfig;
import kd.mpscmm.msisv.isomorphism.common.util.UnitConvertUtils;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.ListenerPushPipeline;
import kd.sdk.mpscmm.msbd.algorithm.service.AlgorithmService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class PriceAlgorithmHelper {
    private static final Log log = LogFactory.getLog(ListenerPushPipeline.class);

    public static IntegrationObject calcAlgorithm(IntegrationObject targetObject, String targetMasterQtyPropName) {
        Map changePropMaps;
        if (null == targetObject) {
            return null;
        }
        try {
            if (null == AlgorithmService.get()) {
                log.info("\u6ca1\u6709\u52a0\u8f7d\u91d1\u989d\u7b97\u6cd5\u670d\u52a1");
                return targetObject;
            }
        }
        catch (NoClassDefFoundError e) {
            log.info("\u6ca1\u6709\u52a0\u8f7d\u91d1\u989d\u7b97\u6cd5\u670d\u52a1");
            return targetObject;
        }
        String entityNumber = targetObject.getBillNumber();
        String entryNumber = targetObject.getEntryNumber();
        CalBillModelConfig config = BillMappingCache.getInstance().getModelConfig(entityNumber, entryNumber);
        if (null == config) {
            log.info("\u91d1\u989d\u7b97\u6cd5\u6a21\u578b\u6ca1\u6709\u5339\u914d\u5230\u76f8\u5173\u6620\u5c04\u6a21\u578b[{}][{}]", (Object)entityNumber, (Object)entryNumber);
            return targetObject;
        }
        IDataEntityProperty targetMasterQtyProperty = targetObject.findProperty(targetMasterQtyPropName);
        String qtyPropName = config.getModelFieldBySrcField("qty");
        if (!StringUtils.equals((CharSequence)targetMasterQtyProperty.getName(), (CharSequence)qtyPropName)) {
            String materialName = config.getModelFieldBySrcField("material");
            String srcUnitName = UnitConvertUtils.findUnitName(targetObject, targetMasterQtyPropName);
            BigDecimal qty = (BigDecimal)targetObject.getPropValue(targetMasterQtyPropName);
            String desUnitName = config.getModelFieldBySrcField("unit");
            DynamicObject desUnit = (DynamicObject)targetObject.getPropValue(desUnitName);
            BigDecimal targetQty = UnitConvertUtils.convertUnit(targetObject, materialName, srcUnitName, qty, desUnit);
            targetObject.setPropValue(qtyPropName, targetQty);
        }
        if (ObjectUtils.isNotEmpty((Object)(changePropMaps = AlgorithmHelper.entryCalculate((String)targetObject.getBillNumber(), (DynamicObject)targetObject.getEntryObject(), (String)qtyPropName)))) {
            for (Map.Entry entry : changePropMaps.entrySet()) {
                String propName = (String)entry.getKey();
                Object propValue = entry.getValue();
                targetObject.setPropValue(propName, propValue);
            }
        }
        return targetObject;
    }
}

