/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MasterQtyPropConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.RelationObjectConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.CarrySnInfo;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.SplitResultObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class SnHelper {
    public static Map<Long, List<CarrySnInfo>> buildSnInfo(List<SplitResultObject> splitResultObjectList, RelationObjectConfig relationObjectConfig) {
        String materielField;
        if (!relationObjectConfig.isCarrySn().booleanValue()) {
            return Collections.emptyMap();
        }
        MasterQtyPropConfig masterQtyPropConfig = relationObjectConfig.getMasterQtyPropConfig();
        String relQtyField = masterQtyPropConfig.getRelationBillMasterQtyPropName();
        String entityKey = relationObjectConfig.getRelationBizObjectConfig().getBillNumber();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        DynamicProperty qtyPro = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)relQtyField);
        if (qtyPro instanceof QtyProp && StringUtils.isNotBlank((CharSequence)((QtyProp)qtyPro).getRelatedMaterielKey())) {
            materielField = ((QtyProp)qtyPro).getRelatedMaterielKey();
            MaterielProp materielProp = (MaterielProp)RowDataModel.findProperty((MainEntityType)mainEntityType, (String)materielField);
            if (!"bd_materialinventoryinfo".equals(materielProp.getBaseEntityId())) {
                return Collections.emptyMap();
            }
        } else {
            return Collections.emptyMap();
        }
        ArrayList<Object> materieIds = new ArrayList<Object>();
        for (SplitResultObject splitResultObject : splitResultObjectList) {
            for (IntegrationObject relObj : splitResultObject.getRelationObjectList()) {
                DynamicObject dynamicObject = (DynamicObject)relObj.getPropValue(materielField);
                materieIds.add(dynamicObject.getPkValue());
            }
        }
        QFilter qFilter = new QFilter("id", "in", materieIds);
        qFilter.and("enableserial", "=", (Object)Boolean.TRUE);
        Map materielMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"id", (QFilter[])qFilter.toArray());
        HashMap<Long, List<CarrySnInfo>> snMap = new HashMap<Long, List<CarrySnInfo>>(splitResultObjectList.size());
        for (SplitResultObject splitResultObject : splitResultObjectList) {
            int relationSize = CollectionUtils.size(splitResultObject.getRelationObjectList());
            int targetSize = CollectionUtils.size(splitResultObject.getTargetObjectList());
            int length = Math.min(relationSize, targetSize);
            for (int idx = 0; idx < length; ++idx) {
                DynamicObject materielDym;
                IntegrationObject relationObject = splitResultObject.getRelationObjectList().get(idx);
                IntegrationObject targetObject = splitResultObject.getTargetObjectList().get(idx);
                if (null == relationObject || !materielMap.containsKey((materielDym = (DynamicObject)relationObject.getPropValue(materielField)).getPkValue())) continue;
                CarrySnInfo.SnInfo sourceSnInfo = SnHelper.buildSnInfo(relationObject);
                CarrySnInfo.SnInfo targetSnInfo = SnHelper.buildSnInfo(targetObject);
                ArrayList<CarrySnInfo> carrySnInfos = (ArrayList<CarrySnInfo>)snMap.get(targetObject.getBillPkValue());
                if (null == carrySnInfos) {
                    carrySnInfos = new ArrayList<CarrySnInfo>(4);
                    snMap.put((Long)targetObject.getBillPkValue(), carrySnInfos);
                }
                carrySnInfos.add(new CarrySnInfo(sourceSnInfo, targetSnInfo));
            }
        }
        return snMap;
    }

    private static CarrySnInfo.SnInfo buildSnInfo(IntegrationObject object) {
        CarrySnInfo.SnInfo snInfo = new CarrySnInfo.SnInfo();
        snInfo.setEntityKey(object.getBillNumber());
        snInfo.setBillId((Long)object.getBillPkValue());
        snInfo.setEntryKey(object.getEntryNumber());
        snInfo.setEntryId((Long)object.getEntryPkValue());
        return snInfo;
    }

    public static void saveSn(List<CarrySnInfo> carrySnInfoList) {
        if (CollectionUtils.isEmpty(carrySnInfoList)) {
            return;
        }
        ArrayList<DynamicObject> snList = new ArrayList<DynamicObject>(carrySnInfoList.size());
        HashSet<Long> billIdSet = new HashSet<Long>(carrySnInfoList.size());
        HashSet<Long> entryIdSet = new HashSet<Long>(carrySnInfoList.size());
        MultiKeyMap snKeyMap = new MultiKeyMap();
        for (CarrySnInfo carrySnInfo : carrySnInfoList) {
            CarrySnInfo.SnInfo sourceSnInfo = carrySnInfo.getSourceSnInfo();
            CarrySnInfo.SnInfo targetSnInfo = carrySnInfo.getTargetSnInfo();
            billIdSet.add(sourceSnInfo.getBillId());
            entryIdSet.add(sourceSnInfo.getEntryId());
            snKeyMap.put((Object)sourceSnInfo.getBillId(), (Object)sourceSnInfo.getEntryId(), (Object)targetSnInfo);
        }
        CarrySnInfo.SnInfo snInfo = carrySnInfoList.get(0).getSourceSnInfo();
        QFilter sourceSnFilter = new QFilter("billtype", "=", (Object)snInfo.getEntityKey()).and("billid", "in", billIdSet).and("entrykey", "=", (Object)snInfo.getEntryKey()).and("entryid", "in", entryIdSet);
        List snIds = QueryServiceHelper.queryPrimaryKeys((String)"sbs_billsnrelation", (QFilter[])sourceSnFilter.toArray(), null, (int)10000);
        Object[] snDynList = BusinessDataServiceHelper.load((Object[])snIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sbs_billsnrelation"));
        if (ArrayUtils.isNotEmpty((Object[])snDynList)) {
            for (Object snDyn : snDynList) {
                Long entryid;
                Long billid = snDyn.getLong("billid");
                CarrySnInfo.SnInfo targetSnInfo = (CarrySnInfo.SnInfo)snKeyMap.get((Object)billid, (Object)(entryid = Long.valueOf(snDyn.getLong("entryid"))));
                if (null == targetSnInfo) continue;
                DynamicObjectCollection collection = snDyn.getDynamicObjectCollection("entryentity");
                DynamicObject newSnRecord = (DynamicObject)OrmUtils.clone((IDataEntityBase)snDyn, (boolean)false, (boolean)true);
                newSnRecord.set("srcbilltype", (Object)snDyn.getString("billtype"));
                newSnRecord.set("srcbillid", (Object)billid);
                newSnRecord.set("srcentrykey", (Object)snDyn.getString("entrykey"));
                newSnRecord.set("srcentryid", (Object)entryid);
                newSnRecord.set("billtype", (Object)targetSnInfo.getEntityKey());
                newSnRecord.set("billid", (Object)targetSnInfo.getBillId());
                newSnRecord.set("entrykey", (Object)targetSnInfo.getEntryKey());
                newSnRecord.set("entryid", (Object)targetSnInfo.getEntryId());
                newSnRecord.set("qty", (Object)CollectionUtils.size((Object)collection));
                snList.add(newSnRecord);
            }
        }
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.saveOperate((String)"sbs_billsnrelation", (DynamicObject[])snList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        }
    }

    public static boolean enableSnCfg(String entityKey) {
        QFilter qFilter = new QFilter("srcbillobj", "=", (Object)entityKey);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.exists((String)"sbs_snbillconfig", (QFilter[])qFilter.toArray());
    }
}

