/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.util;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;

public class ContextHolderUtils {
    private static ThreadLocal<Map<String, Object>> threadLocal = new ThreadLocal();

    private ContextHolderUtils() {
    }

    public static Object put(String key, Object value) {
        Map<String, Object> map = threadLocal.get();
        if (map == null) {
            map = new HashMap<String, Object>(4);
            threadLocal.set(map);
        }
        return map.put(key, value);
    }

    public static Object get(String key) {
        return ContextHolderUtils.getOrDefault(key, null);
    }

    public static Object getOrDefault(String key, Object defaultVal) {
        Map<String, Object> map = threadLocal.get();
        if (map == null) {
            return null;
        }
        return map.getOrDefault(key, defaultVal);
    }

    public static void clear() {
        threadLocal.remove();
    }

    public static void remove(String key) {
        Map<String, Object> map = threadLocal.get();
        if (map != null) {
            map.remove(key);
        }
    }

    public static void initUserId(String userId) {
        RequestContext requestContext = RequestContext.get();
        if (requestContext.getUserId() == null) {
            requestContext.setUserId(userId);
        }
    }

    public static void initUserId(Long userId) {
        ContextHolderUtils.initUserId(String.valueOf(userId));
    }
}

