/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.idemponent.properties.ConcurrentPolicyEnum;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.properties.StorageStrategyEnum;

public class IdempotentPropertiesUtils {
    public static IdempotentProperties generate(String className, Object param) {
        String keyStr = className + "#" + SerializationUtils.toJsonString((Object)param);
        IdempotentProperties idemProp = new IdempotentProperties();
        idemProp.setIdempotentKey(IdempotentPropertiesUtils.encode(keyStr));
        idemProp.setAlivedTime(Long.valueOf(1209600000L));
        idemProp.setDbRoute(new DBRoute("scm"));
        idemProp.setStorageStrategy(StorageStrategyEnum.DB);
        idemProp.setConcurrentPolicy(ConcurrentPolicyEnum.QUICK_RETURN);
        return idemProp;
    }

    private static String encode(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getUrlEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", String.format("MSISV-SHA256Base64Util:[%s] args:[%s]", e.getMessage(), message)), new Object[0]);
        }
    }
}

