/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.util;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MasterQtyPropConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import org.apache.commons.lang3.ObjectUtils;

public class UnitConvertUtils {
    private static final String PRECISION = "precision";
    private static final String PRECISION_ACCOUNT = "precisionaccount";

    public static IntegrationObject convertUnit(IntegrationObject relationObj, IntegrationObject targetObj, MasterQtyPropConfig masterQtyPropConfig) {
        if (relationObj == null) {
            return null;
        }
        String relQtyPropName = masterQtyPropConfig.getRelationBillMasterQtyPropName();
        BigDecimal relationQty = (BigDecimal)relationObj.getPropValue(relQtyPropName);
        if (BigDecimal.ZERO.compareTo(relationQty = Optional.ofNullable(relationQty).orElse(BigDecimal.ZERO)) == 0) {
            return relationObj;
        }
        String relUnitPropName = UnitConvertUtils.findUnitName(relationObj, relQtyPropName);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)relUnitPropName)) {
            throw new KDException("relUnitPropName is empty");
        }
        String targetUnitPropName = UnitConvertUtils.findUnitName(targetObj, masterQtyPropConfig.getTargetBillMasterQtyPropName());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)targetUnitPropName)) {
            throw new KDException("targetUnitPropName is empty");
        }
        DynamicObject relUnit = (DynamicObject)relationObj.getPropValue(relUnitPropName);
        DynamicObject targetUnit = (DynamicObject)targetObj.getPropValue(targetUnitPropName);
        if (Objects.equals(relUnit.getPkValue(), targetUnit.getPkValue())) {
            return relationObj;
        }
        String relMaterielPropName = UnitConvertUtils.findMaterielName(relationObj, relUnitPropName);
        BigDecimal newRelQty = UnitConvertUtils.convertUnit(relationObj, relMaterielPropName, relUnitPropName, relationQty, targetUnit);
        relationObj = relationObj.copy(true);
        relationObj.setPropValue(relUnitPropName, targetUnit);
        relationObj.setPropValue(relQtyPropName, newRelQty);
        return relationObj;
    }

    public static String findUnitName(IntegrationObject integrationObject, String qtyPropName) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)qtyPropName)) {
            return null;
        }
        QtyProp qtyProp = (QtyProp)integrationObject.findProperty(qtyPropName);
        if (qtyProp == null) {
            return null;
        }
        return qtyProp.getControlPropName();
    }

    private static String findMaterielName(IntegrationObject integrationObject, String unitPropName) {
        if (StringUtils.isBlank((CharSequence)unitPropName)) {
            return null;
        }
        UnitProp unitProp = (UnitProp)integrationObject.findProperty(unitPropName);
        if (unitProp == null) {
            return null;
        }
        return unitProp.getMaterielField();
    }

    public static BigDecimal convertUnit(IntegrationObject integrationObject, String materialPropName, String srcUnitPropName, BigDecimal srcQty, DynamicObject desUnit) {
        if (Objects.isNull(integrationObject) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)srcUnitPropName) || Objects.isNull(srcQty) || ObjectUtils.isEmpty((Object)desUnit)) {
            return null;
        }
        DynamicObject materiel = (DynamicObject)integrationObject.getPropValue(materialPropName);
        DynamicObject srcUnit = (DynamicObject)integrationObject.getPropValue(srcUnitPropName);
        return UnitConvertUtils.convertUnit(materiel, srcUnit, srcQty, desUnit);
    }

    public static BigDecimal convertUnit(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("numerator") != 0) {
                int precision = desUnit.getInt(PRECISION);
                Integer precisionAccount = desUnit.getInt(PRECISION_ACCOUNT);
                if (ObjectUtils.isNotEmpty((Object)precisionAccount)) {
                    return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, UnitConvertUtils.findPrecisionAccount(precisionAccount));
                }
            }
        }
        return BigDecimal.ZERO;
    }

    private static int findPrecisionAccount(int precisionAccount) {
        switch (precisionAccount) {
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 4;
    }
}

