/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.common.util.strategy;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UnitProp;
import kd.mpscmm.msisv.isomorphism.common.util.strategy.DefaultSelectStrategy;

public class TypeSelectStrategy
extends DefaultSelectStrategy {
    private IDataEntityProperty property;
    private String field;
    private static final Class<?>[] SUPER_CLASS = new Class[]{AmountProp.class, IntegerProp.class, QtyProp.class, TextProp.class, DateTimeProp.class};

    public TypeSelectStrategy(IDataEntityProperty property, String field) {
        this.property = property;
        this.field = field;
    }

    @Override
    public boolean filterEntryPro(EntryType pro) {
        String entryName = pro.getName();
        return !"snentity".equals(entryName);
    }

    @Override
    public boolean filterPro(IDataEntityProperty pro) {
        boolean isfilter;
        if (this.property instanceof ItemClassProp) {
            return pro instanceof BasedataProp;
        }
        if (this.property instanceof FlexProp) {
            return pro instanceof FlexProp;
        }
        if (this.property instanceof BasedataProp) {
            BasedataProp targetPro = (BasedataProp)this.property;
            isfilter = this.checkBaseDataProp(targetPro, pro);
        } else if (this.isSameSuperClass(this.property, pro, SUPER_CLASS)) {
            isfilter = true;
        } else {
            if (this.property instanceof BigIntProp && pro instanceof LongProp) {
                return true;
            }
            isfilter = this.property instanceof TextProp && pro instanceof LongProp ? this.field.contains("id") : pro.getClass().equals(this.property.getClass());
        }
        return isfilter;
    }

    private boolean checkBaseDataProp(BasedataProp targetPro, IDataEntityProperty pro) {
        if (pro instanceof ItemClassProp) {
            return false;
        }
        if (pro instanceof MaterielProp) {
            return targetPro instanceof MaterielProp;
        }
        if (pro instanceof BasedataProp) {
            String baseEntityId = targetPro.getBaseEntityId();
            BasedataProp sourceProp = (BasedataProp)pro;
            if (sourceProp instanceof MainOrgProp || sourceProp instanceof CurrencyProp || sourceProp instanceof UnitProp) {
                return false;
            }
            String sourceEntityId = sourceProp.getBaseEntityId();
            return baseEntityId.equals(sourceEntityId);
        }
        return false;
    }

    private boolean isSameSuperClass(Object targetProp, Object sourceProp, Class<?> ... classes) {
        Class<?> targetClass = targetProp.getClass();
        Class<?> sourceClass = sourceProp.getClass();
        for (Class<?> clazz : classes) {
            if (!clazz.isAssignableFrom(targetClass) || !clazz.isAssignableFrom(sourceClass)) continue;
            return true;
        }
        return false;
    }
}

