/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.config.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.core.config.manager.IsvConfigManager;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BillAssignConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BizObjectConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BotpConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ListenerConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MasterQtyPropConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherPropConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.OperationConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PushPipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.RelationObjectConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.RelationUpdatePipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ServiceInvokePipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.ListenerPushPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.RelationPushPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.RelationUpdatePipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.ServiceInvokePipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.SimplePushPipeline;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class IsvConfigService {
    private static final Log log = LogFactory.getLog(IsvConfigService.class);
    private static final String SAVE = "save";

    public static List<ListenerConfig> loadListenerConfig(String entityType, String opKey) {
        try {
            return IsvConfigService.safeLoadListenerConfig(entityType, opKey);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, MonitorResultLogConst.getPipelineErrorMsg(), new Object[0]);
        }
    }

    public static List<ListenerConfig> safeLoadListenerConfig(String entityType, String operationKey) {
        DynamicObject[] configObjects = IsvConfigManager.loadListenerConfigs(entityType, operationKey);
        ArrayList<ListenerConfig> listenerConfigList = new ArrayList<ListenerConfig>(CollectionUtils.size((Object)configObjects));
        for (DynamicObject configObject : configObjects) {
            ListenerConfig listenerConfig = IsvConfigService.parseListenerConfig(configObject);
            listenerConfigList.add(listenerConfig);
        }
        return listenerConfigList;
    }

    private static ListenerConfig parseListenerConfig(DynamicObject configObject) {
        String listenerEntityNumber = configObject.getDynamicObject("monitorobj").getString("number");
        String filterJson = configObject.getString("filterjson_tag");
        String filterExpression = configObject.getString("filterformula_tag");
        QFilter qFilter = null;
        if (StringUtils.isNotBlank((CharSequence)filterJson)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterJson, FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(MetadataServiceHelper.getDataEntityType((String)listenerEntityNumber), filterCondition);
            filterBuilder.buildFilter(false);
            qFilter = filterBuilder.getQFilter();
        }
        ListenerConfig listenerConfig = new ListenerConfig();
        listenerConfig.setName(configObject.getString("name"));
        listenerConfig.setNumber(configObject.getString("number"));
        listenerConfig.setOperateKey(configObject.getString("monitoroperation"));
        listenerConfig.setOperateName(configObject.getString("operationname"));
        listenerConfig.setListenerBizObjectConfig(new BizObjectConfig(listenerEntityNumber, IsvConfigService.parseEntryNumber(listenerEntityNumber, filterJson, false)));
        listenerConfig.setFilterExpression(filterExpression);
        listenerConfig.setSync(configObject.getBoolean("issync"));
        if (null != qFilter) {
            listenerConfig.setQfilterStr(qFilter.toSerializedString());
        }
        listenerConfig.setPipelineConfigs(IsvConfigService.parsePipelineConfigs(listenerEntityNumber, configObject.getDynamicObjectCollection("actionentry")));
        return listenerConfig;
    }

    private static BizObjectConfig buildBizObjectConfig(String entityNumber, String masterQtyPropName) {
        String entryNumber = IsvConfigService.parseEntryNumber(entityNumber, Collections.singletonList(masterQtyPropName));
        return new BizObjectConfig(entityNumber, entryNumber);
    }

    private static String parseEntryNumber(String entityNumber, List<String> propNameList) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        for (String propName : propNameList) {
            DynamicProperty dataEntityProperty = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)propName);
            if (dataEntityProperty == null || !(dataEntityProperty.getParent() instanceof EntryType)) continue;
            return dataEntityProperty.getParent().getName();
        }
        return null;
    }

    private static String parseEntryNumber(String entityNumber, String jsonCondition, boolean isCRCondition) {
        FilterCondition filterCondition;
        if (StringUtils.isBlank((CharSequence)jsonCondition)) {
            return null;
        }
        if (isCRCondition) {
            CRCondition crCondition = (CRCondition)SerializationUtils.fromJsonString((String)jsonCondition, CRCondition.class);
            filterCondition = crCondition.getFilterCondition();
        } else {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)jsonCondition, FilterCondition.class);
        }
        if (filterCondition == null || CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
            return null;
        }
        return IsvConfigService.parseEntryNumber(entityNumber, filterCondition.getFilterRow().stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toList()));
    }

    private static List<PipelineConfig> parsePipelineConfigs(String listenerEntityNumber, DynamicObjectCollection pipelineList) {
        if (CollectionUtils.isEmpty((Collection)pipelineList)) {
            return Collections.emptyList();
        }
        ArrayList pipelineConfigList = new ArrayList(pipelineList.size());
        for (DynamicObject pipeline : pipelineList) {
            String type = pipeline.getString("type");
            PipelineConfig pipelineConfig2 = null;
            switch (type) {
                case "A": {
                    pipelineConfig2 = IsvConfigService.initPipelineConfig(new PushPipelineConfig(), pipeline.getDynamicObject("pushaction"));
                    break;
                }
                case "B": {
                    pipelineConfig2 = IsvConfigService.initPipelineConfig(new RelationUpdatePipelineConfig(), pipeline.getDynamicObject("updateaction"));
                    break;
                }
                case "C": {
                    pipelineConfig2 = (PipelineConfig)SerializationUtils.fromJsonString((String)pipeline.getString("serviceactionjson_tag"), ServiceInvokePipelineConfig.class);
                    pipelineConfig2.setPipeline(ServiceInvokePipeline.INSTANCE.getClass().getName());
                    pipelineConfig2.setPipelineId((Long)pipeline.getPkValue());
                    pipelineConfig2.setPipeNumber(String.valueOf(pipeline.getPkValue()));
                    pipelineConfig2.setPipeName("ServiceInvoker");
                }
            }
            if (pipelineConfig2 != null) {
                pipelineConfig2.setPipeType(type);
            }
            CollectionUtils.addIgnoreNull(pipelineConfigList, (Object)pipelineConfig2);
        }
        Map typeMap = pipelineConfigList.stream().collect(Collectors.groupingBy(PipelineConfig::getPipeType, Collectors.mapping(PipelineConfig::getPipelineId, Collectors.toList())));
        HashMap dynamicObjectMap = new HashMap(pipelineConfigList.size());
        typeMap.forEach((key, value) -> {
            Map configObjectMap = null;
            switch (key) {
                case "A": {
                    configObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])value.toArray(), (String)"msisv_unionpush");
                    break;
                }
                case "B": {
                    configObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])value.toArray(), (String)"msisv_relateupdate");
                    break;
                }
            }
            if (ObjectUtils.isNotEmpty(configObjectMap)) {
                dynamicObjectMap.putAll(configObjectMap);
            }
        });
        return pipelineConfigList.stream().map(pipelineConfig -> {
            if (pipelineConfig instanceof ServiceInvokePipelineConfig) {
                return pipelineConfig;
            }
            DynamicObject configObject = (DynamicObject)dynamicObjectMap.get(pipelineConfig.getPipelineId());
            if (Objects.isNull(configObject)) {
                log.info("\u65e0\u6cd5\u627e\u5230\u6d41\u6c34\u7ebf\u914d\u7f6e:{}", (Object)pipelineConfig.getPipeNumber());
                return null;
            }
            PipelineConfig newPipelineConfig = null;
            if (pipelineConfig instanceof PushPipelineConfig) {
                newPipelineConfig = IsvConfigService.buildPushPipeConfig(listenerEntityNumber, configObject);
            } else if (pipelineConfig instanceof RelationUpdatePipelineConfig) {
                newPipelineConfig = IsvConfigService.buildRelationUpdatePipeConfig(configObject);
            }
            if (newPipelineConfig != null && pipelineConfig != null) {
                newPipelineConfig.setPipelineId(pipelineConfig.getPipelineId());
                newPipelineConfig.setPipeNumber(pipelineConfig.getPipeNumber());
                newPipelineConfig.setPipeName(pipelineConfig.getPipeName());
                newPipelineConfig.setPipeType(pipelineConfig.getPipeType());
            }
            return newPipelineConfig;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static <T extends PipelineConfig> T initPipelineConfig(T pipelineConfig, DynamicObject dynamicObject) {
        pipelineConfig.setPipelineId((Long)dynamicObject.getPkValue());
        pipelineConfig.setPipeName(dynamicObject.getString("name"));
        pipelineConfig.setPipeNumber(dynamicObject.getString("number"));
        return pipelineConfig;
    }

    private static PipelineConfig buildPushPipeConfig(String listenerEntityNumber, DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("enable")) {
            return null;
        }
        PushPipelineConfig pipelineConfig = new PushPipelineConfig();
        String sourceEntityNumber = dynamicObject.getDynamicObject("srcbill").getString("number");
        String targetEntityNumber = dynamicObject.getDynamicObject("tarbill").getString("number");
        BotpConfig botpConfig = new BotpConfig();
        botpConfig.setSourceFilterCondition(dynamicObject.getString("srcbillfilterformula_tag"));
        botpConfig.setBotpRuleId(dynamicObject.getDynamicObject("botprule").getString("number"));
        botpConfig.setTargetBillFilterExpression(dynamicObject.getString("tarbillfilterformula_tag"));
        pipelineConfig.setBotpConfig(botpConfig);
        boolean isinvorelateobj = dynamicObject.getBoolean("isinvorelateobj");
        if (isinvorelateobj) {
            RelationObjectConfig relationObjectConfig = IsvConfigService.buildRelationObjectConfig(dynamicObject, true);
            pipelineConfig.setRelationObjectConfig(relationObjectConfig);
            botpConfig.setSourceBizObjectConfig(IsvConfigService.buildBizObjectConfig(sourceEntityNumber, relationObjectConfig.getMasterQtyPropConfig().getSourceBillMasterQtyPropName()));
            botpConfig.setTargetBizObjectConfig(IsvConfigService.buildBizObjectConfig(targetEntityNumber, relationObjectConfig.getMasterQtyPropConfig().getTargetBillMasterQtyPropName()));
            if (listenerEntityNumber.equals(botpConfig.getSourceBizObjectConfig().getBillNumber())) {
                pipelineConfig.setPipeline(ListenerPushPipeline.INSTANCE.getClass().getName());
            } else {
                pipelineConfig.setPipeline(RelationPushPipeline.INSTANCE.getClass().getName());
            }
        } else {
            String jsonFilter = dynamicObject.getString("srcbillfilterjson_tag");
            botpConfig.setSourceBizObjectConfig(new BizObjectConfig(sourceEntityNumber, IsvConfigService.parseEntryNumber(sourceEntityNumber, jsonFilter, true)));
            botpConfig.setTargetBizObjectConfig(new BizObjectConfig(targetEntityNumber, null));
            pipelineConfig.setPipeline(SimplePushPipeline.INSTANCE.getClass().getName());
        }
        pipelineConfig.setOperationConfigList(IsvConfigService.buildOperationConfigList(dynamicObject.getDynamicObjectCollection("operateentry"), false));
        return pipelineConfig;
    }

    private static RelationUpdatePipelineConfig buildRelationUpdatePipeConfig(DynamicObject dynamicObject) {
        if (!dynamicObject.getBoolean("enable")) {
            return null;
        }
        RelationUpdatePipelineConfig pipelineConfig = new RelationUpdatePipelineConfig();
        pipelineConfig.setPipeline(RelationUpdatePipeline.INSTANCE.getClass().getName());
        RelationObjectConfig relationObjectConfig = IsvConfigService.buildRelationObjectConfig(dynamicObject, false);
        pipelineConfig.setRelationObjectConfig(relationObjectConfig);
        DynamicObject tarbill = dynamicObject.getDynamicObject("tarbill");
        pipelineConfig.setTargetBizObjectConfig(IsvConfigService.buildBizObjectConfig(tarbill.getString("number"), relationObjectConfig.getMasterQtyPropConfig().getTargetBillMasterQtyPropName()));
        pipelineConfig.setTargetBillFilterExpression(dynamicObject.getString("tarbillfilterformula_tag"));
        pipelineConfig.setOperationConfigList(IsvConfigService.buildOperationConfigList(dynamicObject.getDynamicObjectCollection("operateentry"), true));
        return pipelineConfig;
    }

    private static MasterQtyPropConfig buildMasterQtyPropConfig(DynamicObject dynamicObject, boolean isUnionPush) {
        String relateobjmainfieldkey = dynamicObject.getString("relateobjmainfieldkey");
        String tarbillmainfieldkey = dynamicObject.getString("tarbillmainfieldkey");
        String sourceobjmainfieldkey = null;
        if (isUnionPush) {
            sourceobjmainfieldkey = dynamicObject.getString("srcbillmainfieldkey");
        }
        return new MasterQtyPropConfig(relateobjmainfieldkey, tarbillmainfieldkey, sourceobjmainfieldkey);
    }

    private static RelationObjectConfig buildRelationObjectConfig(DynamicObject dynamicObject, boolean isUnionPush) {
        RelationObjectConfig relationObjectConfig = new RelationObjectConfig();
        MasterQtyPropConfig masterQtyPropConfig = IsvConfigService.buildMasterQtyPropConfig(dynamicObject, isUnionPush);
        relationObjectConfig.setMasterQtyPropConfig(masterQtyPropConfig);
        DynamicObject relationObject = dynamicObject.getDynamicObject("relateobj");
        String relationEntityNumber = relationObject.getString("number");
        relationObjectConfig.setRelationBizObjectConfig(IsvConfigService.buildBizObjectConfig(relationEntityNumber, masterQtyPropConfig.getRelationBillMasterQtyPropName()));
        relationObjectConfig.setRelationBillFilterExpression(dynamicObject.getString("relateobjfilterformula_tag"));
        if (isUnionPush) {
            boolean iscarrysn = dynamicObject.getBoolean("iscarrysn");
            relationObjectConfig.setCarrySn(iscarrysn);
            String matchMethod = dynamicObject.getString("matchmethod");
            relationObjectConfig.setMatchMethod(matchMethod);
        }
        DynamicObjectCollection matchCollection = dynamicObject.getDynamicObjectCollection("matchentry");
        List<MatcherPropConfig> matcherPropConfigList = matchCollection.stream().map(item -> {
            MatcherPropConfig matcherPropConfig = new MatcherPropConfig();
            if (isUnionPush) {
                String sourcePropName = item.getString("srcbillmatchfieldkey");
                matcherPropConfig.setSourcePropName(sourcePropName);
                String relationPropName = item.getString("relateobjmatchfieldkey");
                matcherPropConfig.setRelationPropName(relationPropName);
            } else {
                String relationPropName = item.getString("tarbillmatchfieldkey");
                matcherPropConfig.setRelationPropName(relationPropName);
                String sourcePropName = item.getString("relateobjmatchfieldkey");
                matcherPropConfig.setSourcePropName(sourcePropName);
            }
            return matcherPropConfig;
        }).collect(Collectors.toList());
        relationObjectConfig.setMatcherPropConfigList(matcherPropConfigList);
        DynamicObjectCollection assignCollection = dynamicObject.getDynamicObjectCollection("assignentry");
        relationObjectConfig.setBillAssignConfigList(assignCollection.stream().map(item -> {
            BillAssignConfig assignConfig = new BillAssignConfig();
            assignConfig.setRelationPropName(item.getString("relateobjassignfieldkey"));
            assignConfig.setValueAssigner(item.getString("assignmethod"));
            assignConfig.setTargetPropName(item.getString("tarbillassignfieldkey"));
            assignConfig.setNegative(item.getBoolean("isnegate"));
            assignConfig.setAssignMethod(item.getString("assignmethod"));
            if (isUnionPush) {
                assignConfig.setConditionJson(item.getString("assignformulajson_tag"));
            }
            return assignConfig;
        }).collect(Collectors.toList()));
        return relationObjectConfig;
    }

    private static List<OperationConfig> buildOperationConfigList(DynamicObjectCollection operationConfigs, boolean hasCondition) {
        OperationConfig operationConfig;
        List<OperationConfig> operationConfigList = operationConfigs.stream().map(item -> {
            OperationConfig operationConfig = new OperationConfig();
            if (hasCondition) {
                operationConfig.setConditionExpression(item.getString("conditionformula_tag"));
            }
            operationConfig.setOperationKey(item.getString("operation"));
            return operationConfig;
        }).collect(Collectors.toList());
        if (ObjectUtils.isNotEmpty(operationConfigList) && !(operationConfig = operationConfigList.get(0)).getOperationKey().startsWith(SAVE)) {
            OperationConfig saveOperator = new OperationConfig();
            saveOperator.setOperationKey(SAVE);
            operationConfigList.add(0, saveOperator);
        }
        return operationConfigList;
    }
}

