/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.config.vo;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BizObjectConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherPropConfig;

public class MatcherConfig
implements Serializable {
    private BizObjectConfig sourceBizObjectConfig;
    private BizObjectConfig relationBizObjectConfig;
    private List<MatcherPropConfig> matcherPropConfigList;
    private String matchMethod = "A";

    public MatcherConfig() {
    }

    public MatcherConfig(BizObjectConfig sourceBizObjectConfig, BizObjectConfig relationBizObjectConfig, List<MatcherPropConfig> matcherPropConfigList, String matchMethod) {
        this.sourceBizObjectConfig = sourceBizObjectConfig;
        this.relationBizObjectConfig = relationBizObjectConfig;
        this.matcherPropConfigList = matcherPropConfigList;
        this.matchMethod = matchMethod;
        this.init();
    }

    private void init() {
        MainEntityType srcEntityType = MetadataServiceHelper.getDataEntityType((String)this.getSourceBizObjectConfig().getBillNumber());
        MainEntityType relEntityType = MetadataServiceHelper.getDataEntityType((String)this.getRelationBizObjectConfig().getBillNumber());
        for (MatcherPropConfig matcherPropConfig : this.matcherPropConfigList) {
            DynamicProperty relProp;
            DynamicProperty srcProp = RowDataModel.findProperty((MainEntityType)srcEntityType, (String)matcherPropConfig.getSourcePropName());
            if (srcProp != null) {
                matcherPropConfig.setSourcePropType(srcProp.getPropertyType());
            }
            if (StringUtils.isBlank((CharSequence)matcherPropConfig.getRelationPropName()) || (relProp = RowDataModel.findProperty((MainEntityType)relEntityType, (String)matcherPropConfig.getRelationPropName())) == null) continue;
            matcherPropConfig.setRelationPropType(relProp.getPropertyType());
        }
        if (this.isBotpMatch()) {
            this.buildBotpRel();
        }
    }

    private void buildBotpRel() {
        String srcPkField = StringUtils.equals((CharSequence)this.getSourceBizObjectConfig().getBillNumber(), (CharSequence)this.getSourceBizObjectConfig().getEntryNumber()) ? "id" : this.getSourceBizObjectConfig().getEntryNumber() + ".id";
        String relPkField = StringUtils.equals((CharSequence)this.getRelationBizObjectConfig().getBillNumber(), (CharSequence)this.getRelationBizObjectConfig().getEntryNumber()) ? "id" : this.getRelationBizObjectConfig().getEntryNumber() + ".id";
        MatcherPropConfig matcherPropConfig = new MatcherPropConfig();
        matcherPropConfig.setSourcePropName(srcPkField);
        matcherPropConfig.setSourcePropType(PKFieldProp.class);
        matcherPropConfig.setRelationPropName(relPkField);
        matcherPropConfig.setSourcePropType(PKFieldProp.class);
        this.matcherPropConfigList = Collections.singletonList(matcherPropConfig);
    }

    public List<MatcherPropConfig> getMatcherPropConfigList() {
        return this.matcherPropConfigList;
    }

    public void setMatcherPropConfigList(List<MatcherPropConfig> matcherPropConfigList) {
        this.matcherPropConfigList = matcherPropConfigList;
    }

    public String getSourceEntryNumber() {
        return this.sourceBizObjectConfig.getEntryNumber();
    }

    public String getRelationEntryNumber() {
        return this.relationBizObjectConfig.getEntryNumber();
    }

    public BizObjectConfig getSourceBizObjectConfig() {
        return this.sourceBizObjectConfig;
    }

    public void setSourceBizObjectConfig(BizObjectConfig sourceBizObjectConfig) {
        this.sourceBizObjectConfig = sourceBizObjectConfig;
    }

    public BizObjectConfig getRelationBizObjectConfig() {
        return this.relationBizObjectConfig;
    }

    public void setRelationBizObjectConfig(BizObjectConfig relationBizObjectConfig) {
        this.relationBizObjectConfig = relationBizObjectConfig;
    }

    public MatcherConfig revert() {
        MatcherConfig matcherConfig = new MatcherConfig();
        matcherConfig.setSourceBizObjectConfig(this.relationBizObjectConfig);
        matcherConfig.setRelationBizObjectConfig(this.sourceBizObjectConfig);
        matcherConfig.setMatchMethod(this.getMatchMethod());
        matcherConfig.setMatcherPropConfigList(this.matcherPropConfigList.stream().map(item -> {
            MatcherPropConfig matcherPropConfig = new MatcherPropConfig();
            matcherPropConfig.setSourcePropName(item.getRelationPropName());
            matcherPropConfig.setSourcePropType(item.getRelationPropType());
            matcherPropConfig.setRelationPropName(item.getSourcePropName());
            matcherPropConfig.setRelationPropType(item.getSourcePropType());
            return matcherPropConfig;
        }).collect(Collectors.toList()));
        return matcherConfig;
    }

    public String getMatchMethod() {
        return this.matchMethod;
    }

    public MatcherConfig setMatchMethod(String matchMethod) {
        this.matchMethod = matchMethod;
        return this;
    }

    public boolean isBotpMatch() {
        return "B".equals(this.matchMethod);
    }
}

