/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.kdtx.common.exception.TCCTryException;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.sdk.constant.GlobalSessionType;
import kd.bos.kdtx.sdk.session.tcc.TCCGlobalSession;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.util.MonitorLogUtils;
import kd.mpscmm.msisv.isomorphism.core.config.service.IsvConfigService;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ListenerConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ServiceInvokePipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.ResultObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.SuccessResultObject;
import kd.mpscmm.msisv.isomorphism.core.engine.filter.BillFilter;
import kd.mpscmm.msisv.isomorphism.core.engine.tcc.BaseServiceInvokeTccService;
import kd.mpscmm.msisv.isomorphism.core.engine.tcc.PipelineTccService;
import kd.mpscmm.msisv.isomorphism.core.log.service.IntegrationLogService;
import kd.mpscmm.msisv.isomorphism.core.log.vo.IntegrationLog;
import kd.mpscmm.msisv.isomorphism.core.log.vo.UnionPushRecordObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class IsvIntegrationEngine {
    private static final Log log = LogFactory.getLog(IsvIntegrationEngine.class);

    /*
     * Loose catch block
     */
    public static String process(String bizNo, String entityNumber, List<Long> ids, String operationKey) {
        log.info("\u751f\u6001\u63a5\u5165\u76d1\u542c\u5f15\u64ce\u5f00\u59cb\u6267\u884c");
        try {
            Throwable throwable = null;
            try (TXHandle tx = TX.required((String)"IsvIntegrationEngine");){
                String string = IsvIntegrationEngine.doProcess(bizNo, entityNumber, ids, operationKey);
                return string;
            }
            catch (Exception e) {
                try {
                    tx.markRollback();
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            {
                catch (Throwable throwable3) {
                    throw throwable3;
                }
            }
        }
        finally {
            log.info("\u5f15\u64ce\u6267\u884c\u7ed3\u675f");
        }
    }

    private static String doProcess(String bizNo, String entityNumber, List<Long> ids, String operationKey) {
        ResultObject resultObject = new ResultObject();
        resultObject.setSuccess(new ArrayList<SuccessResultObject>(2));
        List<ListenerConfig> listenerConfigList = IsvConfigService.loadListenerConfig(entityNumber, operationKey);
        Map<Long, String> billMap = IsvIntegrationEngine.loadBillNoMap(entityNumber, ids);
        try {
            for (ListenerConfig listenerConfig : listenerConfigList) {
                List<Long> billIds = BillFilter.filterBySql(entityNumber, ids, listenerConfig.getQfilterStr());
                if (CollectionUtils.isEmpty(billIds)) continue;
                for (PipelineConfig pipelineConfig : listenerConfig.getPipelineConfigs()) {
                    IntegrationLog logContext = MonitorLogUtils.createLogContext(bizNo, entityNumber, listenerConfig, pipelineConfig);
                    List<Long> logIds = IntegrationLogService.saveLog(billMap, logContext, listenerConfig.isSync());
                    boolean isSync = listenerConfig.isSync();
                    if (pipelineConfig instanceof ServiceInvokePipelineConfig) {
                        ServiceInvokePipelineConfig serviceInvokePipelineConfig = (ServiceInvokePipelineConfig)pipelineConfig;
                        BaseServiceInvokeTccService.ServiceInvokerParam serviceInvokerParam = new BaseServiceInvokeTccService.ServiceInvokerParam();
                        serviceInvokerParam.setBizNo(bizNo);
                        serviceInvokerParam.setEntityNumber(entityNumber);
                        serviceInvokerParam.setBillIds(billIds);
                        serviceInvokerParam.setOpKey(operationKey);
                        serviceInvokerParam.setLogIds(logIds);
                        IsvIntegrationEngine.tccTry(StringUtils.lowerCase((String)serviceInvokePipelineConfig.getCloudId()), serviceInvokePipelineConfig.getApp(), serviceInvokePipelineConfig.getClassname(), serviceInvokerParam);
                        continue;
                    }
                    PipelineTccService.PushParam pushParam = new PipelineTccService.PushParam();
                    pushParam.setBizNo(bizNo);
                    pushParam.setEntityNumber(entityNumber);
                    pushParam.setOpKey(operationKey);
                    pushParam.setBillIds(billIds);
                    pushParam.setListenerConfig(listenerConfig);
                    pushParam.setPipelineConfig(pipelineConfig);
                    pushParam.setUserId(RequestContext.get().getCurrUserId());
                    pushParam.setLogIds(logIds);
                    CommonParam commonParam = new CommonParam();
                    commonParam.put((Object)"config", (Object)SerializationUtils.serializeToBase64((Object)((Object)pushParam)));
                    if (isSync) {
                        List<UnionPushRecordObject> unionPushRecordObjects = null;
                        try {
                            unionPushRecordObjects = IsvIntegrationEngine.syncLocalTccTry(commonParam);
                        }
                        catch (Exception e) {
                            log.error("\u540c\u6b65\u6267\u884c\u5931\u8d25", (Throwable)e);
                            resultObject.getFail().add(StringUtils.join((Object[])new String[]{ResManager.loadKDString((String)"\u8054\u5408\u4e0b\u63a8\u201c{0}\u201d\u6267\u884c\u5931\u8d25\u3002", (String)"IsvIntegrationEngine_0", (String)"mpscmm-msisv-isomorphism", (Object[])new Object[]{pipelineConfig.getPipeNumber()}), e.getMessage()}));
                        }
                        if (null == unionPushRecordObjects || unionPushRecordObjects.isEmpty()) continue;
                        SuccessResultObject successResultObject = new SuccessResultObject();
                        successResultObject.setEntityType(unionPushRecordObjects.get(0).getTgtObj().getEntityType());
                        Set<Long> tgtBillIds = unionPushRecordObjects.stream().map(item -> item.getTgtObj().getBillId()).collect(Collectors.toSet());
                        successResultObject.setBillIds(tgtBillIds);
                        resultObject.getSuccess().add(successResultObject);
                        continue;
                    }
                    IsvIntegrationEngine.tccTry("mpscmm", "msisv", "PipelineTccService", pushParam);
                }
            }
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, MonitorResultLogConst.getPipelineErrorMsg(), new Object[0]);
        }
        finally {
            log.info("tcc\u670d\u52a1try\u8c03\u7528\u7ed3\u675f");
        }
        resultObject = IsvIntegrationEngine.mergeResult(resultObject);
        return SerializationUtils.toJsonString((Object)resultObject);
    }

    private static ResultObject mergeResult(ResultObject resultObject) {
        List<SuccessResultObject> resultObjectList = resultObject.getSuccess();
        if (ObjectUtils.isEmpty(resultObjectList)) {
            return resultObject;
        }
        HashMap<String, SuccessResultObject> map = new HashMap<String, SuccessResultObject>(resultObjectList.size());
        for (SuccessResultObject successResultObject : resultObjectList) {
            String entityType = successResultObject.getEntityType();
            SuccessResultObject value = (SuccessResultObject)map.get(entityType);
            if (null == value) {
                map.put(entityType, successResultObject);
                continue;
            }
            value.getBillIds().addAll(successResultObject.getBillIds());
        }
        resultObject.setSuccess(new ArrayList<SuccessResultObject>(map.values()));
        return resultObject;
    }

    private static List<UnionPushRecordObject> syncLocalTccTry(CommonParam param) throws Exception {
        Throwable throwable = null;
        try (TXHandle tx = TX.requiresNew((String)"syncLocalTccTry");){
            CommonDtxResponse commonDtxResponse = (CommonDtxResponse)new PipelineTccService().confirm(param, null);
            List list = (List)commonDtxResponse.get((Object)"union_push_record_map");
            return list;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void tccTry(String cloudId, String appId, String serviceName, CommonParam param) throws TCCTryException {
        TCCGlobalSession.begin((String)"isv_integration_listener", (DBRoute)DBRoute.of((String)TX.getWrittenRouteKey()), (GlobalSessionType)GlobalSessionType.COMBINATION);
        TCCGlobalSession.Try((String)cloudId, (String)appId, (String)serviceName, (Param)param, null);
        TCCGlobalSession.setAsync((boolean)true);
    }

    public static Map<Long, String> loadBillNoMap(String entityType, List<Long> billIds) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)entityType, (String)"id,billno", (QFilter[])qFilter.toArray());
        return Stream.of(bills).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("billno")));
    }
}

