/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.assign;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.util.UnitConvertUtils;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BillAssignConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MasterQtyPropConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.AccumulateAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.ConditionFormulaAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.CumulateAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.OverrideAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.ProportionSplitAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import org.apache.commons.lang3.BooleanUtils;

public interface AbstractPropAssigner {
    public static final Log log = LogFactory.getLog(AbstractPropAssigner.class);

    public Object calcTargetPropVal(MasterQtyPropConfig var1, BillAssignConfig var2, IntegrationObject var3, IntegrationObject var4);

    default public void assignProp(MasterQtyPropConfig masterQtyPropConfig, BillAssignConfig billAssignConfig, IntegrationObject relationObject, IntegrationObject targetObject) {
        String targetPropName = billAssignConfig.getTargetPropName();
        IDataEntityProperty targetProp = targetObject.findProperty(targetPropName);
        if (targetProp instanceof QtyProp) {
            relationObject = UnitConvertUtils.convertUnit(relationObject, targetObject, masterQtyPropConfig);
        }
        Object targetPropValue = this.calcTargetPropVal(masterQtyPropConfig, billAssignConfig, relationObject, targetObject);
        targetPropValue = AbstractPropAssigner.precision(targetObject, targetPropName, targetPropValue);
        targetObject.setPropValue(targetPropName, targetPropValue);
    }

    public static Object precision(IntegrationObject integrationObject, String propName, Object value) {
        if (BooleanUtils.isFalse((Boolean)(value instanceof BigDecimal))) {
            return value;
        }
        IDataEntityProperty property = integrationObject.findProperty(propName);
        if (property == null) {
            log.warn("\u65e0\u6cd5\u627e\u5230\u5c5e\u6027:{}", (Object)propName);
            return value;
        }
        BigDecimal oldAssistNumber = (BigDecimal)value;
        int newScale = oldAssistNumber.scale();
        int roundingMode = 1;
        if (property instanceof QtyProp) {
            QtyProp qtyProp = (QtyProp)property;
            String relatedUnit = qtyProp.getControlPropName();
            DynamicObject unit = (DynamicObject)integrationObject.getPropValue(relatedUnit);
            if (Objects.isNull(unit)) {
                log.info("\u65e0\u6cd5\u627e\u5230\u8ba1\u91cf\u5355\u4f4d\u5c5e\u6027:{}", (Object)relatedUnit);
                return value;
            }
            newScale = unit.getInt("precision");
            roundingMode = unit.getInt("precisionaccount");
        } else if (property instanceof AmountProp) {
            AmountProp amountProp = (AmountProp)property;
            String currencyPropName = amountProp.getControlPropName();
            DynamicObject currency = (DynamicObject)integrationObject.getPropValue(currencyPropName);
            if (Objects.isNull(currency)) {
                log.info("\u65e0\u6cd5\u627e\u5230\u5e01\u522b\u5c5e\u6027:{}", (Object)currencyPropName);
                return value;
            }
            newScale = currency.getInt("amtprecision");
        }
        switch (roundingMode) {
            case 2: {
                return oldAssistNumber.setScale(newScale, RoundingMode.DOWN);
            }
            case 3: {
                return oldAssistNumber.setScale(newScale, RoundingMode.UP);
            }
        }
        return oldAssistNumber.setScale(newScale, RoundingMode.HALF_UP);
    }

    public static AbstractPropAssigner findAssigner(String type) {
        switch (type) {
            case "A": {
                return OverrideAssigner.INSTANCE;
            }
            case "B": {
                return AccumulateAssigner.INSTANCE;
            }
            case "C": {
                return CumulateAssigner.INSTANCE;
            }
            case "D": {
                return ProportionSplitAssigner.INSTANCE;
            }
            case "F": {
                return ConditionFormulaAssigner.INSTANCE;
            }
        }
        return null;
    }
}

