/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.bo;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.helper.FormulaHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class IntegrationObject
implements Cloneable {
    private DynamicObject billObject;
    private DynamicObject entryObject;

    public IntegrationObject(DynamicObject billObject) {
        this.billObject = billObject;
        this.entryObject = billObject;
    }

    public IntegrationObject(DynamicObject billObject, DynamicObject entryObject) {
        this.billObject = billObject;
        this.entryObject = entryObject;
    }

    public DynamicObject getBillObject() {
        return this.billObject;
    }

    public void setBillObject(DynamicObject billObject) {
        this.billObject = billObject;
    }

    public DynamicObject getEntryObject() {
        return this.entryObject;
    }

    public void setEntryObject(DynamicObject entryObject) {
        this.entryObject = entryObject;
    }

    public Object getPropValue(String propName) {
        IDataEntityProperty property = this.findProperty(propName);
        if (null == property) {
            return null;
        }
        if (property.getParent() instanceof BillEntityType) {
            return property.getValue((Object)this.billObject);
        }
        if (!StringUtils.equals((CharSequence)property.getParent().getName(), (CharSequence)this.getEntryNumber())) {
            return property.getValue(this.entryObject.getParent());
        }
        return property.getValue((Object)this.entryObject);
    }

    public Object getExpressionValue(String formula) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.getBillNumber());
        return FormulaHelper.getExpressionValue(mainEntityType, this.getEntryObject(), formula);
    }

    public Object getPropValue(String propName, Object defaultVal) {
        return Optional.ofNullable(this.getPropValue(propName)).orElse(defaultVal);
    }

    public void setPropValue(String propName, Object propValue) {
        DynamicProperty property = RowDataModel.findProperty((MainEntityType)((MainEntityType)this.billObject.getDataEntityType()), (String)propName);
        if (null == property) {
            return;
        }
        if (property instanceof BasedataProp && (propValue instanceof Long || propValue instanceof String)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)((BasedataProp)property).getBaseEntityId());
            dynamicObject.set("id", (Object)NumberUtils.toLong((String)propValue.toString()));
            propValue = dynamicObject;
        }
        if (property.getParent() instanceof BillEntityType) {
            this.billObject.set(property.getName(), propValue);
        } else if (!StringUtils.equals((CharSequence)property.getParent().getName(), (CharSequence)this.getEntryNumber())) {
            ((DynamicObject)this.entryObject.getParent()).set(property.getName(), propValue);
        } else {
            this.entryObject.set(property.getName(), propValue);
        }
    }

    public IntegrationObject copy(boolean isCopyId) {
        boolean clearPrimaryKeyValue;
        boolean bl = clearPrimaryKeyValue = !isCopyId;
        if (this.hasEntry()) {
            DynamicObject parentRow = (DynamicObject)this.entryObject.getParent();
            if (this.entryObject.getDataEntityType() instanceof SubEntryType) {
                DynamicObject newParentRow = this.copy(parentRow, clearPrimaryKeyValue);
                newParentRow.setParent((Object)this.billObject);
                parentRow = newParentRow;
            }
            DynamicObject newSubRow = this.copy(this.getEntryObject(), clearPrimaryKeyValue);
            newSubRow.setParent((Object)parentRow);
            return new IntegrationObject(this.billObject, newSubRow);
        }
        DynamicObject billObject = this.copy(this.getBillObject(), clearPrimaryKeyValue);
        return new IntegrationObject(billObject);
    }

    private DynamicObject copy(DynamicObject dym, boolean clearPrimaryKeyValue) {
        DynamicObject newDym = (DynamicObject)new CloneUtils(false, clearPrimaryKeyValue).clone((IDataEntityBase)dym);
        if (clearPrimaryKeyValue) {
            newDym.set("id", (Object)DB.genGlobalLongId());
        }
        return newDym;
    }

    public boolean hasEntry() {
        return !Objects.equals(this.getBillNumber(), this.getEntryNumber());
    }

    public Object getBillPkValue() {
        return this.billObject.getPkValue();
    }

    public Object getEntryPkValue() {
        return this.entryObject.getPkValue();
    }

    public String getBillNumber() {
        return this.billObject.getDataEntityType().getName();
    }

    public String getEntryNumber() {
        return this.entryObject.getDataEntityType().getName();
    }

    public static List<IntegrationObject> create(DynamicObject billObject, String entryNumber) {
        ArrayList<IntegrationObject> integrationObjectList = new ArrayList<IntegrationObject>();
        if (StringUtils.isNotEmpty((CharSequence)entryNumber)) {
            List<String> entryEntityStack = IntegrationObject.getEntryStack((MainEntityType)billObject.getDataEntityType(), entryNumber);
            DynamicObjectCollection subEntityList = new DynamicObjectCollection();
            subEntityList.add((Object)billObject);
            for (String entryType : entryEntityStack) {
                DynamicObjectCollection dymList = new DynamicObjectCollection();
                for (DynamicObject dym : subEntityList) {
                    DynamicObjectCollection rows = dym.getDynamicObjectCollection(entryType);
                    dymList.addAll((Collection)rows);
                }
                subEntityList = dymList;
            }
            List objectList = subEntityList.stream().map(entryObject -> new IntegrationObject(billObject, (DynamicObject)entryObject)).collect(Collectors.toList());
            integrationObjectList.addAll(objectList);
        } else {
            integrationObjectList.add(new IntegrationObject(billObject));
        }
        return integrationObjectList;
    }

    private static List<String> getEntryStack(MainEntityType mainEntityType, String entityNumber) {
        Map entityTypeMap = mainEntityType.getAllEntities();
        IDataEntityType entityType = (IDataEntityType)entityTypeMap.get(entityNumber);
        ArrayList<String> entityTypeList = new ArrayList<String>();
        entityTypeList.add(entityNumber);
        while (null != entityType && null != entityType.getParent()) {
            if (!((entityType = entityType.getParent()) instanceof EntryType)) continue;
            entityTypeList.add(0, entityType.getName());
        }
        return entityTypeList;
    }

    public static List<IntegrationObject> create(List<DynamicObject> billObjects, String entryNumber) {
        ArrayList<IntegrationObject> integrationObjectList = new ArrayList<IntegrationObject>();
        for (DynamicObject billObject : billObjects) {
            integrationObjectList.addAll(IntegrationObject.create(billObject, entryNumber));
        }
        return integrationObjectList;
    }

    public IDataEntityProperty findProperty(String propName) {
        return RowDataModel.findProperty((MainEntityType)((MainEntityType)this.billObject.getDataEntityType()), (String)propName);
    }

    public BigDecimal getOriginMasterQty(String masterQtyPropName) {
        return (BigDecimal)this.getPropValue(masterQtyPropName);
    }

    public String getBillNo() {
        BillEntityType billEntityType = (BillEntityType)this.billObject.getDataEntityType();
        String billNoPropName = billEntityType.getBillNo();
        if (StringUtils.isBlank((CharSequence)billNoPropName)) {
            return null;
        }
        return (String)this.getPropValue(billNoPropName);
    }
}

