/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.ec;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.KdtxRequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.util.ContextHolderUtils;
import kd.mpscmm.msisv.isomorphism.common.util.IdempotentPropertiesUtils;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ListenerConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PushPipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IdempotentKey;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.TargetBillOperator;
import kd.mpscmm.msisv.isomorphism.core.engine.filter.BillFilter;
import kd.mpscmm.msisv.isomorphism.core.engine.operate.BillOperator;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.ListenerPushPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.PipelineAdaptor;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.RelationPushPipeline;
import kd.mpscmm.msisv.isomorphism.core.log.service.IntegrationLogService;
import kd.mpscmm.msisv.isomorphism.core.log.service.UnionPushRecordService;
import kd.mpscmm.msisv.isomorphism.core.log.vo.UnionPushRecordObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class PipelineEcService
extends BaseECService
implements IdempotentService {
    private static Log log = LogFactory.getLog(PipelineEcService.class);

    protected DtxResponse doExecute(Object param, Object o1) throws Exception {
        CommonParam commonParam = (CommonParam)param;
        String configJson = commonParam.getString((Object)"config");
        PushParam pushParam = (PushParam)((Object)SerializationUtils.deSerializeFromBase64((String)configJson));
        ContextHolderUtils.initUserId(pushParam.getUserId());
        log.info("[PipelineEcService.doExecute]kdtx xid:{}", (Object)KdtxRequestContext.get().getXid());
        try {
            DtxResponse dtxResponse = this.doBizConfirm((Object)pushParam);
            IntegrationLogService.updateLog(pushParam.getLogIds());
            return dtxResponse;
        }
        catch (Exception e) {
            log.error("[PipelineEcService.doExecute]\u6d41\u6c34\u7ebf\u5f02\u5e38", (Throwable)e);
            IntegrationLogService.updateMonitorLog(pushParam.getLogIds(), e);
            throw e;
        }
    }

    private DtxResponse doBizConfirm(Object param) throws Exception {
        TargetBillOperator targetBillOperator;
        PushPipelineConfig pushPipelineConfig;
        PushParam pushParam = (PushParam)((Object)param);
        String bizNo = pushParam.getBizNo();
        Long userId = pushParam.getUserId();
        ContextHolderUtils.initUserId(userId);
        ListenerConfig listenerConfig = pushParam.getListenerConfig();
        PipelineConfig pipelineConfig = pushParam.getPipelineConfig();
        pipelineConfig.init();
        DynamicObject[] billList = BusinessDataServiceHelper.load((Object[])pushParam.getBillIds().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)pushParam.getEntityNumber()));
        if (0 == billList.length) {
            throw new KDBizException(MonitorResultLogConst.getListenerObjEmptyMsg(), new Object[0]);
        }
        List<IntegrationObject> bizObjects = IntegrationObject.create(Arrays.asList(billList), null);
        String className = pipelineConfig.getPipeline();
        if (ListenerPushPipeline.class.getName().equals(className)) {
            pushPipelineConfig = (PushPipelineConfig)pipelineConfig;
            bizObjects = pushPipelineConfig.getBotpConfig().getSourceBizObjectConfig().expand(bizObjects);
        } else if (RelationPushPipeline.class.getName().equals(className)) {
            pushPipelineConfig = (PushPipelineConfig)pipelineConfig;
            bizObjects = pushPipelineConfig.getRelationObjectConfig().getRelationBizObjectConfig().expand(bizObjects);
        }
        bizObjects = BillFilter.filter(bizObjects, listenerConfig.getFilterExpression());
        if (CollectionUtils.isEmpty(bizObjects)) {
            log.info("[PipelineEcService.doBizConfirm]\u76d1\u542c\u5bf9\u8c61\u8fc7\u6ee4\u4e3a\u7a7a,\u6d41\u6c34\u7ebf\u7f16\u53f7:{},\u540d\u79f0:{}", (Object)pipelineConfig.getPipeNumber(), (Object)pipelineConfig.getPipeName());
            return null;
        }
        HashMap<Long, HashSet<Long>> billIdMap = new HashMap<Long, HashSet<Long>>();
        for (IntegrationObject bizObject : bizObjects) {
            Long billId = (Long)bizObject.getBillPkValue();
            HashSet<Long> entryIds = (HashSet<Long>)billIdMap.get(billId);
            if (null == entryIds) {
                entryIds = new HashSet<Long>(2);
                billIdMap.put(billId, entryIds);
            }
            entryIds.add((Long)bizObject.getEntryPkValue());
        }
        String entityType = pushParam.getEntityNumber();
        ArrayList<UnionPushRecordObject> allUnionPushRecords = new ArrayList<UnionPushRecordObject>(2);
        List<UnionPushRecordObject> historyUnionPushRecords = UnionPushRecordService.loadUnionPushRecord(pipelineConfig, entityType, bizObjects);
        allUnionPushRecords.addAll(historyUnionPushRecords);
        bizObjects = this.filterByHistory(pipelineConfig, entityType, bizObjects);
        if (CollectionUtils.isNotEmpty(bizObjects) && null != (targetBillOperator = new PipelineAdaptor(listenerConfig, bizNo, pushParam.getBillIds()).work(pipelineConfig, bizObjects)) && CollectionUtils.isNotEmpty(targetBillOperator.getTargetBillList())) {
            BillOperator.operate(bizNo, listenerConfig, pipelineConfig, targetBillOperator);
            List<UnionPushRecordObject> newUnionPushRecords = targetBillOperator.getUnionPushRecordList();
            if (CollectionUtils.isNotEmpty(newUnionPushRecords)) {
                allUnionPushRecords.addAll(newUnionPushRecords);
            }
        }
        CommonDtxResponse commonDtxResponse = new CommonDtxResponse();
        commonDtxResponse.put((Object)"union_push_record_map", allUnionPushRecords);
        return commonDtxResponse;
    }

    private List<IntegrationObject> filterByHistory(PipelineConfig pipelineConfig, String entityType, List<IntegrationObject> bizObjects) {
        String className = pipelineConfig.getPipeline();
        Object[] pushPipelineList = new String[]{ListenerPushPipeline.class.getName(), RelationPushPipeline.class.getName()};
        if (!ArrayUtils.contains((Object[])pushPipelineList, (Object)className)) {
            return bizObjects;
        }
        Map<Long, BigDecimal> remainQtyMap = UnionPushRecordService.queryPushedRemainQty(pipelineConfig, entityType, bizObjects, false);
        return bizObjects.stream().filter(item -> {
            BigDecimal remainQty = (BigDecimal)remainQtyMap.get(item.getEntryPkValue());
            if (null != remainQty) {
                return remainQty.compareTo(BigDecimal.ZERO) > 0;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object lastReturn) {
        CommonParam commonParam = (CommonParam)param;
        String configJson = commonParam.getString((Object)"config");
        PushParam pushParam = (PushParam)((Object)SerializationUtils.deSerializeFromBase64((String)configJson));
        IdempotentKey idempotentKey = new IdempotentKey();
        idempotentKey.setBizNo(pushParam.getBizNo());
        idempotentKey.setBillIds(pushParam.getBillIds());
        idempotentKey.setEntityNumber(pushParam.getEntityNumber());
        idempotentKey.setOpKey(pushParam.getOpKey());
        idempotentKey.setListenerNumber(pushParam.getListenerConfig().getNumber());
        idempotentKey.setActionNumber(pushParam.getPipelineConfig().getPipeNumber());
        idempotentKey.setTag(((Object)((Object)this)).getClass().getName());
        return IdempotentPropertiesUtils.generate(((Object)((Object)this)).getClass().getName(), idempotentKey);
    }

    public static class PushParam
    extends CommonParam {
        private String bizNo;
        private String entityNumber;
        private List<Long> billIds;
        private String opKey;
        private ListenerConfig listenerConfig;
        private PipelineConfig pipelineConfig;
        private Long userId;
        private List<Long> logIds;

        public String getBizNo() {
            return this.bizNo;
        }

        public PushParam setBizNo(String bizNo) {
            this.bizNo = bizNo;
            return this;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public PushParam setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
            return this;
        }

        public List<Long> getBillIds() {
            return this.billIds;
        }

        public PushParam setBillIds(List<Long> billIds) {
            this.billIds = billIds;
            return this;
        }

        public String getOpKey() {
            return this.opKey;
        }

        public PushParam setOpKey(String opKey) {
            this.opKey = opKey;
            return this;
        }

        public ListenerConfig getListenerConfig() {
            return this.listenerConfig;
        }

        public PushParam setListenerConfig(ListenerConfig listenerConfig) {
            this.listenerConfig = listenerConfig;
            return this;
        }

        public PipelineConfig getPipelineConfig() {
            return this.pipelineConfig;
        }

        public PushParam setPipelineConfig(PipelineConfig pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        public Long getUserId() {
            return this.userId;
        }

        public PushParam setUserId(Long userId) {
            this.userId = userId;
            return this;
        }

        public List<Long> getLogIds() {
            return this.logIds;
        }

        public PushParam setLogIds(List<Long> logIds) {
            this.logIds = logIds;
            return this;
        }
    }
}

