/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.formula.FormulaEngine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillFilter {
    public static List<IntegrationObject> filter(List<IntegrationObject> integrationObjectList, String filterExpression) {
        if (CollectionUtils.isEmpty(integrationObjectList)) {
            return Collections.emptyList();
        }
        if (StringUtils.isBlank((CharSequence)filterExpression)) {
            return integrationObjectList;
        }
        MainEntityType mainEntityType = (MainEntityType)integrationObjectList.get(0).getBillObject().getDataEntityType();
        return integrationObjectList.stream().filter(item -> BillFilter.checkHighCondition(mainEntityType, item.getEntryObject(), filterExpression)).collect(Collectors.toList());
    }

    public static boolean checkHighCondition(MainEntityType mainEntityType, DynamicObject dynamicObject, String filterExpression) {
        if (StringUtils.isBlank((CharSequence)filterExpression)) {
            return true;
        }
        String entryName = dynamicObject.getDataEntityType().getName();
        RowDataModel rowDataModel = new RowDataModel(entryName, mainEntityType);
        rowDataModel.setRowContext(dynamicObject);
        ExpressionParameter expressionParameter = new ExpressionParameter(filterExpression, rowDataModel);
        Set vars = expressionParameter.getBOSExpression().getVars();
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String var : vars) {
            Object value = rowDataModel.getValue(var);
            if (value instanceof OrmLocaleValue) {
                params.put(var, ((OrmLocaleValue)value).getLocaleValue());
                continue;
            }
            params.put(var, value);
        }
        return (Boolean)FormulaEngine.execExcelFormula((String)filterExpression, params);
    }

    public static List<Long> filterBySql(String entityNumber, List<Long> billIds, String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            return billIds;
        }
        QFilter qFilter = new QFilter("id", "in", billIds);
        qFilter.and(QFilter.fromSerializedString((String)filter));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])qFilter.toArray(), null);
        return collection.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
    }
}

