/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.generate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BotpConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.ConvertResult;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import org.apache.commons.collections.CollectionUtils;

public class BotpBillGenerator {
    private static final Log log = LogFactory.getLog(BotpBillGenerator.class);

    public static ConvertResult generateBill(BotpConfig botpConfig, List<IntegrationObject> srcObjects) {
        if (CollectionUtils.isEmpty(srcObjects)) {
            log.info("botp source is empty");
            return new ConvertResult();
        }
        log.info("botp[{}] src[{}] -> tgt[{}]", new Object[]{botpConfig.getBotpRuleId(), botpConfig.getSourceBizObjectConfig().getBillNumber(), botpConfig.getTargetBizObjectConfig().getBillNumber()});
        ConvertOperationResult convertOperationResult = null;
        try {
            PushArgs args = BotpBillGenerator.buildArgs(botpConfig, srcObjects);
            convertOperationResult = ConvertServiceHelper.push((PushArgs)args);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, MonitorResultLogConst.getBotpExceptionMsg(), new Object[0]);
        }
        if (Objects.isNull(convertOperationResult)) {
            throw new KDBizException(MonitorResultLogConst.getBotpExceptionMsg(), new Object[0]);
        }
        if (!convertOperationResult.isSuccess()) {
            log.info("botp\u5931\u8d25:{}", (Object)convertOperationResult.getBillReports());
            StringBuilder reports = new StringBuilder();
            for (SourceBillReport billReport : convertOperationResult.getBillReports()) {
                reports.append(billReport.toString());
            }
            throw new KDBizException(new ErrorCode("MONITOR_LOG_BOTP_EXCEPTION", reports.toString()), new Object[0]);
        }
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)botpConfig.getTargetBizObjectConfig().getBillNumber());
        List dynamicObjectList = convertOperationResult.loadTargetDataObjects((dynamicObjects, dType) -> BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType), mainType);
        BotpBillGenerator.fillPkIds(dynamicObjectList);
        List<IntegrationObject> integrationObjects = IntegrationObject.create(dynamicObjectList, botpConfig.getTargetBizObjectConfig().getEntryNumber());
        Map attachmentInfoMap = convertOperationResult.getBillAttachmentPanelInfos();
        return new ConvertResult(integrationObjects, attachmentInfoMap);
    }

    private static void fillPkIds(List<DynamicObject> dymList) {
        if (CollectionUtils.isEmpty(dymList)) {
            return;
        }
        BillEntityType billEntityType = (BillEntityType)dymList.get(0).getDataEntityType();
        Map entityTypeMap = billEntityType.getAllEntities();
        HashMap<String, Set<String>> subMap = new HashMap<String, Set<String>>(entityTypeMap.size());
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType) continue;
            HashSet subSet = (HashSet)subMap.get(entityType.getParent().getName());
            if (null == subSet) {
                subSet = new HashSet(2);
                subMap.put(entityType.getParent().getName(), subSet);
            }
            subSet.add(entry.getKey());
        }
        for (DynamicObject dynamicObject : dymList) {
            BotpBillGenerator.fillPkId(dynamicObject, subMap);
        }
    }

    private static void fillPkId(DynamicObject dym, Map<String, Set<String>> subMap) {
        Set<String> subEntityNames;
        Long pkId = (Long)dym.getPkValue();
        if (null == pkId || 0L == pkId) {
            dym.set("id", (Object)DB.genGlobalLongId());
        }
        if (CollectionUtils.isEmpty(subEntityNames = subMap.get(dym.getDataEntityType().getName()))) {
            return;
        }
        for (String subEntityName : subEntityNames) {
            DynamicObjectCollection rows = dym.getDynamicObjectCollection(subEntityName);
            for (DynamicObject row : rows) {
                BotpBillGenerator.fillPkId(row, subMap);
            }
        }
    }

    private static PushArgs buildArgs(BotpConfig botpConfig, List<IntegrationObject> integrationObjectList) {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(botpConfig.getSourceBizObjectConfig().getBillNumber());
        pushArgs.setTargetEntityNumber(botpConfig.getTargetBizObjectConfig().getBillNumber());
        pushArgs.setRuleId(botpConfig.getBotpRuleId());
        pushArgs.setSelectedRows(BotpBillGenerator.buildSelectedRows(botpConfig, integrationObjectList));
        return pushArgs;
    }

    private static List<ListSelectedRow> buildSelectedRows(BotpConfig botpConfig, List<IntegrationObject> integrationObjectList) {
        return integrationObjectList.stream().map(integrationObject -> {
            ListSelectedRow row = new ListSelectedRow(integrationObject.getBillPkValue(), Boolean.TRUE);
            if (integrationObject.hasEntry()) {
                row.setEntryEntityKey(botpConfig.getSourceBizObjectConfig().getEntryNumber());
                row.setEntryPrimaryKeyValue(integrationObject.getEntryPkValue());
            }
            return row;
        }).collect(Collectors.toList());
    }
}

