/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.helper.BotpRelationHelper;
import kd.mpscmm.msisv.isomorphism.common.helper.EntityHelper;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherPropConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationGroup;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class BillGroup {
    private static final Log log = LogFactory.getLog(BillGroup.class);

    public static List<IntegrationGroup> groupBy(MatcherConfig matchConditionConfig, List<IntegrationObject> integrationObjectList) {
        Map<Long, Map<String, Object>> getFieldValMap = BotpRelationHelper.findBotpRelation(matchConditionConfig, integrationObjectList);
        LinkedHashMap<Map<String, Object>, IntegrationGroup> map = new LinkedHashMap<Map<String, Object>, IntegrationGroup>();
        for (IntegrationObject integrationObject : integrationObjectList) {
            Map<String, Object> groupKey = BillGroup.buildGroupKey(matchConditionConfig, integrationObject, getFieldValMap);
            if (groupKey.isEmpty()) continue;
            IntegrationGroup integrationGroup = (IntegrationGroup)map.get(groupKey);
            if (integrationGroup != null) {
                integrationGroup.add(integrationObject);
                continue;
            }
            ArrayList<IntegrationObject> list = new ArrayList<IntegrationObject>();
            list.add(integrationObject);
            map.put(groupKey, new IntegrationGroup(groupKey, list));
        }
        return new ArrayList<IntegrationGroup>(map.values());
    }

    private static Map<String, Object> buildGroupKey(MatcherConfig mathConditionConfig, IntegrationObject integrationObject, Map<Long, Map<String, Object>> getFieldValMap) {
        List<MatcherPropConfig> matcherList = mathConditionConfig.getMatcherPropConfigList();
        HashMap<String, Object> groupKey = new HashMap<String, Object>(CollectionUtils.size(matcherList));
        for (MatcherPropConfig matcherPropConfig : matcherList) {
            String propName = matcherPropConfig.getSourcePropName();
            if (mathConditionConfig.isBotpMatch()) {
                Map<String, Object> getValMap = getFieldValMap.get(integrationObject.getEntryPkValue());
                if (ObjectUtils.isNotEmpty(getValMap)) {
                    String sourcePropName = matcherPropConfig.getSourcePropName();
                    Object propValue = getValMap.get(sourcePropName);
                    groupKey.put(propName, BillGroup.getPKValue(propValue));
                    continue;
                }
                return Collections.emptyMap();
            }
            Object propValue = integrationObject.getPropValue(propName);
            groupKey.put(propName, BillGroup.getPKValue(propValue));
        }
        return groupKey;
    }

    private static Object getPKValue(Object propValue) {
        if (propValue == null) {
            return null;
        }
        if (propValue instanceof DynamicObject) {
            DynamicObject dym = (DynamicObject)propValue;
            String entityType = dym.getDataEntityType().getName();
            if (EntityHelper.isMaterialInfoProp(entityType)) {
                return dym.getDynamicObject("masterid").getPkValue();
            }
            return dym.getPkValue();
        }
        if (propValue instanceof OrmLocaleValue) {
            OrmLocaleValue ormLocaleValue = (OrmLocaleValue)propValue;
            return ormLocaleValue.getLocaleValue_zh_CN();
        }
        return propValue;
    }
}

