/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.MaterielProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.helper.EntityHelper;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherPropConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.log.vo.UnionPushRecordObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillMatcher {
    private static final Log log = LogFactory.getLog(BillMatcher.class);
    public static final String BILLHEAD_LK = "billhead_lk";

    public static List<IntegrationObject> match(MatcherConfig matcherConfig, Map<String, Object> groupKey, List<IntegrationObject> srcObjects) {
        List<IntegrationObject> matchObjects;
        try {
            log.info("\u5339\u914d\u6761\u4ef6:{}", groupKey);
            matchObjects = BillMatcher.match(matcherConfig, groupKey);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, MonitorResultLogConst.getMatchFailMsg(), new Object[0]);
        }
        log.info("\u5339\u914d\u5355:{}", matchObjects.stream().map(IntegrationObject::getBillNo).collect(Collectors.toSet()));
        return matchObjects;
    }

    public static List<IntegrationObject> match(MatcherConfig matcherConfig, Map<String, Object> groupKey) {
        String relEntityType = matcherConfig.getRelationBizObjectConfig().getBillNumber();
        QFilter[] filters = BillMatcher.buildFilter(relEntityType, matcherConfig.getMatcherPropConfigList(), groupKey);
        String relationEntryNumber = matcherConfig.getRelationEntryNumber();
        String selectFields = "id," + BillMatcher.concat(relationEntryNumber, "id as entryId");
        String relationEntryPkName = "entryId";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)relEntityType, (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return Collections.emptyList();
        }
        HashSet<Object> pkIds = new HashSet<Object>();
        HashSet<Object> entryPkIds = new HashSet<Object>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            pkIds.add(dynamicObject.get("id"));
            entryPkIds.add(dynamicObject.get(relationEntryPkName));
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)matcherConfig.getRelationBizObjectConfig().getBillNumber());
        DynamicObject[] relBills = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)mainEntityType);
        List<IntegrationObject> relObjects = IntegrationObject.create(Arrays.asList(relBills), relationEntryNumber);
        return relObjects.stream().filter(item -> entryPkIds.contains(item.getEntryPkValue())).collect(Collectors.toList());
    }

    private static String concat(String entryNumber, String propName) {
        if (StringUtils.isBlank((CharSequence)entryNumber)) {
            return propName;
        }
        return entryNumber + "." + propName;
    }

    private static QFilter[] buildFilter(String entityType, List<MatcherPropConfig> matcherPropConfigList, Map<String, Object> groupKey) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        int size = matcherPropConfigList.size();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(size);
        for (MatcherPropConfig matcherPropConfig : matcherPropConfigList) {
            QFilter filter;
            Object value;
            Object convertValue = matcherPropConfig.convert(value = groupKey.get(matcherPropConfig.getGroupKey()));
            if (BillMatcher.checkEmptyValue(convertValue)) {
                log.info("\u5339\u914d\u503c\u4e3a\u7a7a\uff0c\u5b57\u6bb5:{},\u503c:{}", (Object)matcherPropConfig.getGroupKey(), value);
                filterList.add(new QFilter("1", "!=", (Object)1));
                break;
            }
            DynamicProperty property = RowDataModel.findProperty((MainEntityType)mainEntityType, (String)matcherPropConfig.getRelationPropName());
            if (property instanceof MaterielProp && EntityHelper.isMaterialInfoProp(((MaterielProp)property).getBaseEntityId())) {
                filter = new QFilter(matcherPropConfig.getRelationPropName() + ".masterid", "=", convertValue);
                filterList.add(filter);
                continue;
            }
            filter = new QFilter(matcherPropConfig.getRelationPropName(), "=", convertValue);
            filterList.add(filter);
        }
        return filterList.toArray(new QFilter[size]);
    }

    private static boolean checkEmptyValue(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return StringUtils.isBlank((CharSequence)((String)value));
            }
            if (value instanceof BigDecimal) {
                return BigDecimal.ZERO.compareTo((BigDecimal)value) == 0;
            }
            if (value instanceof Long) {
                return Objects.equals(0L, (Long)value);
            }
            if (value instanceof Integer) {
                return Objects.equals(0, (Integer)value);
            }
            return false;
        }
        return true;
    }

    public static List<IntegrationObject> matchWithBotp(List<IntegrationObject> srcObjects, List<IntegrationObject> targetObjects) {
        ArrayList<IntegrationObject> resultObjects = new ArrayList<IntegrationObject>();
        for (IntegrationObject srcObject : srcObjects) {
            List<IntegrationObject> matchTargetObjects = BillMatcher.findBySourceObject(srcObject, targetObjects);
            if (!CollectionUtils.isNotEmpty(matchTargetObjects)) continue;
            resultObjects.addAll(matchTargetObjects);
        }
        return resultObjects;
    }

    private static List<IntegrationObject> findBySourceObject(IntegrationObject sourceObject, List<IntegrationObject> targetIntegrationObjects) {
        String entryNumber;
        Object srcBillId = sourceObject.getBillPkValue();
        Object srcEntryId = sourceObject.getEntryPkValue();
        BillEntityType targetBillType = (BillEntityType)targetIntegrationObjects.get(0).getBillObject().getDataEntityType();
        LinkEntryType linkEntryType = BillMatcher.findLinkEntryType(targetBillType, entryNumber = targetIntegrationObjects.get(0).getEntryNumber());
        if (linkEntryType == null) {
            return Collections.emptyList();
        }
        String lkEntryName = linkEntryType.getName();
        String lkEntryId = lkEntryName + "_sid";
        String lkBillId = lkEntryName + "_sbillid";
        boolean isHead = BILLHEAD_LK.equals(lkEntryName);
        return targetIntegrationObjects.stream().filter(item -> {
            DynamicObjectCollection links = isHead ? item.getBillObject().getDynamicObjectCollection(lkEntryName) : item.getEntryObject().getDynamicObjectCollection(lkEntryName);
            for (DynamicObject link : links) {
                boolean equals = true;
                if (sourceObject.hasEntry()) {
                    equals = srcEntryId.equals(link.get(lkEntryId));
                }
                if (!equals || !srcBillId.equals(link.get(lkBillId))) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private static LinkEntryType findLinkEntryType(BillEntityType billEntityType, String entryNumber) {
        LinkEntryType linkEntryType = null;
        for (EntityType entityType : billEntityType.getAllEntities().values()) {
            if (!(entityType instanceof LinkEntryType) || !entityType.getParent().getName().equals(entryNumber)) continue;
            linkEntryType = (LinkEntryType)entityType;
            break;
        }
        return linkEntryType;
    }

    public static UnionPushRecordObject.UnionPushEntity getSrcLink(String srcEntityType, IntegrationObject targetObj) {
        String entryNumber;
        BillEntityType targetBillType = (BillEntityType)targetObj.getBillObject().getDataEntityType();
        LinkEntryType linkEntryType = BillMatcher.findLinkEntryType(targetBillType, entryNumber = targetObj.getEntryNumber());
        if (null == linkEntryType) {
            return null;
        }
        String lkEntryName = linkEntryType.getName();
        String lkEntryId = lkEntryName + "_sid";
        String lkBillId = lkEntryName + "_sbillid";
        boolean isHead = BILLHEAD_LK.equals(lkEntryName);
        DynamicObjectCollection links = isHead ? targetObj.getBillObject().getDynamicObjectCollection(lkEntryName) : targetObj.getEntryObject().getDynamicObjectCollection(lkEntryName);
        if (CollectionUtils.isEmpty((Collection)links)) {
            return null;
        }
        DynamicObject link = (DynamicObject)links.get(0);
        UnionPushRecordObject.UnionPushEntity unionPushEntity = new UnionPushRecordObject.UnionPushEntity();
        unionPushEntity.setEntityType(srcEntityType);
        unionPushEntity.setBillId(link.getLong(lkBillId));
        unionPushEntity.setEntryId(link.getLong(lkEntryId));
        return unionPushEntity;
    }
}

