/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.operate;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AttachmentItemInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.helper.AttachmentHelper;
import kd.mpscmm.msisv.isomorphism.common.helper.SnHelper;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ListenerConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.OperationConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.RelationUpdatePipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.CarrySnInfo;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.TargetBillOperator;
import kd.mpscmm.msisv.isomorphism.core.engine.filter.BillFilter;
import kd.mpscmm.msisv.isomorphism.core.log.service.UnionPushRecordService;
import kd.mpscmm.msisv.isomorphism.mservice.OperatorIdempotentService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class BillOperator {
    private static Log log = LogFactory.getLog(BillOperator.class);

    public static void operate(String bizNo, ListenerConfig listenerConfig, PipelineConfig pipelineConfig, TargetBillOperator targetBillOperator) throws Exception {
        block0: for (DynamicObject targetBill : targetBillOperator.getTargetBillList()) {
            String targetEntityNumber = targetBill.getDataEntityType().getName();
            List<OperationConfig> operationConfigList = targetBillOperator.getOperationConfigList();
            Map<Long, List<CarrySnInfo>> snInfoMap = targetBillOperator.getSnInfoMap();
            for (int opIdx = 0; opIdx < operationConfigList.size(); ++opIdx) {
                OperationConfig operationConfig = operationConfigList.get(opIdx);
                String targetFilterExp = operationConfig.getConditionExpression();
                MainEntityType mainEntityType = (MainEntityType)targetBill.getDataEntityType();
                if (!BillOperator.checkHighCondition(pipelineConfig, mainEntityType, targetBill, targetFilterExp)) {
                    log.info("\u76ee\u6807\u5355\u64cd\u4f5c\u4e0d\u7b26\u5408\u6761\u4ef6[{}]:{},\u64cd\u4f5c:{}", new Object[]{targetEntityNumber, targetBill.getPkValue(), operationConfig.getOperationKey()});
                    continue block0;
                }
                OperatorIdempotentService.TargetOperatorParam targetOperatorParam = new OperatorIdempotentService.TargetOperatorParam();
                targetOperatorParam.setBizNo(bizNo);
                targetOperatorParam.setListenerConfig(listenerConfig);
                targetOperatorParam.setPipelineConfig(pipelineConfig);
                targetOperatorParam.setActionOp(operationConfigList.get(opIdx).getOperationKey());
                targetOperatorParam.setTargetEntityNumber(targetEntityNumber);
                String billJson = null;
                if (opIdx == 0) {
                    billJson = SerializationUtils.serializeToBase64((Object)targetBill);
                }
                targetOperatorParam.setTargetBillJson(billJson);
                targetOperatorParam.setTargetFid((Long)targetBill.getPkValue());
                if ("save".equals(operationConfig.getOperationKey())) {
                    Object billId = targetBill.getPkValue();
                    Map<Object, Map<String, List<AttachmentItemInfo>>> attachmentInfoMap = targetBillOperator.getAttachmentInfoMap();
                    Map attachmentItemMap = (Map)MapUtils.getObject(attachmentInfoMap, (Object)billId.toString());
                    if (null != attachmentItemMap) {
                        AttachmentHelper.persistAttachments(mainEntityType, billId, attachmentItemMap);
                    }
                }
                new OperatorIdempotentService().execute((Object)targetOperatorParam, null);
                if (!"save".equals(operationConfig.getOperationKey())) continue;
                UnionPushRecordService.saveUnionPushRecord(pipelineConfig, targetBillOperator.getUnionPushRecordList(), (Long)targetBill.getPkValue());
                if (null == snInfoMap) continue;
                SnHelper.saveSn(snInfoMap.get((Long)targetBill.getPkValue()));
            }
        }
    }

    private static boolean checkHighCondition(PipelineConfig pipelineConfig, MainEntityType mainEntityType, DynamicObject targetBill, String targetFilterExp) {
        if (pipelineConfig instanceof RelationUpdatePipelineConfig && StringUtils.isNotBlank((CharSequence)targetFilterExp)) {
            RelationUpdatePipelineConfig relationUpdatePipelineConfig = (RelationUpdatePipelineConfig)pipelineConfig;
            List<IntegrationObject> targetObjects = IntegrationObject.create(targetBill, relationUpdatePipelineConfig.getTargetBizObjectConfig().getEntryNumber());
            List<IntegrationObject> filterTargetObjects = BillFilter.filter(targetObjects, targetFilterExp);
            return CollectionUtils.size(filterTargetObjects) == CollectionUtils.size(targetObjects);
        }
        return BillFilter.checkHighCondition(mainEntityType, targetBill, targetFilterExp);
    }
}

