/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BillAssignConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MasterQtyPropConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.AbstractPropAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.SplitResultObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.TargetBillOperator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public interface AbstractPipeline {
    public static final Log log = LogFactory.getLog(AbstractPipeline.class);

    default public List<DynamicObject> assignAllTargetProps(List<SplitResultObject> splitResultObjectList, MasterQtyPropConfig masterQtyPropConfig, List<BillAssignConfig> billAssignConfigList) {
        ArrayList<IntegrationObject> targetObjects = new ArrayList<IntegrationObject>(splitResultObjectList.size());
        for (SplitResultObject splitResultObject : splitResultObjectList) {
            List<IntegrationObject> resultList = this.assignProps(masterQtyPropConfig, billAssignConfigList, splitResultObject);
            if (!ObjectUtils.isNotEmpty(resultList)) continue;
            targetObjects.addAll(resultList);
        }
        return this.convert2DynamicObject(targetObjects);
    }

    default public List<IntegrationObject> assignProps(MasterQtyPropConfig masterQtyPropConfig, List<BillAssignConfig> billAssignConfigList, SplitResultObject splitResultObject) {
        List<IntegrationObject> relationObjectList = splitResultObject.getRelationObjectList();
        List<IntegrationObject> targetObjectList = splitResultObject.getTargetObjectList();
        if (CollectionUtils.isEmpty(relationObjectList) || CollectionUtils.isEmpty(targetObjectList)) {
            return Collections.emptyList();
        }
        int relationSize = CollectionUtils.size(relationObjectList);
        int targetSize = CollectionUtils.size(targetObjectList);
        for (int idx = 0; idx < targetSize; ++idx) {
            IntegrationObject sourceObject = relationSize > idx ? relationObjectList.get(idx) : null;
            IntegrationObject targetObject = targetObjectList.get(idx);
            for (BillAssignConfig billAssignConfig : billAssignConfigList) {
                AbstractPropAssigner abstractPropAssigner = AbstractPropAssigner.findAssigner(billAssignConfig.getValueAssigner());
                if (abstractPropAssigner == null) continue;
                try {
                    abstractPropAssigner.assignProp(masterQtyPropConfig, billAssignConfig, sourceObject, targetObject);
                }
                catch (KDBizException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error("\u8d4b\u503c\u64cd\u4f5c\u5931\u8d25,\u8d4b\u503c\u5b57\u6bb5:{},\u8d4b\u503c\u65b9\u5f0f:{}", (Object)billAssignConfig.getTargetPropName(), (Object)abstractPropAssigner.getClass().getSimpleName());
                    throw new KDBizException((Throwable)e, MonitorResultLogConst.getAssignErrorMsg(), new Object[0]);
                }
            }
        }
        return targetObjectList;
    }

    public TargetBillOperator work(PipelineConfig var1, List<IntegrationObject> var2);

    default public List<DynamicObject> convert2DynamicObject(List<IntegrationObject> integrationObjectList) {
        if (CollectionUtils.isEmpty(integrationObjectList)) {
            return Collections.emptyList();
        }
        DynamicObjectCollection billCollection = new DynamicObjectCollection();
        IntegrationObject integrationObject = integrationObjectList.get(0);
        if (integrationObject.hasEntry()) {
            DynamicObjectType entryType = (DynamicObjectType)integrationObject.getEntryObject().getDataEntityType();
            boolean isSubEntryEntity = entryType instanceof SubEntryType;
            Map dynamicObjectListMap = integrationObjectList.stream().collect(Collectors.groupingBy(IntegrationObject::getBillPkValue, Collectors.toList()));
            for (List groupList : dynamicObjectListMap.values()) {
                DynamicObject billObject = ((IntegrationObject)groupList.get(0)).getBillObject();
                if (isSubEntryEntity) {
                    DynamicObject parentEntity;
                    Object entry2;
                    TreeMap<Long, DynamicObject> entryMap = new TreeMap<Long, DynamicObject>();
                    TreeMap<Long, DynamicObjectCollection> subEntryMap = new TreeMap<Long, DynamicObjectCollection>();
                    for (Object entry2 : groupList) {
                        DynamicObject subEntryEntity = ((IntegrationObject)entry2).getEntryObject();
                        parentEntity = (DynamicObject)subEntryEntity.getParent();
                        Long parentEntryId = (Long)parentEntity.getPkValue();
                        entryMap.put(parentEntryId, parentEntity);
                        DynamicObjectCollection subEntryCollection = (DynamicObjectCollection)subEntryMap.get(parentEntryId);
                        if (null == subEntryCollection) {
                            subEntryCollection = new DynamicObjectCollection(entryType, (Object)parentEntity);
                            subEntryMap.put(parentEntryId, subEntryCollection);
                        }
                        subEntryCollection.add((Object)subEntryEntity);
                    }
                    DynamicObjectCollection entryCollection = new DynamicObjectCollection();
                    entry2 = subEntryMap.entrySet().iterator();
                    while (entry2.hasNext()) {
                        Map.Entry entry3 = (Map.Entry)entry2.next();
                        parentEntity = (DynamicObject)entryMap.get(entry3.getKey());
                        parentEntity.set(entryType.getName(), subEntryMap.get(parentEntity.getPkValue()));
                        entryCollection.add((Object)parentEntity);
                    }
                    String parentEntryName = entryType.getParent().getName();
                    billObject.set(parentEntryName, (Object)entryCollection);
                } else {
                    DynamicObjectCollection entryCollection = new DynamicObjectCollection();
                    for (IntegrationObject entry : groupList) {
                        entryCollection.add((Object)entry.getEntryObject());
                    }
                    billObject.set(entryType.getName(), (Object)new DynamicObjectCollection(entryType, (Object)billObject, (List)entryCollection));
                }
                billCollection.add((Object)billObject);
            }
        } else {
            for (IntegrationObject object : integrationObjectList) {
                billCollection.add((Object)object.getEntryObject());
            }
        }
        return billCollection;
    }
}

