/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.pipeline;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.helper.SnHelper;
import kd.mpscmm.msisv.isomorphism.common.util.MonitorLogUtils;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BotpConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PushPipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.RelationObjectConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.CarrySnInfo;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.ConvertResult;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationGroup;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.SplitResultObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.TargetBillOperator;
import kd.mpscmm.msisv.isomorphism.core.engine.filter.BillFilter;
import kd.mpscmm.msisv.isomorphism.core.engine.generate.BotpBillGenerator;
import kd.mpscmm.msisv.isomorphism.core.engine.group.BillGroup;
import kd.mpscmm.msisv.isomorphism.core.engine.match.BillMatcher;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.AbstractPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.queue.SplitQueue;
import kd.mpscmm.msisv.isomorphism.core.log.service.UnionPushRecordService;
import kd.mpscmm.msisv.isomorphism.core.log.vo.UnionPushRecordObject;
import org.apache.commons.collections4.CollectionUtils;

public enum ListenerPushPipeline implements AbstractPipeline
{
    INSTANCE;

    private static final Log log;

    @Override
    public TargetBillOperator work(PipelineConfig pipelineConfig, List<IntegrationObject> filterDataEntities) {
        log.info("\u5f00\u59cb\u6267\u884c\u76d1\u542c\u4e0b\u63a8");
        PushPipelineConfig pushPipelineConfig = (PushPipelineConfig)pipelineConfig;
        BotpConfig botpConfig = pushPipelineConfig.getBotpConfig();
        RelationObjectConfig relationObjectConfig = pushPipelineConfig.getRelationObjectConfig();
        String entityType = filterDataEntities.get(0).getBillNumber();
        Map<Long, BigDecimal> relRemainQtyMap = UnionPushRecordService.queryPushedRemainQty(pipelineConfig, entityType, filterDataEntities, true);
        MatcherConfig matcherConfig = new MatcherConfig(botpConfig.getSourceBizObjectConfig(), relationObjectConfig.getRelationBizObjectConfig(), relationObjectConfig.getMatcherPropConfigList(), relationObjectConfig.getMatchMethod());
        List<IntegrationObject> srcObjects = BillFilter.filter(filterDataEntities, botpConfig.getSourceFilterCondition());
        if (CollectionUtils.isEmpty(srcObjects)) {
            log.info("botp\u6765\u6e90\u5bf9\u8c61\u4e3a\u7a7a:{}", MonitorLogUtils.getBillNoList(filterDataEntities));
            return null;
        }
        ConvertResult convertResult = BotpBillGenerator.generateBill(pushPipelineConfig.getBotpConfig(), srcObjects);
        List<IntegrationObject> targetObjects = convertResult.getIntegrationObjects();
        if (CollectionUtils.isEmpty(targetObjects)) {
            log.info("botp\u76ee\u6807\u5bf9\u8c61\u4e3a\u7a7a,\u6765\u6e90\u5355\u636e:{}", MonitorLogUtils.getBillNoList(srcObjects));
            throw new KDBizException(MonitorResultLogConst.getBotpTargetEmptyMsg(), new Object[0]);
        }
        List<IntegrationGroup> sourceGroupList = BillGroup.groupBy(matcherConfig, filterDataEntities);
        ArrayList<SplitResultObject> splitResultObjectList = new ArrayList<SplitResultObject>(CollectionUtils.size(sourceGroupList));
        for (IntegrationGroup integrationGroup : sourceGroupList) {
            List<IntegrationObject> relObjects = BillMatcher.match(matcherConfig, integrationGroup.getGroupKey(), integrationGroup.getGroupValues());
            if (CollectionUtils.isEmpty(relObjects)) {
                log.info("\u5173\u8054\u5bf9\u8c61\u5339\u914d\u4e3a\u7a7a:{}", MonitorLogUtils.getBillNoList(integrationGroup.getGroupValues()));
                throw new KDBizException(MonitorResultLogConst.getSrcMatchRelEmptyMsg(), new Object[0]);
            }
            List<IntegrationObject> filterRelObjects = BillFilter.filter(relObjects, relationObjectConfig.getRelationBillFilterExpression());
            if (CollectionUtils.isEmpty(filterRelObjects)) {
                log.info("\u5173\u8054\u5bf9\u8c61\u8fc7\u6ee4\u4e3a\u7a7a:{}", MonitorLogUtils.getBillNoList(relObjects));
                continue;
            }
            List<IntegrationObject> matchTargetObjects = BillMatcher.matchWithBotp(integrationGroup.getGroupValues(), targetObjects);
            if (CollectionUtils.isEmpty(matchTargetObjects)) {
                log.info("\u5339\u914d\u76ee\u6807\u5bf9\u8c61\u4e3a\u7a7a:{}", MonitorLogUtils.getBillNoList(integrationGroup.getGroupValues()));
                continue;
            }
            SplitResultObject splitResultObject = SplitQueue.split(relationObjectConfig, filterRelObjects, matchTargetObjects, false, relRemainQtyMap);
            splitResultObjectList.add(splitResultObject);
        }
        List<DynamicObject> dynamicObjectList = this.assignAllTargetProps(splitResultObjectList, relationObjectConfig.getMasterQtyPropConfig(), relationObjectConfig.getBillAssignConfigList());
        log.info("\u76d1\u542c\u4e0b\u63a8\u5b8c\u6210");
        Map<Long, List<CarrySnInfo>> snInfoMap = SnHelper.buildSnInfo(splitResultObjectList, relationObjectConfig);
        List<UnionPushRecordObject> unionPushRecordObjectList = ListenerPushPipeline.buildUnionPushRecordMap(botpConfig.getSourceBizObjectConfig().getBillNumber(), splitResultObjectList);
        return new TargetBillOperator().setTargetBillList(dynamicObjectList).setSnInfoMap(snInfoMap).setAttachmentInfoMap(convertResult.getAttachmentInfoMap()).setUnionPushRecordList(unionPushRecordObjectList).setOperationConfigList(pushPipelineConfig.getOperationConfigList());
    }

    private static List<UnionPushRecordObject> buildUnionPushRecordMap(String srcBillEntity, List<SplitResultObject> splitResultObjectList) {
        ArrayList<UnionPushRecordObject> unionPushRecordObjectList = new ArrayList<UnionPushRecordObject>(splitResultObjectList.size());
        for (SplitResultObject splitResultObject : splitResultObjectList) {
            List<IntegrationObject> relationObjectList = splitResultObject.getRelationObjectList();
            List<IntegrationObject> targetObjectList = splitResultObject.getTargetObjectList();
            int targetSize = CollectionUtils.size(targetObjectList);
            for (int idx = 0; idx < targetSize; ++idx) {
                IntegrationObject relationObj = relationObjectList.get(idx);
                IntegrationObject targetObj = targetObjectList.get(idx);
                UnionPushRecordObject unionPushRecordObject = new UnionPushRecordObject();
                unionPushRecordObject.setSrcObj(BillMatcher.getSrcLink(srcBillEntity, targetObj));
                unionPushRecordObject.setRelObj(new UnionPushRecordObject.UnionPushEntity(relationObj));
                unionPushRecordObject.setTgtObj(new UnionPushRecordObject.UnionPushEntity(targetObj));
                unionPushRecordObjectList.add(unionPushRecordObject);
            }
        }
        return unionPushRecordObjectList;
    }

    static {
        log = LogFactory.getLog(ListenerPushPipeline.class);
    }
}

