/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.pipeline;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.kdtx.common.idemponent.properties.ConcurrentPolicyEnum;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.ext.provider.BaseECService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.util.IdempotentPropertiesUtils;
import kd.mpscmm.msisv.isomorphism.core.config.vo.ListenerConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IdempotentKey;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.TargetBillOperator;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.AbstractPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.ListenerPushPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.RelationPushPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.RelationUpdatePipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.ServiceInvokePipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.SimplePushPipeline;

public class PipelineAdaptor
extends BaseECService
implements IdempotentService,
AbstractPipeline {
    private static final Log log = LogFactory.getLog(PipelineAdaptor.class);
    private static final String PIPELINE_RESULT = "result";
    private ListenerConfig listenerConfig;
    private String bizNo;
    private List<Long> billIds;

    public PipelineAdaptor(ListenerConfig listenerConfig, String bizNo, List<Long> billIds) {
        this.listenerConfig = listenerConfig;
        this.bizNo = bizNo;
        this.billIds = billIds;
    }

    public DtxResponse execute(Object param, Object lastReturn) throws Exception {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            DtxResponse dtxResponse = super.execute(param, lastReturn);
            return dtxResponse;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public IdempotentProperties getIdempotentProperties(Object param, Object lastReturn) {
        PipelineParam pipelineParam = (PipelineParam)param;
        IdempotentKey idempotentKey = new IdempotentKey();
        idempotentKey.setBizNo(pipelineParam.getBizNo());
        idempotentKey.setEntityNumber(this.listenerConfig.getListenerBizObjectConfig().getBillNumber());
        idempotentKey.setBillIds(this.billIds);
        idempotentKey.setOpKey(this.listenerConfig.getOperateKey());
        idempotentKey.setListenerNumber(this.listenerConfig.getNumber());
        idempotentKey.setActionNumber(pipelineParam.getPipelineConfig().getPipeNumber());
        idempotentKey.setTag(this.getClass().getName());
        IdempotentProperties idempotentProperties = IdempotentPropertiesUtils.generate(this.getClass().getName(), idempotentKey);
        idempotentProperties.setConcurrentPolicy(ConcurrentPolicyEnum.COPY_EXECUTE_RESULT);
        return idempotentProperties;
    }

    protected DtxResponse doExecute(Object param, Object lastReturn) throws Exception {
        PipelineParam pipelineParam = (PipelineParam)param;
        PipelineConfig pipelineConfig = pipelineParam.getPipelineConfig();
        TargetBillOperator targetBillOperator = this.findPipeline(pipelineConfig.getPipeline()).work(pipelineConfig, pipelineParam.getBizObjects());
        CommonDtxResponse commonDtxResponse = new CommonDtxResponse();
        commonDtxResponse.put((Object)PIPELINE_RESULT, (Object)SerializationUtils.serializeToBase64((Object)targetBillOperator));
        return commonDtxResponse;
    }

    private AbstractPipeline findPipeline(String className) {
        if (SimplePushPipeline.class.getName().equals(className)) {
            return SimplePushPipeline.INSTANCE;
        }
        if (ListenerPushPipeline.class.getName().equals(className)) {
            return ListenerPushPipeline.INSTANCE;
        }
        if (RelationPushPipeline.class.getName().equals(className)) {
            return RelationPushPipeline.INSTANCE;
        }
        if (RelationUpdatePipeline.class.getName().equals(className)) {
            return RelationUpdatePipeline.INSTANCE;
        }
        return ServiceInvokePipeline.INSTANCE;
    }

    @Override
    public TargetBillOperator work(PipelineConfig pipelineConfig, List<IntegrationObject> filterDataEntities) {
        PipelineParam pipelineParam = new PipelineParam();
        pipelineParam.setBizNo(this.bizNo);
        pipelineParam.setPipelineConfig(pipelineConfig);
        pipelineParam.setBizObjects(filterDataEntities);
        try {
            CommonDtxResponse commonDtxResponse = (CommonDtxResponse)this.execute(pipelineParam, null);
            String result = commonDtxResponse.getString((Object)PIPELINE_RESULT);
            if (StringUtils.isBlank((CharSequence)result)) {
                return null;
            }
            return (TargetBillOperator)SerializationUtils.deSerializeFromBase64((String)result);
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, MonitorResultLogConst.getPipelineErrorMsg(), new Object[0]);
        }
    }

    public static class PipelineParam {
        private String bizNo;
        private PipelineConfig pipelineConfig;
        private List<IntegrationObject> bizObjects;

        public String getBizNo() {
            return this.bizNo;
        }

        public PipelineParam setBizNo(String bizNo) {
            this.bizNo = bizNo;
            return this;
        }

        public PipelineConfig getPipelineConfig() {
            return this.pipelineConfig;
        }

        public PipelineParam setPipelineConfig(PipelineConfig pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        public List<IntegrationObject> getBizObjects() {
            return this.bizObjects;
        }

        public PipelineParam setBizObjects(List<IntegrationObject> bizObjects) {
            this.bizObjects = bizObjects;
            return this;
        }
    }
}

