/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.pipeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.util.MonitorLogUtils;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MatcherConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.RelationObjectConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.RelationUpdatePipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationGroup;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.SplitResultObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.TargetBillOperator;
import kd.mpscmm.msisv.isomorphism.core.engine.filter.BillFilter;
import kd.mpscmm.msisv.isomorphism.core.engine.group.BillGroup;
import kd.mpscmm.msisv.isomorphism.core.engine.match.BillMatcher;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.AbstractPipeline;
import kd.mpscmm.msisv.isomorphism.core.engine.queue.SplitQueue;
import org.apache.commons.collections4.CollectionUtils;

public enum RelationUpdatePipeline implements AbstractPipeline
{
    INSTANCE;

    private static final Log log;

    @Override
    public TargetBillOperator work(PipelineConfig pipelineConfig, List<IntegrationObject> filterDataEntities) {
        log.info("\u5f00\u59cb\u6267\u884c\u5173\u8054\u66f4\u65b0");
        RelationUpdatePipelineConfig relationUpdatePipelineConfig = (RelationUpdatePipelineConfig)pipelineConfig;
        RelationObjectConfig relationObjectConfig = relationUpdatePipelineConfig.getRelationObjectConfig();
        filterDataEntities = relationObjectConfig.getRelationBizObjectConfig().expand(filterDataEntities);
        MatcherConfig matcherConfig = new MatcherConfig(relationObjectConfig.getRelationBizObjectConfig(), relationUpdatePipelineConfig.getTargetBizObjectConfig(), relationObjectConfig.getMatcherPropConfigList(), "A");
        List<IntegrationObject> relObjects = filterDataEntities;
        List<IntegrationGroup> relGroupList = BillGroup.groupBy(matcherConfig, relObjects);
        ArrayList<SplitResultObject> splitResultObjectList = new ArrayList<SplitResultObject>(CollectionUtils.size(relGroupList));
        for (IntegrationGroup relGroup : relGroupList) {
            List<IntegrationObject> matchTargetObjects = BillMatcher.match(matcherConfig, relGroup.getGroupKey(), relGroup.getGroupValues());
            if (CollectionUtils.isEmpty(matchTargetObjects)) {
                log.info("\u76ee\u6807\u5bf9\u8c61\u5339\u914d\u5931\u8d25:{}", MonitorLogUtils.getBillNoList(relGroup.getGroupValues()));
                throw new KDBizException(MonitorResultLogConst.getRelMatchTargetEmptyMsg(), new Object[0]);
            }
            List<IntegrationObject> filterTargetObjects = BillFilter.filter(matchTargetObjects, relationUpdatePipelineConfig.getTargetBillFilterExpression());
            if (CollectionUtils.isEmpty(filterTargetObjects)) {
                log.info("\u76ee\u6807\u5bf9\u8c61\u8fc7\u6ee4\u4e3a\u7a7a:{}", MonitorLogUtils.getBillNoList(matchTargetObjects));
                throw new KDBizException(MonitorResultLogConst.getFilterTargetEmptyMsg(), new Object[0]);
            }
            SplitResultObject splitResultObject = SplitQueue.split(relationObjectConfig, relGroup.getGroupValues(), filterTargetObjects, true);
            splitResultObjectList.add(splitResultObject);
        }
        List<DynamicObject> dynamicObjectList = this.assignAllTargetProps(splitResultObjectList, relationObjectConfig.getMasterQtyPropConfig(), relationObjectConfig.getBillAssignConfigList());
        log.info("\u5173\u8054\u66f4\u65b0\u5b8c\u6210");
        return new TargetBillOperator().setTargetBillList(dynamicObjectList).setOperationConfigList(relationUpdatePipelineConfig.getOperationConfigList());
    }

    @Override
    public List<DynamicObject> convert2DynamicObject(List<IntegrationObject> integrationObjectList) {
        if (CollectionUtils.isEmpty(integrationObjectList)) {
            return Collections.emptyList();
        }
        DynamicObjectCollection billCollection = new DynamicObjectCollection();
        IntegrationObject integrationObject = integrationObjectList.get(0);
        if (integrationObject.hasEntry()) {
            Map dynamicObjectListMap = integrationObjectList.stream().collect(Collectors.groupingBy(IntegrationObject::getBillPkValue, Collectors.toList()));
            for (List groupList : dynamicObjectListMap.values()) {
                DynamicObject billObject = ((IntegrationObject)groupList.get(0)).getBillObject();
                String entryNumber = integrationObjectList.get(0).getEntryNumber();
                Set entryIdSet = groupList.stream().map(IntegrationObject::getEntryPkValue).collect(Collectors.toSet());
                DynamicObjectCollection newCollection = new DynamicObjectCollection();
                DynamicObjectCollection entryCollection = billObject.getDynamicObjectCollection(entryNumber);
                for (DynamicObject entry : entryCollection) {
                    if (entryIdSet.contains(entry.getPkValue())) continue;
                    newCollection.add((Object)entry);
                }
                for (IntegrationObject object : groupList) {
                    newCollection.add((Object)object.getEntryObject());
                }
                billObject.set(entryNumber, (Object)newCollection);
                billCollection.add((Object)billObject);
            }
        } else {
            for (IntegrationObject object : integrationObjectList) {
                billCollection.add((Object)object.getEntryObject());
            }
        }
        return billCollection;
    }

    static {
        log = LogFactory.getLog(RelationUpdatePipeline.class);
    }
}

