/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.pipeline;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.util.MonitorLogUtils;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BotpConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.PushPipelineConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.ConvertResult;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.TargetBillOperator;
import kd.mpscmm.msisv.isomorphism.core.engine.filter.BillFilter;
import kd.mpscmm.msisv.isomorphism.core.engine.generate.BotpBillGenerator;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.AbstractPipeline;
import org.apache.commons.collections4.CollectionUtils;

public enum SimplePushPipeline implements AbstractPipeline
{
    INSTANCE;

    private static final Log log;

    @Override
    public TargetBillOperator work(PipelineConfig pipelineConfig, List<IntegrationObject> filterDataEntities) {
        log.info("\u5f00\u59cb\u6267\u884c\u7b80\u5355\u4e0b\u63a8");
        PushPipelineConfig pushPipelineConfig = (PushPipelineConfig)pipelineConfig;
        BotpConfig botpConfig = pushPipelineConfig.getBotpConfig();
        filterDataEntities = botpConfig.getSourceBizObjectConfig().expand(filterDataEntities);
        List<IntegrationObject> srcObjects = BillFilter.filter(filterDataEntities, botpConfig.getSourceFilterCondition());
        if (CollectionUtils.isEmpty(srcObjects)) {
            log.info("botp\u6765\u6e90\u5bf9\u8c61\u4e3a\u7a7a:{}", MonitorLogUtils.getBillNoList(filterDataEntities));
            throw new KDBizException(MonitorResultLogConst.getFilterSrcEmptyMsg(), new Object[0]);
        }
        ConvertResult convertResult = BotpBillGenerator.generateBill(pushPipelineConfig.getBotpConfig(), srcObjects);
        List<IntegrationObject> targetObjects = convertResult.getIntegrationObjects();
        if (CollectionUtils.isEmpty(targetObjects)) {
            log.info("botp\u76ee\u6807\u5bf9\u8c61\u4e3a\u7a7a,\u6765\u6e90\u5355\u636e:{}", MonitorLogUtils.getBillNoList(srcObjects));
            throw new KDBizException(MonitorResultLogConst.getBotpTargetEmptyMsg(), new Object[0]);
        }
        List<DynamicObject> dynamicObjectList = this.convert2DynamicObject(targetObjects);
        log.info("\u7b80\u5355\u4e0b\u63a8\u5b8c\u6210");
        return new TargetBillOperator().setTargetBillList(dynamicObjectList).setAttachmentInfoMap(convertResult.getAttachmentInfoMap()).setOperationConfigList(pushPipelineConfig.getOperationConfigList());
    }

    static {
        log = LogFactory.getLog(SimplePushPipeline.class);
    }
}

