/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.queue;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msisv.isomorphism.common.consts.MonitorResultLogConst;
import kd.mpscmm.msisv.isomorphism.common.helper.PriceAlgorithmHelper;
import kd.mpscmm.msisv.isomorphism.common.util.UnitConvertUtils;
import kd.mpscmm.msisv.isomorphism.core.config.vo.BillAssignConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.MasterQtyPropConfig;
import kd.mpscmm.msisv.isomorphism.core.config.vo.RelationObjectConfig;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.AbstractPropAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.AccumulateAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.CumulateAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.assign.ProportionSplitAssigner;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.IntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.SplitIntegrationObject;
import kd.mpscmm.msisv.isomorphism.core.engine.bo.SplitResultObject;
import kd.mpscmm.msisv.isomorphism.core.engine.pipeline.ListenerPushPipeline;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class SplitQueue {
    private static final Log log = LogFactory.getLog(ListenerPushPipeline.class);

    public static SplitResultObject split(RelationObjectConfig relationObjectConfig, List<IntegrationObject> relationIntegrationObjects, List<IntegrationObject> targetIntegrationObjects, boolean isRelationUpdate) {
        return SplitQueue.split(relationObjectConfig, relationIntegrationObjects, targetIntegrationObjects, isRelationUpdate, Collections.emptyMap());
    }

    private static void generateIds(SplitResultObject splitResultObject) {
        ArrayList<IntegrationObject> todoNewIds = new ArrayList<IntegrationObject>(splitResultObject.getTargetObjectList().size());
        for (IntegrationObject integrationObject : splitResultObject.getTargetObjectList()) {
            Long id = integrationObject.hasEntry() ? (Long)integrationObject.getEntryPkValue() : (Long)integrationObject.getBillPkValue();
            if (0L != id) continue;
            todoNewIds.add(integrationObject);
        }
        if (CollectionUtils.isEmpty(todoNewIds)) {
            return;
        }
        long[] ids = DB.genGlobalLongIds((int)todoNewIds.size());
        for (int i = 0; i < todoNewIds.size(); ++i) {
            IntegrationObject todoNewId = (IntegrationObject)todoNewIds.get(i);
            if (todoNewId.hasEntry()) {
                todoNewId.getEntryObject().set("id", (Object)ids[i]);
                continue;
            }
            todoNewId.getBillObject().set("id", (Object)ids[i]);
        }
    }

    private static List<IntegrationObject> split(IntegrationObject targetObject, List<BillAssignConfig> billAssignConfigList, String masterQtyPropName, BigDecimal splitValue) {
        IntegrationObject originObject = targetObject instanceof SplitIntegrationObject ? ((SplitIntegrationObject)targetObject).getOriginObject() : targetObject.copy(true);
        ArrayList<IntegrationObject> list = new ArrayList<IntegrationObject>();
        IntegrationObject remindObject = targetObject.copy(false);
        IntegrationObject firstRow = targetObject;
        firstRow.setPropValue(masterQtyPropName, splitValue);
        SplitIntegrationObject proportionObject = SplitQueue.calcProportion(new SplitIntegrationObject(originObject, firstRow), billAssignConfigList, masterQtyPropName);
        remindObject = SplitQueue.calcRemind(remindObject, proportionObject, billAssignConfigList, masterQtyPropName);
        list.add(remindObject);
        list.add(proportionObject);
        return list;
    }

    private static SplitIntegrationObject calcProportion(SplitIntegrationObject targetObject, List<BillAssignConfig> billAssignConfigList, String targetMasterQtyPropName) {
        IntegrationObject originObject = targetObject.getOriginObject();
        targetObject = (SplitIntegrationObject)PriceAlgorithmHelper.calcAlgorithm(targetObject, targetMasterQtyPropName);
        BigDecimal targetMasterQty = (BigDecimal)targetObject.getPropValue(targetMasterQtyPropName);
        BigDecimal originTargetMasterQty = targetObject.getOriginMasterQty(targetMasterQtyPropName);
        for (BillAssignConfig billAssignConfig : billAssignConfigList) {
            String propName = billAssignConfig.getTargetPropName();
            AbstractPropAssigner abstractPropAssigner = AbstractPropAssigner.findAssigner(billAssignConfig.getValueAssigner());
            BigDecimal realTargetMasterQty = originTargetMasterQty;
            if (targetMasterQty.compareTo(originTargetMasterQty) > 0 && (abstractPropAssigner instanceof AccumulateAssigner || abstractPropAssigner instanceof CumulateAssigner)) {
                realTargetMasterQty = targetMasterQty;
            }
            BigDecimal targetObjectPropValue = (BigDecimal)originObject.getPropValue(propName, BigDecimal.ZERO);
            BigDecimal proportionValue = targetMasterQty.multiply(targetObjectPropValue).divide(realTargetMasterQty, 10, RoundingMode.HALF_UP);
            Object precisionVal = AbstractPropAssigner.precision(targetObject, propName, proportionValue);
            targetObject.setPropValue(propName, precisionVal);
        }
        return targetObject;
    }

    private static SplitIntegrationObject calcRemind(IntegrationObject preValueObject, SplitIntegrationObject proportionObject, List<BillAssignConfig> billAssignConfigList, String targetMasterQtyPropName) {
        IntegrationObject remindObject = preValueObject.copy(false);
        BigDecimal preValueMasterQty = (BigDecimal)preValueObject.getPropValue(targetMasterQtyPropName);
        BigDecimal proportionMasterQty = (BigDecimal)proportionObject.getPropValue(targetMasterQtyPropName);
        remindObject.setPropValue(targetMasterQtyPropName, preValueMasterQty.subtract(proportionMasterQty));
        for (BillAssignConfig billAssignConfig : billAssignConfigList) {
            String propName = billAssignConfig.getTargetPropName();
            BigDecimal preValue = (BigDecimal)preValueObject.getPropValue(propName, BigDecimal.ZERO);
            BigDecimal proportionValue = (BigDecimal)proportionObject.getPropValue(propName, BigDecimal.ZERO);
            BigDecimal remindValue = preValue.subtract(proportionValue);
            Object precisionVal = AbstractPropAssigner.precision(remindObject, propName, remindValue);
            remindObject.setPropValue(propName, precisionVal);
        }
        return new SplitIntegrationObject(proportionObject.getOriginObject(), remindObject);
    }

    public static SplitResultObject split(RelationObjectConfig relationObjectConfig, List<IntegrationObject> relationIntegrationObjects, List<IntegrationObject> targetIntegrationObjects, boolean isRelationUpdate, Map<Long, BigDecimal> remainMap) {
        IntegrationObject targetObj;
        log.info("\u5f00\u59cb\u6267\u884c\u62c6\u5206");
        if (null == remainMap) {
            remainMap = Collections.emptyMap();
        }
        SplitResultObject splitResultObject = new SplitResultObject();
        MasterQtyPropConfig masterQtyPropConfig = relationObjectConfig.getMasterQtyPropConfig();
        String targetMasterQtyPropName = masterQtyPropConfig.getTargetBillMasterQtyPropName();
        String relationMasterQtyPropName = masterQtyPropConfig.getRelationBillMasterQtyPropName();
        log.info("\u76ee\u6807\u5bf9\u8c61.\u4e3b\u6570\u91cf[{}],\u5173\u8054\u5bf9\u8c61.\u4e3b\u6570\u91cf[{}]", (Object)targetMasterQtyPropName, (Object)relationMasterQtyPropName);
        List<BillAssignConfig> billAssignConfigList = relationObjectConfig.getBillAssignConfigList();
        billAssignConfigList = billAssignConfigList.stream().filter(item -> {
            AbstractPropAssigner abstractPropAssigner = AbstractPropAssigner.findAssigner(item.getValueAssigner());
            return abstractPropAssigner instanceof AccumulateAssigner || abstractPropAssigner instanceof CumulateAssigner || abstractPropAssigner instanceof ProportionSplitAssigner;
        }).collect(Collectors.toList());
        LinkedList<IntegrationObject> targetQue = new LinkedList<IntegrationObject>(targetIntegrationObjects);
        LinkedList<IntegrationObject> relationQue = new LinkedList<IntegrationObject>(relationIntegrationObjects);
        block0: while ((targetObj = (IntegrationObject)targetQue.pollFirst()) != null) {
            IntegrationObject relationObj;
            BigDecimal targetMasterQtyValue;
            if (isRelationUpdate && relationQue.peekFirst() == null) {
                splitResultObject.addTargetObject(targetObj);
            }
            if ((targetMasterQtyValue = (BigDecimal)targetObj.getPropValue(targetMasterQtyPropName, BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) == 0) continue;
            while ((relationObj = (IntegrationObject)relationQue.pollFirst()) != null) {
                int compareVal;
                BigDecimal oriRelationMasterQtyValue = (BigDecimal)relationObj.getPropValue(relationMasterQtyPropName, BigDecimal.ZERO);
                if (oriRelationMasterQtyValue.compareTo(BigDecimal.ZERO) == 0) {
                    throw new KDBizException(MonitorResultLogConst.getRelMasterQtyEqualZeroErrorMsg(relationObj.getBillNo()), new Object[0]);
                }
                BigDecimal relRemainQty = remainMap.get(relationObj.getEntryPkValue());
                if (null != relRemainQty && relRemainQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                relRemainQty = (BigDecimal)ObjectUtils.defaultIfNull((Object)relRemainQty, (Object)oriRelationMasterQtyValue);
                relationObj = UnitConvertUtils.convertUnit(relationObj, targetObj, masterQtyPropConfig);
                BigDecimal relationMasterQtyValue = (BigDecimal)relationObj.getPropValue(relationMasterQtyPropName, BigDecimal.ZERO);
                if (targetMasterQtyValue.signum() != relationMasterQtyValue.signum()) {
                    relationMasterQtyValue = relationMasterQtyValue.negate();
                }
                if (targetMasterQtyValue.signum() != relRemainQty.signum()) {
                    relRemainQty = relRemainQty.negate();
                }
                if (relRemainQty.abs().compareTo(oriRelationMasterQtyValue.abs()) < 0) {
                    relRemainQty = relationMasterQtyValue.multiply(relRemainQty).divide(oriRelationMasterQtyValue, 10, RoundingMode.HALF_UP);
                }
                if ((compareVal = targetMasterQtyValue.abs().compareTo(relRemainQty.abs())) > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u76ee\u6807\u5bf9\u8c61.\u4e3b\u6570\u91cf[{}] > \u5173\u8054\u5bf9\u8c61.\u4e3b\u6570\u91cf[{}],\u62c6\u5206\u5904\u7406,\u5173\u8054\u5355\u636e\u7f16\u53f7:{}", new Object[]{targetMasterQtyValue, relRemainQty, relationObj.getBillNo()});
                    }
                    List<IntegrationObject> splitTargetObjects = SplitQueue.split(targetObj, billAssignConfigList, targetMasterQtyPropName, relRemainQty);
                    targetQue.addFirst(splitTargetObjects.get(0));
                    splitResultObject.addRelationObject(relationObj);
                    splitResultObject.addTargetObject(splitTargetObjects.get(1));
                    continue block0;
                }
                if (compareVal == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u76ee\u6807\u5bf9\u8c61.\u4e3b\u6570\u91cf[{}] == \u5173\u8054\u5bf9\u8c61.\u4e3b\u6570\u91cf,\u5173\u8054\u5355\u636e\u7f16\u53f7:{}", (Object)targetMasterQtyValue, (Object)relationObj.getBillNo());
                    }
                    targetObj = PriceAlgorithmHelper.calcAlgorithm(targetObj, targetMasterQtyPropName);
                    splitResultObject.addRelationObject(relationObj);
                    splitResultObject.addTargetObject(targetObj);
                    continue block0;
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u76ee\u6807\u5bf9\u8c61.\u4e3b\u6570\u91cf[{}] < \u5173\u8054\u5bf9\u8c61.\u4e3b\u6570\u91cf[{}],\u51fa\u73b0\u8d85\u53d1,\u5173\u8054\u5355\u636e\u7f16\u53f7:{}", new Object[]{targetMasterQtyValue, relRemainQty, relationObj.getBillNo()});
                }
                splitResultObject.addRelationObject(relationObj);
                IntegrationObject overObj = targetObj.copy(false);
                overObj.setPropValue(targetMasterQtyPropName, relRemainQty);
                SplitIntegrationObject proportionObject = SplitQueue.calcProportion(new SplitIntegrationObject(targetObj, overObj), billAssignConfigList, targetMasterQtyPropName);
                splitResultObject.addTargetObject(proportionObject);
                continue block0;
            }
        }
        if (CollectionUtils.isNotEmpty(splitResultObject.getTargetObjectList())) {
            SplitQueue.generateIds(splitResultObject);
        }
        return splitResultObject;
    }
}

