/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msisv.isomorphism.core.engine.tcc;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.KdtxRequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.idemponent.helper.IdempotentServiceHelper;
import kd.bos.kdtx.common.idemponent.properties.ConcurrentPolicyEnum;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.properties.StorageStrategyEnum;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.sdk.api.TCCAdapterService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msisv.isomorphism.common.util.IdempotentPropertiesUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public abstract class BaseServiceInvokeTccService
extends TCCAdapterService
implements IdempotentService {
    private static Log log = LogFactory.getLog(BaseServiceInvokeTccService.class);

    public IdempotentProperties getIdempotentProperties(Object param, Object lastReturn) {
        ServiceInvokerParam serviceInvokerParam = (ServiceInvokerParam)((Object)param);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("bizNo", serviceInvokerParam.getBizNo());
        map.put("entityNumber", serviceInvokerParam.getEntityNumber());
        map.put("opKey", serviceInvokerParam.getOpKey());
        map.put("invokeClass", ((Object)((Object)this)).getClass().getName());
        map.put("tccStep", serviceInvokerParam.getTccStep());
        map.put("xid", KdtxRequestContext.get().getXid());
        return IdempotentPropertiesUtils.generate(((Object)((Object)this)).getClass().getName(), map);
    }

    public void Try(Object param) throws Exception {
        ServiceInvokerParam serviceInvokerParam = (ServiceInvokerParam)((Object)param);
        this.saveLogIds(serviceInvokerParam.getLogIds());
        this.doBizTry(param);
    }

    public DtxResponse confirm(Object param, Object lastReturn) throws Exception {
        if (this instanceof IdempotentService) {
            ServiceInvokerParam serviceInvokerParam = (ServiceInvokerParam)((Object)param);
            serviceInvokerParam.setTccStep("confirm");
            IdempotentProperties idemProp = this.getIdempotentProperties(param, null);
            boolean isConcurrent = IdempotentServiceHelper.idempotent((IdempotentProperties)idemProp);
            if (isConcurrent) {
                return (DtxResponse)IdempotentServiceHelper.getConcurrentResult((IdempotentProperties)idemProp, CommonDtxResponse.class);
            }
            Throwable throwable = null;
            try (TXHandle h = TX.required();){
                DtxResponse dtxResponse = this.doBizConfirm(param, lastReturn);
                String result = JsonUtils.getParasStr((Object)dtxResponse);
                IdempotentServiceHelper.executeCompleted((StorageStrategyEnum)idemProp.getStorageStrategy(), (DBRoute)idemProp.getDbRoute(), (String)idemProp.getIdempotentKey(), (ConcurrentPolicyEnum)idemProp.getConcurrentPolicy(), (String)result);
                this.updateMonitorLog(true, "");
                DtxResponse dtxResponse2 = dtxResponse;
                return dtxResponse2;
            }
            catch (Exception e) {
                try {
                    h.markRollback();
                    log.error("TCC\u670d\u52a1\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
                    IdempotentServiceHelper.executeException((StorageStrategyEnum)idemProp.getStorageStrategy(), (DBRoute)idemProp.getDbRoute(), (String)idemProp.getIdempotentKey());
                    this.updateMonitorLog(false, e.getMessage());
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return this.doBizConfirm(param, lastReturn);
    }

    public void cancel(Object param) throws Exception {
        if (this instanceof IdempotentService) {
            ServiceInvokerParam serviceInvokerParam = (ServiceInvokerParam)((Object)param);
            serviceInvokerParam.setTccStep("cancel");
            IdempotentProperties idemProp = this.getIdempotentProperties(param, null);
            boolean isConcurrent = IdempotentServiceHelper.idempotent((IdempotentProperties)idemProp);
            if (isConcurrent) {
                return;
            }
            Throwable throwable = null;
            try (TXHandle h = TX.required();){
                this.doBizCancel(param);
                IdempotentServiceHelper.executeCompleted((StorageStrategyEnum)idemProp.getStorageStrategy(), (DBRoute)idemProp.getDbRoute(), (String)idemProp.getIdempotentKey(), (ConcurrentPolicyEnum)idemProp.getConcurrentPolicy(), null);
                return;
            }
            catch (Exception e) {
                try {
                    h.markRollback();
                    log.error("TCC\u670d\u52a1\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
                    IdempotentServiceHelper.executeException((StorageStrategyEnum)idemProp.getStorageStrategy(), (DBRoute)idemProp.getDbRoute(), (String)idemProp.getIdempotentKey());
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        this.doBizCancel(param);
    }

    protected abstract void doBizTry(Object var1) throws Exception;

    protected abstract DtxResponse doBizConfirm(Object var1, Object var2) throws Exception;

    protected abstract void doBizCancel(Object var1) throws Exception;

    protected void updateMonitorLog(boolean success, String resultLog) {
        Object[] logs = this.loadLogs();
        if (ArrayUtils.isEmpty((Object[])logs)) {
            return;
        }
        for (Object dynamicObject : logs) {
            dynamicObject.set("isfinish", (Object)true);
            dynamicObject.set("issuccess", (Object)success);
            dynamicObject.set("log_tag", (Object)resultLog);
        }
        try (TXHandle tx = TX.requiresNew((String)"monitorLogTX");){
            log.info("\u8bb0\u5f55\u76d1\u542c\u65e5\u5fd7,\u6570\u91cf:{}", (Object)logs.length);
            SaveServiceHelper.save((DynamicObject[])logs);
        }
    }

    protected void saveLogIds(List<Long> logIds) {
        if (CollectionUtils.isEmpty(logIds)) {
            return;
        }
        Set logIdSet = logIds.stream().map(String::valueOf).collect(Collectors.toSet());
        this.saveData(logIdSet);
    }

    protected DynamicObject[] loadLogs() {
        Set logIdSet = this.loadData();
        if (CollectionUtils.isEmpty((Collection)logIdSet)) {
            return new DynamicObject[0];
        }
        Object[] logIds = (Long[])logIdSet.stream().map(Long::parseLong).toArray(Long[]::new);
        return BusinessDataServiceHelper.load((Object[])logIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"msisv_monitorlog"));
    }

    public static class ServiceInvokerParam
    extends CommonParam {
        private String bizNo;
        private String entityNumber;
        private List<Long> billIds;
        private String opKey;
        private List<Long> logIds;
        private String tccStep;

        public String getBizNo() {
            return this.bizNo;
        }

        public ServiceInvokerParam setBizNo(String bizNo) {
            this.bizNo = bizNo;
            return this;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public ServiceInvokerParam setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
            return this;
        }

        public List<Long> getBillIds() {
            return this.billIds;
        }

        public ServiceInvokerParam setBillIds(List<Long> billIds) {
            this.billIds = billIds;
            return this;
        }

        public String getOpKey() {
            return this.opKey;
        }

        public ServiceInvokerParam setOpKey(String opKey) {
            this.opKey = opKey;
            return this;
        }

        public List<Long> getLogIds() {
            return this.logIds;
        }

        public ServiceInvokerParam setLogIds(List<Long> logIds) {
            this.logIds = logIds;
            return this;
        }

        public String getTccStep() {
            return this.tccStep;
        }

        public ServiceInvokerParam setTccStep(String tccStep) {
            this.tccStep = tccStep;
            return this;
        }
    }
}

